/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.config.BackgroundSequenceConfig;
import com.manageengine.apminsight.agent.config.WebSequenceConfig;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.logging.LoggingConstants;
import com.manageengine.apminsight.agent.rum.RumApi;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.Map;

public class ApplicationConfig
implements JavaAgentConstants,
LoggingConstants {
    private AgentLogger logger;
    public boolean captureSql = SQL_CAPTURE_ENABLED_DV;
    private boolean removeQueryLiterals = SQL_CAPTURED_PARAMETRIZE_DV;
    private float sqlTraceT = SQL_STACKTRACE_THRESHOLD_DV.floatValue();
    private boolean isDTTrackingEnabled = true;
    private WebSequenceConfig webSeqConfig;
    private BackgroundSequenceConfig backgroundSeqConfig;
    public String excludeExceptionsRegex = "";
    public boolean isShowMethodDesc = SHOW_METHOD_DESC_DV;
    private RumApi rumApi;

    public ApplicationConfig(Map<String, Object> agentConfig) {
        this.logger = JavaAgent.logger;
        this.init(agentConfig);
        this.rumApi = new RumApi();
    }

    protected void init(Map<String, Object> agentConfig) throws RuntimeException {
        this.logger.info("Application config initializing..");
        Object tempVar = null;
        tempVar = agentConfig.get("sql.capture.enabled");
        if (tempVar != null) {
            this.captureSql = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("transaction.trace.sql.parametrize")) != null) {
            this.removeQueryLiterals = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("transaction.trace.sql.stacktrace.threshold")) != null) {
            try {
                this.sqlTraceT = Float.parseFloat(tempVar.toString());
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "transaction.trace.sql.stacktrace.threshold", Float.valueOf(this.sqlTraceT));
            }
        }
        if (!StringUtils.isEmptyString((String)(tempVar = agentConfig.get("exceptions.ignore")))) {
            try {
                this.excludeExceptionsRegex = tempVar.toString().trim().replaceAll("\\s", "").replaceAll(",", ".*|") + ".*";
            }
            catch (Exception e) {
                this.excludeExceptionsRegex = tempVar.toString();
            }
            this.logger.info("Exceptions listed to ignore: " + this.excludeExceptionsRegex);
        }
        if ((tempVar = agentConfig.get("distributed.tracing.enabled")) != null) {
            this.isDTTrackingEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if (this.webSeqConfig == null) {
            this.webSeqConfig = new WebSequenceConfig(agentConfig);
        } else {
            this.webSeqConfig.reInitialize(agentConfig);
        }
        if (this.backgroundSeqConfig == null) {
            this.backgroundSeqConfig = new BackgroundSequenceConfig(agentConfig);
        } else {
            this.backgroundSeqConfig.reInitialize(agentConfig);
        }
        tempVar = agentConfig.get("show.method.description");
        if (tempVar != null) {
            this.isShowMethodDesc = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("webtransaction.rum.snippet")) != null) {
            this.rumApi.setRUMSnippet(tempVar.toString());
        }
    }

    public void reInitialize(Map<String, Object> agentConfig) {
        this.init(agentConfig);
    }

    public float getSqlTraceThreshold() {
        return this.sqlTraceT * 1000.0f;
    }

    public boolean shouldRemoveQueryLiterals() {
        return this.removeQueryLiterals;
    }

    public boolean isDistributedTracingEnabled() {
        return this.isDTTrackingEnabled;
    }

    public WebSequenceConfig getWebSeqConfig() {
        return this.webSeqConfig;
    }

    public BackgroundSequenceConfig getBackgroundSeqConfig() {
        return this.backgroundSeqConfig;
    }

    public RumApi getRumApi() {
        return this.rumApi;
    }
}

