/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.AgentState;
import com.manageengine.apminsight.agent.DataCenter;
import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.art.ARTConstants;
import com.manageengine.apminsight.agent.communication.ProxyConfig;
import com.manageengine.apminsight.agent.config.AgentConfigListener;
import com.manageengine.apminsight.agent.config.AgentDebugModeConfig;
import com.manageengine.apminsight.agent.config.AppNameDetector;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.context.ContextNameChanger;
import com.manageengine.apminsight.agent.exception.FatalException;
import com.manageengine.apminsight.agent.instrumentation.InstrumentationFilter;
import com.manageengine.apminsight.agent.jvm.EnvironmentIdentifier;
import com.manageengine.apminsight.agent.jvm.monitor.ThreadMxBeanUtil;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.logging.AgentLoggingInitializer;
import com.manageengine.apminsight.agent.logging.LoggingConfig;
import com.manageengine.apminsight.agent.logging.LoggingConstants;
import com.manageengine.apminsight.agent.sequence.SequenceFilterByName;
import com.manageengine.apminsight.agent.sequence.SequenceNameChanger;
import com.manageengine.apminsight.agent.service.VulnerableJarVersionCollector;
import com.manageengine.apminsight.agent.thread.WorkerThreadFactory;
import com.manageengine.apminsight.agent.tracing.AsyncTracerService;
import com.manageengine.apminsight.agent.util.FileUtil;
import com.manageengine.apminsight.agent.util.HostNameUtil;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.apminsight.agent.util.LRUMap;
import com.manageengine.apminsight.agent.util.SecurityUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.apminsight.agent.util.Utils;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.json.simple.JSONObject;
import com.manageengine.org.json.simple.JSONValue;
import com.manageengine.org.json.simple.parser.JSONParser;
import com.manageengine.org.json.simple.parser.ParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class JavaAgentConfig
implements JavaAgentConstants,
LoggingConstants {
    public static final String AGENT_MAJOR_VERSION = "7.2";
    public static final String AGENT_MINOR_VERSION = "0";
    private File agentInstallDir;
    AgentLogger logger;
    private LoggingConfig loggingConfig;
    private ContextInfoManager contextManager;
    private boolean isContextMonitoringEnabled;
    public volatile boolean agentVerified;
    private int agentPollingInterval = 60;
    private long lastKnownAgentShutdownTime;
    private String applicationName = "";
    private String licenseKey;
    private String[] apmHost;
    private boolean isBehindProxy;
    private static DataCenter dataCenter = DataCenter.US;
    private int agentServerPort = -1;
    private String startupLogDir;
    public boolean isKnownDispatcher = false;
    private Map<String, Object> additionalAgentConfig = new HashMap<String, Object>();
    private Map<String, Object> agentUserConfig = new HashMap<String, Object>();
    private boolean captureSqlByReflection = SQL_CAPTURE_USE_REFLECTION_DV;
    private byte printStatistics = 0;
    private int trackerStoreSize = 500;
    private static final String APMINSIGHT_PKG = "com.manageengine.apminsight.agent";
    private AgentConfigListener configListener;
    public static int maxTrackerInSeq;
    private int maxWebMetricStoreSize = 250;
    private int maxBackgroundMetricStoreSize = 100;
    private int maxDBMetricStoreSize = 500;
    private int maxCustomMetricStoreSize = 100;
    private int seqTraceStoreSize = 30;
    private boolean isCaptureJmxMetricsEnabled = true;
    private boolean isCaptureJVMMetricsEnabled = true;
    private int jvmPollingInterval = 5;
    public int threadDumpMaxDepth = 20;
    private String charsetEncoding = "UTF-8";
    private boolean isDebugModeEnabled = false;
    private boolean isThreadProfilingEnabled = true;
    private int threadProfilingDuration = 300;
    private int threadSamplingInterval = 60;
    private int threadProfilingInterval = 28800;
    private int topNMethodsToInstrumentCount = 50;
    private int profilingStacktraceDepth = 200;
    private boolean isDiagnosticLoggingEnabled = true;
    private boolean isVulnerableJarVersionCheckEnabled = true;
    private boolean isDataCompressionEnabled = true;
    private LRUMap<String, Integer> dropThresholdPerTxn;
    private boolean autoDetectDropThresholdEnabled = true;
    private boolean isSmartPackageFilterEnabled = true;
    private boolean isSmartSamplingEnabled = SMART_SAMPLER_ENABLED_DV;
    private int smartSamplerCPUThreshold = 70;
    private int smartSamplerMemoryThreshold = 70;
    public static boolean captureHostDetails;
    private int componentsPerTxnLimit = 15;
    private String distributedTracingId;
    private boolean enableHostLicense = false;
    private boolean useActualHostname = false;
    private boolean forceStopRumInjection = FORCE_STOP_RUM_INJECTION_DV;
    private boolean isCloudDetectionEnabled = CLOUD_DETECTION_ENABLED_DV;
    private boolean isDataCachingEnabled = false;
    private long dataRetentionThreshold = 3600000L;
    private boolean trackLoops = TRACK_LOOPS_DV;
    private boolean standardizeMemoryPoolNames = false;
    private boolean shouldRtIncludeAsyncTime = true;
    private boolean identifyTags = true;
    private String tempChecksumURL;
    private String tempDownloadURL;
    private boolean isAppManagerAgent;
    private ProxyConfig proxyConfig;
    private boolean isDataExporterEnabled = false;
    private boolean isARTEnabled = false;
    private boolean isOldFormatEnabled = true;
    private String dataExporterHost = "localhost";
    private ARTConstants.SpanType artCaptureSpanType = ART_CAPTURE_SPAN_TYPE_DV;
    private int dataExporterStatusPort = 20021;
    private int dataExporterDataPort = 20022;
    private File instanceDir;
    private String instanceKey;
    private String agentHomePath = "";
    private boolean isAutoAppNameDetectionEnabled = false;
    private boolean canAppendProfileToAutoDetectedAppName = false;
    private boolean isAddedByOneAgent = false;

    public JavaAgentConfig(JavaAgent javaAgent, String options) throws FatalException {
        this.init(javaAgent, options);
        try {
            this.configListener = new AgentConfigListener(this, this.logger);
        }
        catch (Throwable th) {
            this.logger.warn("Unable to initialize AgentConfigListener. Exception: " + th.getMessage());
        }
    }

    public void init(JavaAgent javaAgent, String options) throws RuntimeException, FatalException {
        String mode;
        StringBuilder sb = new StringBuilder("INFO: APM Insight javaagent v");
        sb.append(JavaAgentConfig.getAgentFullVersion());
        sb.append(" successfully hooked up with JVM (PID:");
        sb.append(JavaAgentUtil.getJvmProcessId());
        sb.append(')');
        this.agentInstallDir = JavaAgentUtil.getAgentInstallDirectory();
        if (this.agentInstallDir == null) {
            String errMsg = "APM Insight: SEVERE: Unable to find agent installed directory. Try setting path in apminsight.home";
            JavaAgentUtil.print(errMsg);
            throw new FatalException(errMsg);
        }
        this.agentHomePath = System.getProperty("apminsight.agent.homepath", System.getenv("APMINSIGHT_AGENT_HOMEPATH"));
        this.agentHomePath = !StringUtils.isEmptyString(this.agentHomePath) ? this.agentHomePath + "/JAVA" : this.agentInstallDir.getAbsolutePath();
        this.initInstanceFromJson();
        if (this.instanceDir == null) {
            this.instanceDir = this.agentInstallDir;
        }
        Properties agentConfigProp = null;
        try {
            File confFile = new File(this.getInstanceDir(), "apminsight.conf");
            FileUtil.changePermissions(confFile);
            agentConfigProp = Utils.getContentAsProps(confFile);
            Utils.getContentAsProps(new File(this.getInstanceDir(), "background_transaction.conf"), agentConfigProp);
            this.additionalAgentConfig.putAll(agentConfigProp);
        }
        catch (SecurityException se) {
            throw new FatalException("Agent doesnt have necessary permissions to read/write apminsight.conf file");
        }
        catch (IOException e) {
            String errMsg = "Exception occured while loading configuration files from " + this.getInstanceDir() + "." + e.getMessage();
            throw new FatalException(errMsg);
        }
        if (!StringUtils.isEmptyString(options)) {
            if (options.startsWith("&&")) {
                this.setDynamicLoadingProps(options.substring(2));
            } else {
                String[] options_parts = options.split(":", 2);
                try {
                    String string = this.applicationName = StringUtils.isEmptyString(this.applicationName) ? options_parts[0] : this.applicationName;
                    if (options_parts.length == 2) {
                        this.agentServerPort = this.agentServerPort == -1 ? Integer.parseInt(options_parts[1]) : this.agentServerPort;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception while setting app name/port with values from agent options " + e.getMessage());
                }
            }
        }
        this.initLogging(agentConfigProp);
        JavaAgentUtil.print(sb.toString() + ". For more information check agent logs located at " + agentConfigProp.getProperty("apminsight.log.dir", this.getInstanceDir().getAbsolutePath()));
        this.logger.info(sb.toString());
        this.logger.info("JVM started using command: " + System.getProperty("sun.java.command"));
        Properties oneConfProp = null;
        String oneConfFilePath = System.getProperty("autoprofiler.conf.file", System.getenv("APMINSIGHT_AUTOPROFILER_CONF_FILEPATH"));
        if (!StringUtils.isEmptyString(oneConfFilePath)) {
            this.isAddedByOneAgent = true;
            oneConfProp = new Properties();
            this.setOneAgentConfigs(oneConfFilePath, oneConfProp);
        }
        this.setAutoConfigurations();
        this.logger.log(Level.DEBUG, "APM Insight config: {}", (Object)agentConfigProp);
        this.initAgentRuntimeConfig(agentConfigProp, oneConfProp);
        this.initAgentOneTimeConfValues(agentConfigProp);
        SequenceNameChanger.initialize(new File(this.getInstanceDir(), "transaction_merge_patterns.conf"));
        File confFile = new File(this.getInstanceDir(), "transaction_drop_patterns.conf");
        if (confFile.exists()) {
            try {
                String dropPatterns = FileUtil.getInstance().readCharacterFile(confFile).replaceAll("\n", ",");
                SequenceFilterByName.initialize(dropPatterns);
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Error while reading doing drop patterns configurations. Exception: " + e.getMessage());
            }
        }
        if ((mode = AgentDebugModeConfig.getInstance().getConfig().getProperty("agent.debug.mode")) != null) {
            this.isDebugModeEnabled = Boolean.parseBoolean(mode);
        }
        this.contextManager = ContextInfoManager.getInstance();
        this.isContextMonitoringEnabled = Boolean.parseBoolean(agentConfigProp.getProperty("context.monitoring.enabled"));
        this.logger.info("Context based monitoring enabled: " + this.isContextMonitoringEnabled);
        if (this.isContextMonitoringEnabled) {
            ContextNameChanger.initialize(new File(this.instanceDir, "context_naming_patterns.conf"));
        }
        this.contextManager.createContextInfoIfNotExists("", null, null, agentConfigProp);
        this.initAgentInfoValues(agentConfigProp);
        this.initAgentConfValues(agentConfigProp);
        ThreadMxBeanUtil.initialize();
    }

    private void setAutoConfigurations() {
        String value = System.getProperty("jboss.modules.system.pkgs");
        if (value != null && !value.contains("com.manageengine")) {
            if (!value.equals("")) {
                value = value + ",";
            }
            value = value + "com.manageengine";
            System.setProperty("jboss.modules.system.pkgs", value);
        }
        this.logger.info("All auto-configurations applied");
    }

    private void setDynamicLoadingProps(String options) {
        String[] optionsList;
        for (String o : optionsList = options.split("&&")) {
            String[] thisOption = o.split("=");
            if (StringUtils.isEmptyString(thisOption[1])) continue;
            System.setProperty(thisOption[0], thisOption[1]);
        }
    }

    private void initLogging(Properties agentConfigProp) throws FatalException {
        Level level;
        this.startupLogDir = System.getProperty("apminsight.log.dir", agentConfigProp.getProperty("apminsight.log.dir"));
        if (!this.instanceDir.getAbsolutePath().equals(this.agentInstallDir.getAbsolutePath()) && StringUtils.isEmptyString(this.startupLogDir)) {
            this.startupLogDir = this.instanceDir.getAbsolutePath();
        }
        this.startupLogDir = StringUtils.isEmptyString(this.startupLogDir) ? this.agentHomePath : this.startupLogDir;
        LoggingConfig.STARTUP_LOGGER.setLogDir(this.startupLogDir).setLogFileName(this.constructAndgetLogFileName("startup")).setLogFileNamePattern("apminsight_startup_.*log.*");
        boolean isConsoleLoggingEnabled = agentConfigProp.getProperty("apminsight.console.logger") != null ? Boolean.parseBoolean(agentConfigProp.getProperty("apminsight.console.logger")) : false;
        this.loggingConfig = isConsoleLoggingEnabled ? LoggingConfig.CONSOLE_LOGGER : LoggingConfig.STARTUP_LOGGER;
        String configuredLogLevel = agentConfigProp.getProperty("apminsight.log.level");
        if (!StringUtils.isEmptyString(configuredLogLevel) && (level = Level.getLevel(configuredLogLevel)) != null) {
            this.loggingConfig.setLevel(level);
        }
        LoggingConfig.DIAGNOSTIC_LOGGER.setLogDir(this.startupLogDir).setLogFileName("apminsight_agent_diagnostics_" + JavaAgentUtil.getJvmProcessId() + ".log").setLogFileNamePattern("apminsight_agent_diagnostics_.*log.*");
        AgentLoggingInitializer.getInstance().initialize(this.loggingConfig);
        JavaAgent.logger = this.logger = this.loggingConfig.getLogger();
        this.logger.info("Logging initialized successfully.");
        if (!StringUtils.isEmptyString(this.agentHomePath)) {
            JavaAgent.logger.info("Agent Java Home Path : " + this.agentHomePath);
        }
    }

    public void updateLogging(String startupLogFile) throws FatalException, IOException {
        File thisFile;
        File updatedLogDir = this.getInstanceDir();
        if (!updatedLogDir.exists()) {
            updatedLogDir.mkdirs();
        }
        LoggingConfig.AGENT_LOGGER.setLogDir(updatedLogDir.getAbsolutePath()).setLogFileName(this.constructAndgetLogFileName("agent")).setLogFileNamePattern("apminsight_agent_.*log.*");
        LoggingConfig.DIAGNOSTIC_LOGGER.setLogDir(updatedLogDir.getAbsolutePath());
        this.loggingConfig = LoggingConfig.AGENT_LOGGER;
        this.loggingConfig.setLevel(this.logger.getLevel());
        AgentLoggingInitializer.getInstance().initialize(this.loggingConfig);
        JavaAgent.logger = this.logger = this.loggingConfig.getLogger();
        this.logger.info("Logging updated to " + this.loggingConfig.getLoggerName() + " successfully.");
        if (this.startupLogDir.equals(this.getInstanceDir().getAbsolutePath())) {
            return;
        }
        for (String s : ALL_CONF_FILES) {
            File thisFile2 = new File(this.agentInstallDir, s);
            if (!thisFile2.exists()) continue;
            try {
                FileUtil.fileCopy(thisFile2, new File(updatedLogDir, thisFile2.getName()), false);
            }
            catch (IOException e) {
                JavaAgent.logger.warn("Exception while copying file " + thisFile2.getAbsolutePath() + " into instance dir");
            }
        }
        for (int i = 0; i < Math.max(LoggingConfig.STARTUP_LOGGER.getLogFileCount(), LoggingConfig.DIAGNOSTIC_LOGGER.getLogFileCount()) && (thisFile = new File(this.startupLogDir, LoggingConfig.STARTUP_LOGGER.getLogFileName() + (i >= 1 ? "." + i : ""))).exists(); ++i) {
            try {
                FileUtil.copyAndDelete(thisFile, updatedLogDir, thisFile.getName());
            }
            catch (IOException e) {
                JavaAgent.logger.warn("Exception while moving startup log file " + thisFile.getAbsolutePath() + " into instance dir");
            }
            thisFile = new File(this.startupLogDir, LoggingConfig.DIAGNOSTIC_LOGGER.getLogFileName() + (i >= 1 ? "." + i : ""));
            if (!thisFile.exists()) continue;
            try {
                FileUtil.copyAndDelete(thisFile, updatedLogDir, thisFile.getName());
                continue;
            }
            catch (IOException e) {
                JavaAgent.logger.warn("Exception while moving diagnostic log file " + thisFile.getAbsolutePath() + " into instance dir");
            }
        }
    }

    private void initAgentInfoValues(Map agentConfigProp) throws FatalException {
        boolean isAllDeleted = false;
        try {
            File contextHome;
            String id;
            File pathToAgentInfo = new File(this.getInstanceDir(), "apminsight.info");
            Properties agentInfoProp = Utils.getContentAsProps(pathToAgentInfo);
            if (!(agentInfoProp.isEmpty() || "DOCKER".equals(agentInfoProp.getProperty("host.type")) || StringUtils.isEmptyString(id = agentInfoProp.getProperty("agent.id")))) {
                ContextInfo defaultContext = this.contextManager.getDefaultContextInfo();
                defaultContext.setInstanceID(id, false);
                try {
                    defaultContext.setAgentState(AgentState.getValueOf(agentInfoProp.getProperty("agent.state")));
                }
                catch (IllegalArgumentException e) {
                    defaultContext.setAgentState(AGENT_STATE_DV);
                }
                if (!StringUtils.isEmptyString(agentInfoProp.getProperty("agent.deleted.time"))) {
                    try {
                        defaultContext.agentMarkedForDeleteTime = Long.parseLong(agentInfoProp.getProperty("agent.deleted.time"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!StringUtils.isEmptyString(agentInfoProp.getProperty("agent.shutdown.time"))) {
                    JavaAgent.logger.info("Agent last shutdown time: " + agentInfoProp.getProperty("agent.shutdown.time"));
                }
                if (!StringUtils.isEmptyString(agentInfoProp.getProperty("agent.server.port"))) {
                    this.agentServerPort = Integer.valueOf(agentInfoProp.getProperty("agent.server.port"));
                    JavaAgent.logger.info("Agent server port read from info file: " + this.agentServerPort);
                }
                JavaAgent.logger.info("Initializing the default context " + defaultContext.toString());
                isAllDeleted = defaultContext.isDeleted();
            }
            if ((contextHome = new File(this.getInstanceDir() + File.separator + "apminsight_monitors")).exists()) {
                File[] contexts;
                this.isContextMonitoringEnabled = true;
                for (File context : contexts = contextHome.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                })) {
                    String id2;
                    agentInfoProp = Utils.getContentAsProps(new File(context, "apminsight.info"));
                    if (agentInfoProp.isEmpty() || StringUtils.isEmptyString(id2 = agentInfoProp.getProperty("agent.id"))) continue;
                    ContextInfo contextInfo = this.contextManager.createContextInfoIfNotExists("/" + context.getName(), id2.trim(), agentInfoProp.getProperty("agent.state"), agentConfigProp);
                    if (!StringUtils.isEmptyString(agentInfoProp.getProperty("agent.deleted.time"))) {
                        try {
                            contextInfo.agentMarkedForDeleteTime = Long.parseLong(agentInfoProp.getProperty("agent.deleted.time"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    JavaAgent.logger.info("Initializing the context" + contextInfo.toString());
                    isAllDeleted &= contextInfo.isDeleted();
                }
            }
            if (isAllDeleted) {
                String msg = "Agent is in deleted state. Agent Initialization Aborted!";
                this.logger.log(Level.FATAL, msg);
                throw new FatalException(msg);
            }
        }
        catch (Exception e) {
            JavaAgent.logger.info("Exception while initializing agent info values. " + e.getMessage());
        }
    }

    public void initAgentRuntimeConfig(Properties agentConfigProp, Properties oneAgentConfProp) {
        if (!this.agentVerified) {
            String portValue;
            String key_str = null;
            String iv_str = null;
            if (this.isAddedByOneAgent && oneAgentConfProp != null) {
                this.licenseKey = oneAgentConfProp.getProperty("APMINSIGHT_LICENSEKEY");
                if (!StringUtils.isEmptyString(this.licenseKey)) {
                    try {
                        key_str = oneAgentConfProp.getProperty("APMINSIGHT_AGENT_START_TIME");
                        iv_str = oneAgentConfProp.getProperty("APMINSIGHT_AGENT_ID");
                    }
                    catch (Exception e) {
                        JavaAgent.logger.error("Error occured when reading Agent ID and start time. " + e.getMessage());
                        throw new RuntimeException("Invalid properties from One Agent before getting license key.");
                    }
                } else {
                    JavaAgent.logger.warn("One agent conf file found. But license key not found ! ");
                }
            } else {
                this.licenseKey = agentConfigProp.getProperty("license.key");
                String string = this.licenseKey = StringUtils.isEmptyString(this.licenseKey) ? System.getProperty("apminsight.license.key", System.getenv("S247_LICENSE_KEY")) : this.licenseKey;
            }
            if (StringUtils.isEmptyString(this.licenseKey)) {
                this.logger.log(Level.FATAL, "Valid value for key \"{}\" must be set.", (Object)"license.key");
                throw new RuntimeException("license.key is invalid.");
            }
            this.licenseKey = StringUtils.efficientTrim(this.licenseKey);
            try {
                this.licenseKey = SecurityUtil.decryptString(this.licenseKey, key_str, iv_str);
            }
            catch (Exception e) {
                this.logger.debug("Decryption failed : " + e.getMessage());
            }
            if (this.licenseKey.startsWith("APMI_")) {
                this.isAppManagerAgent = true;
                this.isDataCompressionEnabled = false;
                this.standardizeMemoryPoolNames = true;
                this.identifyTags = false;
                if (!this.licenseKey.matches("^APMI_[A-Fa-f0-9]{64}$")) {
                    this.logger.log(Level.FATAL, "Invalid license key provided. Kindly provide correct one");
                    throw new RuntimeException("license.key property is invalid.");
                }
            }
            this.distributedTracingId = this.generateDTId();
            dataCenter = JavaAgentUtil.getDataCenter(this.licenseKey);
            if (StringUtils.isEmptyString(this.applicationName)) {
                if (!StringUtils.isEmptyString(System.getProperty("apminsight.application.name"))) {
                    this.applicationName = System.getProperty("apminsight.application.name");
                } else {
                    this.applicationName = agentConfigProp.getProperty("application.name");
                    if (this.isAddedByOneAgent && this.applicationName.equals("My Application")) {
                        this.applicationName = "";
                    }
                }
            }
            if (this.agentServerPort == -1 && !StringUtils.isEmptyString(portValue = System.getProperty("apminsight.agent.server.port", System.getenv("APMINSIGHT_PORT")))) {
                try {
                    this.agentServerPort = Integer.parseInt(portValue);
                }
                catch (NumberFormatException e) {
                    JavaAgent.logger.warn("Invalid agent server port provided: " + portValue + ".Checking for valid port from conf file.");
                }
            }
            if (this.agentServerPort == -1) {
                portValue = agentConfigProp.getProperty("agent.server.port");
                if (!StringUtils.isEmptyString(portValue)) {
                    try {
                        this.agentServerPort = Integer.parseInt(portValue);
                        if (this.isAddedByOneAgent && this.agentServerPort == 8080) {
                            this.agentServerPort = -1;
                        }
                    }
                    catch (NumberFormatException e) {
                        JavaAgent.logger.warn("Invalid agent server port provided in conf file. Proceeding with default port.");
                    }
                } else {
                    JavaAgent.logger.warn("Agent server port not found in any source. Proceeding with default port.");
                }
            }
            if (this.agentServerPort != -1) {
                this.logger.info("Agent Server port: " + this.agentServerPort);
            }
            this.useActualHostname = Boolean.parseBoolean(agentConfigProp.getProperty("use.actual.hostname"));
            this.enableHostLicense = Boolean.parseBoolean(agentConfigProp.getProperty("hostlicense.apply"));
        }
        this.initConnectionConfig(agentConfigProp);
        try {
            JavaAgentUtil.encryptSensitiveData(new File(this.instanceDir, "apminsight.conf"));
        }
        catch (Exception ex) {
            this.logger.log(Level.WARN, "Exception: " + ex.getMessage(), ex);
        }
    }

    void initConnectionConfig(Properties agentConfigProp) {
        block11: {
            if (System.getProperties().containsKey("apminsight.apm.host") || agentConfigProp.containsKey("apm.host") || System.getenv("APMINSIGHT_HOST") != null) {
                String allHosts = System.getProperty("apminsight.apm.host", !StringUtils.isEmptyString(System.getenv("APMINSIGHT_HOST")) ? System.getenv("APMINSIGHT_HOST") : agentConfigProp.getProperty("apm.host"));
                if (StringUtils.isEmptyString(allHosts = StringUtils.efficientTrim(allHosts))) {
                    this.logger.log(Level.FATAL, "Valid value for key \"{}\" must be set.", (Object)"apm.host");
                    throw new RuntimeException("apm.host property must be set.");
                }
                this.logger.info("apm.host configured: " + allHosts);
                this.apmHost = (String[])Arrays.stream(allHosts.split(",")).map(host -> host.endsWith("/") ? host.substring(0, host.length() - 1) : host).toArray(String[]::new);
            } else {
                this.apmHost = new String[]{dataCenter.getCollectorDomain()};
            }
            boolean bl = this.isBehindProxy = System.getProperty("apminsight.agent.proxy", System.getenv("APMINSIGHT_PROXY_URL")) != null ? true : Boolean.parseBoolean(agentConfigProp.getProperty("behind.proxy"));
            if (this.isBehindProxy) {
                try {
                    String proxyStr = System.getProperty("apminsight.agent.proxy", System.getenv("APMINSIGHT_PROXY_URL"));
                    if (!StringUtils.isEmptyString(proxyStr)) {
                        int toBeIgnored = proxyStr.indexOf("://");
                        String[] info = (proxyStr = toBeIgnored > -1 ? proxyStr.substring(toBeIgnored + 3) : proxyStr).split("@");
                        if (info.length > 1) {
                            String[] user = info[0].split(":");
                            String[] host2 = info[1].split(":");
                            this.proxyConfig = new ProxyConfig(host2[0], host2[1], user[0], user[1]);
                        } else {
                            String[] host3 = info[0].split(":");
                            this.proxyConfig = new ProxyConfig(host3[0], host3[1], "", "");
                        }
                        break block11;
                    }
                    String pswd = agentConfigProp.getProperty("proxy.auth.password", "");
                    try {
                        String plainText = SecurityUtil.decryptString(pswd, this.licenseKey, null);
                        pswd = plainText != null ? plainText : pswd;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.proxyConfig = new ProxyConfig(agentConfigProp.getProperty("proxy.server.host"), agentConfigProp.getProperty("proxy.server.port"), agentConfigProp.getProperty("proxy.auth.username", ""), pswd);
                }
                catch (Exception e) {
                    this.logger.warn("Ignoring Proxy details. " + e.getMessage());
                    this.isBehindProxy = false;
                }
            }
        }
    }

    void initAgentConfValues(Map<String, Object> agentConfig) throws RuntimeException {
        AsyncTracerService.getInstance().init(agentConfig);
        Object tempVar = null;
        tempVar = agentConfig.get("diagnostic.logging.enabled");
        if (tempVar != null) {
            this.isDiagnosticLoggingEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("checksum.fetch.url")) != null) {
            this.tempChecksumURL = tempVar.toString().trim();
        }
        if ((tempVar = agentConfig.get("agent.download.url")) != null) {
            this.tempDownloadURL = tempVar.toString().trim();
        }
        if ((tempVar = agentConfig.get("data.compression.enabled")) != null) {
            this.isDataCompressionEnabled = Boolean.parseBoolean(tempVar.toString());
            this.logger.info("Data Compression enabled: " + this.isDataCompressionEnabled);
        }
        if ((tempVar = agentConfig.get("agent.polling.interval")) != null) {
            try {
                this.agentPollingInterval = Integer.parseInt(tempVar.toString());
                this.agentPollingInterval = this.agentPollingInterval < 60 ? 60 : this.agentPollingInterval;
                this.logger.log(Level.INFO, "Agent Polling Interval set to " + this.agentPollingInterval / 60 + " minute(s)");
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "agent.polling.interval", this.agentPollingInterval);
            }
        }
        if ((tempVar = agentConfig.get("old.format.enabled")) != null) {
            this.isOldFormatEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("capture.all.traces")) != null) {
            this.isARTEnabled = Boolean.parseBoolean(tempVar.toString());
            this.logger.info("ART Enabled: " + this.isARTEnabled);
            agentConfig.put("smart.sampler.enabled", Boolean.FALSE);
        }
        if ((tempVar = agentConfig.get("art.capture.span.type")) != null) {
            this.artCaptureSpanType = ARTConstants.SpanType.valueOf(tempVar.toString());
            this.logger.info("ART configured to capture: " + this.artCaptureSpanType.name());
        }
        if ((tempVar = agentConfig.get("data.exporter.enabled")) != null) {
            this.isDataExporterEnabled = Boolean.parseBoolean(tempVar.toString());
            this.logger.info("Data exporter enabled: " + this.isDataExporterEnabled);
        }
        if (this.isDataExporterEnabled) {
            tempVar = agentConfig.get("data.exporter.host");
            if (tempVar != null) {
                this.dataExporterHost = tempVar.toString().trim();
            }
            if ((tempVar = agentConfig.get("data.exporter.status.port")) != null) {
                try {
                    this.dataExporterStatusPort = Integer.parseInt(tempVar.toString());
                }
                catch (Exception e) {
                    this.dataExporterStatusPort = 20021;
                }
            }
            if ((tempVar = agentConfig.get("data.exporter.data.port")) != null) {
                try {
                    this.dataExporterDataPort = Integer.parseInt(tempVar.toString());
                }
                catch (Exception e) {
                    this.dataExporterDataPort = 20022;
                }
            }
        }
        if ((tempVar = agentConfig.get("smart.sampler.enabled")) != null) {
            this.isSmartSamplingEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("smart.sampler.cpuThreshold")) != null) {
            try {
                this.smartSamplerCPUThreshold = Integer.parseInt(tempVar.toString());
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "smart.sampler.cpuThreshold", this.smartSamplerCPUThreshold);
            }
        }
        if ((tempVar = agentConfig.get("smart.sampler.usedMemoryThreshold")) != null) {
            try {
                this.smartSamplerMemoryThreshold = Integer.parseInt(tempVar.toString());
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "smart.sampler.usedMemoryThreshold", this.smartSamplerMemoryThreshold);
            }
        }
        if ((tempVar = agentConfig.get("sequence.bag.max.tracker")) != null) {
            try {
                maxTrackerInSeq = Integer.parseInt(tempVar.toString());
            }
            catch (Exception ne) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "sequence.bag.max.tracker", maxTrackerInSeq);
            }
        }
        if ((tempVar = agentConfig.get("agent.print.statistics")) != null) {
            try {
                this.printStatistics = Byte.parseByte(tempVar.toString());
            }
            catch (Exception ne) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "agent.print.statistics", this.printStatistics);
            }
        }
        if ((tempVar = agentConfig.get("transient.rootracker.vault.size")) != null) {
            try {
                this.trackerStoreSize = Integer.parseInt(tempVar.toString());
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "transient.rootracker.vault.size", this.trackerStoreSize);
            }
        }
        if ((tempVar = agentConfig.get("metricstore.metric.bucket.size")) != null) {
            try {
                this.maxWebMetricStoreSize = Integer.parseInt(tempVar.toString());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "metricstore.metric.bucket.size", this.maxWebMetricStoreSize);
            }
        }
        if ((tempVar = agentConfig.get("metricstore.bgmetric.bucket.size")) != null) {
            try {
                this.maxBackgroundMetricStoreSize = Integer.parseInt(tempVar.toString());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "metricstore.bgmetric.bucket.size", this.maxBackgroundMetricStoreSize);
            }
        }
        if ((tempVar = agentConfig.get("metricstore.dbmetric.bucket.size")) != null) {
            try {
                this.maxDBMetricStoreSize = Integer.parseInt(tempVar.toString());
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "metricstore.dbmetric.bucket.size", this.maxDBMetricStoreSize);
            }
        }
        if ((tempVar = agentConfig.get("metricstore.custom.metric.bucket.size")) != null) {
            try {
                this.maxCustomMetricStoreSize = Integer.parseInt(tempVar.toString());
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "metricstore.custom.metric.bucket.size", this.maxCustomMetricStoreSize);
            }
        }
        if ((tempVar = agentConfig.get("transaction.tracestore.size")) != null) {
            try {
                this.seqTraceStoreSize = Integer.parseInt(tempVar.toString());
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "transaction.tracestore.size", this.seqTraceStoreSize);
            }
        }
        if ((tempVar = agentConfig.get("sql.capture.use_reflection")) != null) {
            this.captureSqlByReflection = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("capture.jmx.metrics")) != null) {
            this.isCaptureJmxMetricsEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("jvm.polling.interval")) != null) {
            try {
                this.jvmPollingInterval = Integer.parseInt(tempVar.toString());
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "jvm.polling.interval", this.jvmPollingInterval);
            }
        }
        if ((tempVar = agentConfig.get("capture.jvm.metrics")) != null) {
            this.isCaptureJVMMetricsEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("thread.dump.maxdepth")) != null) {
            try {
                this.threadDumpMaxDepth = Integer.parseInt(tempVar.toString());
                if (this.threadDumpMaxDepth < 1) {
                    this.threadDumpMaxDepth = Integer.MAX_VALUE;
                }
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "thread.dump.maxdepth", this.threadDumpMaxDepth);
            }
        }
        tempVar = agentConfig.get("webtransaction.encoding.charset");
        try {
            if (tempVar != null && Charset.isSupported(tempVar.toString())) {
                this.charsetEncoding = tempVar.toString();
            }
        }
        catch (Throwable th) {
            this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "webtransaction.encoding.charset", this.charsetEncoding);
        }
        tempVar = agentConfig.get("apminsight.log.level");
        if (tempVar != null) {
            this.logger.setLevel(tempVar.toString().toUpperCase());
        }
        if ((tempVar = agentConfig.get("transaction.tracker.drop.threshold.autodetect")) != null) {
            this.autoDetectDropThresholdEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        this.dropThresholdPerTxn = this.autoDetectDropThresholdEnabled ? new LRUMap(25) : null;
        tempVar = agentConfig.get("thread.profiling.enabled");
        if (tempVar != null) {
            this.isThreadProfilingEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("thread.profiling.duration")) != null) {
            try {
                this.threadProfilingDuration = Integer.parseInt(tempVar.toString());
            }
            catch (Throwable th) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "thread.profiling.duration", this.threadProfilingDuration);
            }
        }
        if ((tempVar = agentConfig.get("thread.sampling.interval")) != null) {
            try {
                this.threadSamplingInterval = Integer.parseInt(tempVar.toString());
                if (this.threadSamplingInterval < 60) {
                    this.threadSamplingInterval = 60;
                    this.logger.log(Level.WARN, "Thread Sampling interval is too low, this may affect your application performance. Setting it to 60");
                }
            }
            catch (Throwable th) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "thread.sampling.interval", this.threadSamplingInterval);
            }
        }
        if ((tempVar = agentConfig.get("thread.profiling.interval")) != null) {
            try {
                this.threadProfilingInterval = Integer.parseInt(tempVar.toString());
            }
            catch (Throwable th) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "thread.profiling.interval", this.threadProfilingInterval);
            }
        }
        if ((tempVar = agentConfig.get("profiling.top.method.count")) != null) {
            try {
                this.topNMethodsToInstrumentCount = Integer.parseInt(tempVar.toString());
            }
            catch (Throwable th) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "profiling.top.method.count", this.topNMethodsToInstrumentCount);
            }
        }
        if ((tempVar = agentConfig.get("profiling.stacktrace.depth")) != null) {
            try {
                this.profilingStacktraceDepth = Integer.parseInt(tempVar.toString());
            }
            catch (Throwable th) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "profiling.stacktrace.depth", this.profilingStacktraceDepth);
            }
        }
        if ((tempVar = agentConfig.get("smart.package.filter.enabled")) != null) {
            this.isSmartPackageFilterEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("capture.externalcalls.hostdetails")) != null) {
            captureHostDetails = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("transaction.component.store.size")) != null) {
            try {
                this.componentsPerTxnLimit = Integer.parseInt(tempVar.toString());
            }
            catch (Throwable th) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "transaction.component.store.size", this.componentsPerTxnLimit);
            }
        }
        if ((tempVar = agentConfig.get("vulnerable.jar.check.enabled")) != null) {
            this.isVulnerableJarVersionCheckEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("forcestop.rum.injection")) != null) {
            this.forceStopRumInjection = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("cloud.detection.enabled")) != null) {
            this.isCloudDetectionEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("transaction.trace.track.loop")) != null) {
            this.trackLoops = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("rt.include.async.time")) != null) {
            this.shouldRtIncludeAsyncTime = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("data.retention")) != null) {
            this.isDataCachingEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("data.retention.time")) != null) {
            this.setDataRetentionThreshold(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("auto.appname.enabled")) != null) {
            this.isAutoAppNameDetectionEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("append.profile.autoappname")) != null) {
            this.canAppendProfileToAutoDetectedAppName = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("identify.tags")) != null) {
            this.identifyTags = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("standardize.memory.pools")) != null) {
            this.standardizeMemoryPoolNames = Boolean.parseBoolean(tempVar.toString());
        }
        Object object = tempVar = StringUtils.isEmptyString((String)(tempVar = System.getProperty("site24x7.monitor.group", (String)agentConfig.get("application.group.name")))) ? System.getenv("APMINSIGHT_MONITOR_GROUP") : tempVar;
        if (!StringUtils.isEmptyString((String)tempVar)) {
            this.additionalAgentConfig.put("application.group.name", (String)tempVar);
        }
        tempVar = StringUtils.isEmptyString((String)(tempVar = System.getProperty("site24x7.tags", (String)agentConfig.get("tags")))) ? System.getenv("APMINSIGHT_TAGS") : tempVar;
        try {
            HashMap<String, String> tagValues = new HashMap<String, String>();
            if (!StringUtils.isEmptyString((String)tempVar)) {
                String[] tags;
                for (String tag : tags = tempVar.toString().split(",")) {
                    String[] keyValue = tag.split(":", 2);
                    tagValues.put(keyValue[0], keyValue[1]);
                }
                this.additionalAgentConfig.put("tags", tagValues);
            }
        }
        catch (Exception e) {
            this.logger.warn("Error while processing tags value. Exception: " + e.getMessage());
            this.additionalAgentConfig.remove("tags");
        }
    }

    void initAgentOneTimeConfValues(Map agentConfigProp) {
        block12: {
            try {
                File customInstrumentationConf = new File(this.getInstanceDir(), "custom_instrumentation.conf");
                Properties props = Utils.getContentAsProps(customInstrumentationConf);
                if (props.isEmpty()) break block12;
                HashMap customInstrumentation = new HashMap();
                for (Map.Entry entry : props.entrySet()) {
                    String component;
                    if (((String)entry.getKey()).matches("com/manageengine/apminsight/agent.*|com/amazonaws.*")) continue;
                    HashMap<String, String> methodsMap = new HashMap<String, String>();
                    String[] methodComponent = ((String)entry.getValue()).replaceAll("\\s+", "").split(":");
                    String string = component = methodComponent.length > 1 ? methodComponent[1] : "DEFAULT";
                    if (methodComponent.length > 0) {
                        for (String method : methodComponent[0].split(",")) {
                            if (method.equals("")) {
                                method = "*";
                                methodsMap.clear();
                                methodsMap.put(method, component);
                                break;
                            }
                            methodsMap.put(method, component);
                        }
                    } else {
                        methodsMap.put("*", "DEFAULT");
                    }
                    customInstrumentation.put(entry.getKey(), methodsMap);
                }
                if (!customInstrumentation.isEmpty()) {
                    this.additionalAgentConfig.put("custom.instrumentation", customInstrumentation);
                    this.logger.info("Custom Instrumentation configurations read and ready to sent to server. " + customInstrumentation);
                } else {
                    this.logger.info("No custom instrumentation configured removing the stock conf file.");
                    customInstrumentationConf.delete();
                }
            }
            catch (Throwable th) {
                this.logger.log(Level.WARN, "Error in initializing custom package instrumentation", th);
            }
        }
        try {
            String excludePackages = (String)agentConfigProp.get("exclude.packages");
            if (!StringUtils.isEmptyString(excludePackages)) {
                InstrumentationFilter.updateExclusionPattern(excludePackages);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARN, "Exception in updating exclude patterns.", e);
        }
    }

    private String generateDTId() {
        if (this.distributedTracingId == null) {
            if (this.licenseKey == null || this.licenseKey.length() < 12) {
                this.distributedTracingId = null;
            }
            this.distributedTracingId = this.licenseKey.substring(this.licenseKey.length() - 12);
        }
        return this.distributedTracingId;
    }

    public Map<String, Object> getVMEnvironment() {
        LinkedHashMap<String, Object> vmEnv = new LinkedHashMap<String, Object>();
        vmEnv.put("Agent Install Path", this.agentInstallDir.getAbsolutePath());
        vmEnv.put("Agent Version", JavaAgentConfig.getAgentFullVersion());
        if (this.lastKnownAgentShutdownTime != 0L) {
            vmEnv.put("agent.shutdown.time", this.lastKnownAgentShutdownTime);
        }
        if (this.isVulnerableJarVersionCheckEnabled) {
            VulnerableJarVersionCollector vulnerableJarVersionCollector = VulnerableJarVersionCollector.getInstance();
            vulnerableJarVersionCollector.collectUndetectedJarVersions();
            for (Map.Entry<String, String> entry : vulnerableJarVersionCollector.getAllDetectedJarVersions()) {
                vmEnv.put(entry.getKey() + " Version", entry.getValue().split(" ")[0]);
            }
        }
        try {
            vmEnv.put("OS", System.getProperty("os.name"));
            vmEnv.put("OS Version", System.getProperty("os.version"));
            vmEnv.put("OS Arch", System.getProperty("os.arch"));
            vmEnv.put("Application Server", EnvironmentIdentifier.getAppServer().toString());
            vmEnv.put("JVM Name", System.getProperty("java.vm.name"));
            vmEnv.put("JVM Version", System.getProperty("java.vm.version"));
            vmEnv.put("Java Vendor", System.getProperty("java.vendor"));
            vmEnv.put("Java Version", System.getProperty("java.version"));
            this.logger.info("Java Version: " + System.getProperty("java.version"));
            vmEnv.put("Java Home", System.getProperty("java.home"));
            vmEnv.put("Class Version", System.getProperty("java.class.version"));
            vmEnv.put("IP", HostNameUtil.getIPAddresses());
            this.logger.info("Classpath: " + System.getProperty("java.class.path"));
            this.logger.info("Library Path: " + System.getProperty("java.library.path"));
        }
        catch (Throwable th) {
            this.logger.log(Level.WARN, "JavAgentConfig - Failed to collect jvm information. " + th);
        }
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            double classVersion = Double.parseDouble(System.getProperty("java.class.version"));
            if (classVersion < 53.0) {
                this.logger.info("Boot Classpath: " + runtimeMXBean.getBootClassPath());
            }
            this.logger.info("Java Arguments: " + runtimeMXBean.getInputArguments());
            vmEnv.put("Application Starttime", runtimeMXBean.getStartTime());
            vmEnv.put("Jvm PID", runtimeMXBean.getName().split("@")[0]);
        }
        catch (Throwable th) {
            this.logger.log(Level.WARN, "JavaAgentConfig - Failed to get runtime information.", th);
        }
        try {
            MemoryUsage heapMemoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            vmEnv.put("Heap Initial", JavaAgentUtil.convertBytesToMB(heapMemoryUsage.getInit()));
            vmEnv.put("Heap Maximum", JavaAgentUtil.convertBytesToMB(heapMemoryUsage.getMax()));
            MemoryUsage nonHeapMemoryUsage = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
            vmEnv.put("Non-Heap Initial", JavaAgentUtil.convertBytesToMB(nonHeapMemoryUsage.getInit()));
            vmEnv.put("Non-Heap Maximum", JavaAgentUtil.convertBytesToMB(nonHeapMemoryUsage.getMax()));
        }
        catch (Throwable th) {
            this.logger.log(Level.WARN, "JavaAgentConfig - Failed to get heap/nonheap memory information.", th);
        }
        if (((Object)vmEnv).toString().length() > 25000) {
            vmEnv.remove("Classpath");
            vmEnv.remove("Java Arguments");
        }
        return vmEnv;
    }

    public Map<String, Object> getAgentCollectorSyncConfValues() {
        if (new File(this.getInstanceDir(), "apminsight.conf").exists()) {
            if (this.additionalAgentConfig.containsKey("license.key")) {
                this.additionalAgentConfig.remove("license.key");
                this.additionalAgentConfig.remove("application.name");
                this.additionalAgentConfig.remove("behind.proxy");
                this.additionalAgentConfig.remove("proxy.server.host");
                this.additionalAgentConfig.remove("proxy.server.port");
                this.additionalAgentConfig.remove("proxy.auth.username");
                this.additionalAgentConfig.remove("proxy.auth.password");
                this.additionalAgentConfig.remove("apm.host");
                this.additionalAgentConfig.remove("apm.port");
                this.additionalAgentConfig.remove("apm.protocol.https");
                this.additionalAgentConfig.remove("agent.server.port");
                this.additionalAgentConfig.remove("apminsight.log.dir");
                this.additionalAgentConfig.remove("apminsight.log.level");
                this.additionalAgentConfig.remove("apminsight.console.logger");
                this.additionalAgentConfig.remove("hostlicense.apply");
                this.additionalAgentConfig.remove("use.actual.hostname");
                this.additionalAgentConfig.remove("context.monitoring.enabled");
                this.additionalAgentConfig.remove("capture.jvm.metrics");
            }
            if (this.additionalAgentConfig.isEmpty()) {
                return null;
            }
            this.additionalAgentConfig.put("last.modified.time", this.configListener.getLastModifiedTime());
        }
        JavaAgent.logger.info("Additional config : " + this.additionalAgentConfig.toString());
        return this.additionalAgentConfig;
    }

    public void writeAgentInfo(ContextInfo info) {
        if (StringUtils.isEmptyString(info.getInstanceID())) {
            return;
        }
        Properties p = new Properties();
        p.setProperty("agent.id", "" + info.getInstanceID());
        p.setProperty("agent.state", info.getInstanceState().toString());
        p.setProperty("agent.version", JavaAgentConfig.getAgentFullVersion());
        p.setProperty("host.type", EnvironmentIdentifier.getHostType());
        if (info.getInstanceState() == AgentState.MARKED_FOR_DELETE) {
            p.setProperty("agent.deleted.time", String.valueOf(info.agentMarkedForDeleteTime));
        }
        String contextName = info.getContextName();
        String filePath = this.getInstanceDir() + File.separator;
        if (!contextName.isEmpty()) {
            filePath = filePath + "apminsight_monitors" + File.separator + contextName.substring(1) + File.separator;
        }
        try {
            File dir = new File(filePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            filePath = filePath + "apminsight.info";
            Utils.writePropsAsFile(p, filePath);
            this.logger.info("Agent info successfully updated at " + filePath);
            FileUtil.changePermissions(filePath);
            if (new File(this.agentInstallDir, "apminsight.info").exists() && new File(this.getInstanceDir(), "apminsight.info").exists()) {
                new File(this.agentInstallDir, "apminsight.info").delete();
            }
        }
        catch (SecurityException se) {
            this.logger.warn("Unable to set user permissions for info file: " + filePath);
        }
        catch (Throwable ex) {
            this.logger.warn("Unable to write the agent info at " + filePath + ". Exception: " + ex.getMessage() + "APM Insight will continue to work keeping agent info in memory");
        }
    }

    public void refreshNow() {
        if (this.configListener != null) {
            try {
                this.configListener.execute();
            }
            catch (Throwable th) {
                this.logger.warn("Unable to execute configListener. Exception: " + th.getMessage());
            }
        }
    }

    public void reinit() {
        if (this.isDebugModeEnabled) {
            HashMap<String, Object> customConfig = new HashMap<String, Object>(this.agentUserConfig);
            customConfig.putAll(AgentDebugModeConfig.getInstance().getConfig());
            this.initAgentConfValues(customConfig);
        } else {
            this.initAgentConfValues(this.agentUserConfig);
        }
    }

    public int getAgentPollingInterval() {
        return this.agentPollingInterval;
    }

    public boolean isProxyEnabled() {
        return this.isBehindProxy;
    }

    public String getTempChecksumURL() {
        return this.tempChecksumURL;
    }

    public String getTempAgentDownloadURL() {
        return this.tempDownloadURL;
    }

    public AgentLogger getLogger() {
        return this.logger;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public boolean updateNewLicenseKey(String newLicenseKey) {
        try {
            File confFile = new File(this.getInstanceDir(), "apminsight.conf");
            if (!confFile.exists()) {
                System.setProperty("apminsight.license.key", SecurityUtil.encryptString(newLicenseKey, null, null));
                this.logger.info("New license key successfully updated for -Dapminsight.license.key");
            } else {
                Properties configProps = Utils.getContentAsProps(confFile);
                configProps.setProperty("license.key", SecurityUtil.encryptString(newLicenseKey, null, null));
                this.logger.info("New license key successfully updated at " + confFile.getAbsolutePath());
                FileUtil.refillPropertiesFile(confFile, configProps, true);
            }
            this.licenseKey = newLicenseKey;
            return true;
        }
        catch (Exception e) {
            JavaAgent.logger.warn("Exception in updating new license key" + e.getMessage());
            return false;
        }
    }

    public String[] getAPMHost() {
        return this.apmHost;
    }

    public DataCenter getDataCenter() {
        return dataCenter;
    }

    public boolean isDesktopApp() {
        return System.getProperty("APMDesktop") != null;
    }

    public File getAgentInstallDir() {
        return this.agentInstallDir;
    }

    public String getApminsightPkg() {
        return APMINSIGHT_PKG;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public int getAgentServerPort() {
        return this.agentServerPort;
    }

    public void setAgentServerPort(int agentServerPort) {
        this.agentServerPort = agentServerPort;
    }

    public File getInstanceDir() {
        return this.instanceDir;
    }

    public void setInstanceDir(String instanceDirPath) {
        this.instanceDir = new File(instanceDirPath);
    }

    public String getStartupLogDir() {
        return this.startupLogDir;
    }

    public LoggingConfig getLoggingConfig() {
        return this.loggingConfig;
    }

    public byte printAgentStatistics() {
        return this.printStatistics;
    }

    public int getTrackerStoreSize() {
        return this.trackerStoreSize;
    }

    public int getMaxWebMetricStoreSize() {
        return this.maxWebMetricStoreSize;
    }

    public int getMaxBackgroundMetricStoreSize() {
        return this.maxBackgroundMetricStoreSize;
    }

    public int getMaxDBMetricStoreSize() {
        return this.maxDBMetricStoreSize;
    }

    public int getMaxCustomMetricStoreSize() {
        return this.maxCustomMetricStoreSize;
    }

    public int getSeqTraceStoreSize() {
        return this.seqTraceStoreSize;
    }

    public int getJvmPollingInterval() {
        return this.jvmPollingInterval * 60;
    }

    public boolean isCaptureJVMMetricsEnabled() {
        return this.isCaptureJVMMetricsEnabled;
    }

    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public Integer getDropThreshold(String seqNameSpace) {
        try {
            if (this.dropThresholdPerTxn != null) {
                return (Integer)this.dropThresholdPerTxn.get(seqNameSpace);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARN, "Error occurred in get operation in LRUMap. Exception: ", e);
        }
        return null;
    }

    public Integer setDropThreshold(String seqNameSpace, Integer dropThreshold) {
        try {
            if (dropThreshold != null) {
                return this.dropThresholdPerTxn.put(seqNameSpace, dropThreshold);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARN, "Error occurred in put operation in LRUMap. Exception: ", e);
        }
        return null;
    }

    public void clearDropThreshold() {
        if (this.dropThresholdPerTxn != null) {
            this.dropThresholdPerTxn.clear();
            this.logger.debug("Auto drop tracker threshold per transaction data is cleared");
        }
    }

    public boolean isAutoDetectDropThresholdEnabled() {
        return this.autoDetectDropThresholdEnabled;
    }

    public static String getAgentFullVersion() {
        return "7.2.0";
    }

    public boolean isCaptureJmxMetricsEnabled() {
        return this.isCaptureJmxMetricsEnabled;
    }

    public boolean isContextMonitoringEnabled() {
        return this.isContextMonitoringEnabled;
    }

    public int getSmartSamplerCPUThreshold() {
        return this.smartSamplerCPUThreshold;
    }

    public int getSmartSamplerMemoryThreshold() {
        return this.smartSamplerMemoryThreshold;
    }

    public boolean isSmartSamplingEnabled() {
        return this.isSmartSamplingEnabled;
    }

    public boolean isSmartPackageFilterEnabled() {
        return this.isSmartPackageFilterEnabled;
    }

    public int getComponentsPerTxnLimit() {
        return this.componentsPerTxnLimit;
    }

    public boolean canCaptureSqlByReflection() {
        return this.captureSqlByReflection;
    }

    public void updateAdditionalAgentConfig(Map config) {
        this.additionalAgentConfig.clear();
        this.additionalAgentConfig.putAll(config);
    }

    public void updateAgentUserConfig(Map config) {
        this.agentUserConfig.putAll(config);
    }

    public Map<String, Object> getAgentUserConfig() {
        return this.agentUserConfig;
    }

    public boolean isDebugModeEnabled() {
        return this.isDebugModeEnabled;
    }

    public void enableDebugMode() {
        this.isDebugModeEnabled = true;
        try {
            this.reinit();
            this.scheduleDebugModeDisableTask();
            this.logger.info("DEBUG mode has been enabled.");
        }
        catch (Throwable th) {
            this.logger.log(Level.WARN, "Error Occurred while enabling debug mode. Exception: ", th);
        }
    }

    public void scheduleDebugModeDisableTask() {
        int debugModeDuration = AgentDebugModeConfig.getInstance().getDebugModeDuration();
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(WorkerThreadFactory.getInstance());
        executorService.schedule(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("apminsight-debug-mode");
                JavaAgentConfig.this.isDebugModeEnabled = false;
                try {
                    JavaAgentConfig.this.reinit();
                    File debugFile = new File(JavaAgentConfig.this.getInstanceDir(), "debug_mode.conf");
                    HashMap<String, String> resetConfig = new HashMap<String, String>();
                    resetConfig.put("agent.debug.mode", "false");
                    FileUtil.refillPropertiesFile(debugFile, resetConfig, false);
                    JavaAgentConfig.this.configListener.updateLastModifiedTime();
                    JavaAgentConfig.this.logger.info("Debug mode disabled. Agent configurations resetted to user-defined values");
                }
                catch (Throwable th) {
                    JavaAgentConfig.this.logger.log(Level.WARN, "Error Occurred while disabling debug mode. Exception: ", th);
                }
            }
        }, (long)debugModeDuration, TimeUnit.SECONDS);
        this.logger.info("DEBUG mode disable task scheduled to execute in " + debugModeDuration + " seconds.");
    }

    public boolean isVulnerableJarVersionCheckEnabled() {
        return this.isVulnerableJarVersionCheckEnabled;
    }

    public boolean isThreadProfilingEnabled() {
        return this.isThreadProfilingEnabled;
    }

    public boolean isDiagnosticLoggingEnabled() {
        return this.isDiagnosticLoggingEnabled;
    }

    public int getThreadProfilingDuration() {
        return this.threadProfilingDuration;
    }

    public int getThreadSamplingInterval() {
        return this.threadSamplingInterval;
    }

    public int getThreadProfilingInterval() {
        return this.threadProfilingInterval;
    }

    public int getTopNMethodsToInstrumentCount() {
        return this.topNMethodsToInstrumentCount;
    }

    public int getProfilingStacktraceDepth() {
        return this.profilingStacktraceDepth;
    }

    public String getDistributedTracingId() {
        return this.distributedTracingId;
    }

    public boolean isUseActualHostname() {
        return this.useActualHostname;
    }

    public boolean isEnableHostLicense() {
        return this.enableHostLicense;
    }

    public boolean isAppManagerAgent() {
        return this.isAppManagerAgent;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public boolean isDataCompressionEnabled() {
        return this.isDataCompressionEnabled;
    }

    public boolean isForceStopRumInjection() {
        return this.forceStopRumInjection;
    }

    public boolean isCloudDetectionEnabled() {
        return this.isCloudDetectionEnabled;
    }

    public boolean shouldTrackLoops() {
        return this.trackLoops;
    }

    public boolean shouldRtIncludeAsyncTime() {
        return this.shouldRtIncludeAsyncTime;
    }

    public boolean isAutoAppNameDetectionEnabled() {
        return this.isAutoAppNameDetectionEnabled;
    }

    public boolean canAppendProfileToAutoDetectedAppName() {
        return this.canAppendProfileToAutoDetectedAppName;
    }

    public boolean isDataCachingEnabled() {
        return this.isDataCachingEnabled;
    }

    public boolean canIdentifyTags() {
        return this.identifyTags;
    }

    public void setDataRetentionThreshold(String valUnits) {
        switch (Character.toUpperCase(valUnits.charAt(valUnits.length() - 1))) {
            case 'M': {
                this.dataRetentionThreshold = Long.parseLong(valUnits.substring(0, valUnits.length() - 1)) * 60000L;
                break;
            }
            case 'H': {
                this.dataRetentionThreshold = Long.parseLong(valUnits.substring(0, valUnits.length() - 1)) * 3600000L;
                break;
            }
            case 'D': {
                this.dataRetentionThreshold = Long.parseLong(valUnits.substring(0, valUnits.length() - 1)) * 86400000L;
                break;
            }
            default: {
                JavaAgent.logger.warn("Data retention threshold not in accepted format [<value><unit>] (Units : M(minutes)/H(hours)/D(days) ). Proceeding with default threshold of 1 hour");
            }
        }
    }

    public long getDataRetentionThreshold() {
        return this.dataRetentionThreshold;
    }

    private String constructAndgetLogFileName(String logtype) {
        String LOG_FILE_NAME_DATE_FORMAT = "yyyy-MM-dd-HH-mm-ss_Z";
        StringBuilder logFileName = new StringBuilder("apminsight_");
        logFileName.append(logtype + "_");
        logFileName.append(new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss_Z").format(new Date(System.currentTimeMillis())));
        logFileName.append('_');
        logFileName.append(JavaAgentUtil.getJvmProcessId());
        logFileName.append(".log");
        return logFileName.toString();
    }

    public void construct_write_instances_json() {
        File apmInstancesJson = new File(this.agentHomePath, "APM_Java_Instances");
        if (!apmInstancesJson.exists()) {
            apmInstancesJson.mkdirs();
        }
        if (!(apmInstancesJson = new File(apmInstancesJson + File.separator + this.instanceKey + ".json")).exists()) {
            HashMap<String, String> thisinstance = new HashMap<String, String>();
            thisinstance.put("AppName", this.getApplicationName());
            thisinstance.put("InstanceDir", this.getInstanceDir().getAbsolutePath());
            thisinstance.put("RegisteredPort", String.valueOf(this.getAgentServerPort()));
            thisinstance.put("CreationTime", String.valueOf(System.currentTimeMillis()));
            if (StringUtils.isEmptyString(this.instanceKey)) {
                this.instanceKey = this.getValidInstanceKey(this.instanceKey);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.putAll(thisinstance);
            try (FileWriter fileWriter = new FileWriter(apmInstancesJson);){
                JSONValue.writeJSONString(jsonObject, fileWriter);
                JavaAgent.logger.info("Instance details successfully updated to file: " + apmInstancesJson.getAbsolutePath());
            }
            catch (IOException e) {
                JavaAgent.logger.warn("Exception occured when writing to instance json file. " + e.getMessage());
            }
        }
    }

    public boolean isARTEnabled() {
        return this.isARTEnabled;
    }

    public ARTConstants.SpanType getARTCaptureSpanType() {
        return this.artCaptureSpanType;
    }

    public boolean isOldFormatEnabled() {
        return this.isOldFormatEnabled;
    }

    public boolean isDataExporterEnabled() {
        return this.isDataExporterEnabled;
    }

    public String getDataExporterHost() {
        return this.dataExporterHost;
    }

    public int getDataExporterStatusPort() {
        return this.dataExporterStatusPort;
    }

    public int getDataExporterDataPort() {
        return this.dataExporterDataPort;
    }

    private void initInstanceFromJson() {
        File apmInstancesJson = null;
        this.instanceKey = this.getValidInstanceKey(this.instanceKey);
        apmInstancesJson = new File(this.agentHomePath + File.separator + "APM_Java_Instances" + File.separator + this.instanceKey + ".json");
        if (apmInstancesJson.exists()) {
            JSONObject thisinstance = null;
            JSONParser parser = new JSONParser();
            try {
                JSONObject jobj;
                thisinstance = jobj = (JSONObject)parser.parse(new FileReader(apmInstancesJson));
            }
            catch (ParseException | IOException e) {
                JavaAgentUtil.print("Exception occured when reading from instance json file:" + apmInstancesJson.getAbsolutePath() + " " + e.getMessage());
            }
            if (thisinstance != null && !thisinstance.isEmpty()) {
                if (StringUtils.isEmptyString(this.applicationName)) {
                    this.applicationName = (String)thisinstance.get("AppName");
                }
                this.agentServerPort = Integer.valueOf(((String)thisinstance.get("RegisteredPort")).toString());
                this.instanceDir = new File((String)thisinstance.get("InstanceDir"));
            }
        }
    }

    public boolean shouldStandardizeMemoryPoolNames() {
        return this.standardizeMemoryPoolNames;
    }

    public void removeNonNativeConfigs() {
        try {
            String line;
            File confFile = new File(this.getInstanceDir(), "background_transaction.conf");
            if (confFile.exists()) {
                confFile.delete();
                JavaAgent.logger.info("background_transaction.conf file has been deleted successfully.");
            }
            if ((confFile = new File(this.getInstanceDir(), "custom_instrumentation.conf")).exists()) {
                boolean isSuccess = confFile.renameTo(new File(this.getInstanceDir(), "instrumentation.conf"));
                JavaAgent.logger.info("custom_instrumentation.conf file has been renamed: " + isSuccess);
            }
            confFile = new File(this.getInstanceDir(), "apminsight.conf");
            Properties agentConfigProps = Utils.getContentAsProps(confFile);
            agentConfigProps.remove("application.group.name");
            agentConfigProps.remove("tags");
            BufferedReader br = new BufferedReader(new FileReader(confFile));
            StringBuffer fileContent = new StringBuffer();
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) {
                    fileContent.append(line);
                } else {
                    String[] keyValue = (line = line + " ").split("=");
                    if (keyValue.length == 1) {
                        keyValue = line.split(":");
                    }
                    if (keyValue.length != 1 && agentConfigProps.getProperty(keyValue[0].trim()) == null) continue;
                    fileContent.append(line.trim());
                }
                fileContent.append('\n');
            }
            br.close();
            if (fileContent.length() == 0) {
                JavaAgent.logger.warn("Error while updating conf file, content is empty. Aborting write operation to conf file");
                return;
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(confFile));
            out.write(fileContent.toString());
            out.close();
            JavaAgent.logger.info("All additional config properties are removed from apminsight.conf file");
            this.configListener.updateLastModifiedTime();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Error occurred while removing non-native configurations. Exception: " + th.getMessage());
        }
    }

    public void setApplicationName(String appName) {
        this.applicationName = appName;
    }

    public String getValidInstanceKey(String instanceKey) {
        instanceKey = System.getProperty("user.dir");
        instanceKey = StringUtils.isEmptyString(instanceKey) ? System.getProperty("sun.java.command", System.getProperty("java.class.path").split(":")[0]) : instanceKey;
        instanceKey = instanceKey.replaceAll("[/:\\\\.]", "_");
        return instanceKey;
    }

    public void setConfigsBeforeConnect() {
        String identifiedAppName;
        if (this.canIdentifyTags()) {
            AppNameDetector.addMonitorTagsfromSysProps();
        }
        if (StringUtils.isEmptyString(this.applicationName) && this.isAutoAppNameDetectionEnabled() && !StringUtils.isEmptyString(identifiedAppName = AppNameDetector.identifyAppName())) {
            if (this.canAppendProfileToAutoDetectedAppName()) {
                identifiedAppName = AppNameDetector.getIdentifiedTags().get("profile") != null ? identifiedAppName + "-" + AppNameDetector.getIdentifiedTags().get("profile") : identifiedAppName;
            }
            this.setApplicationName(identifiedAppName);
        }
        if (AppNameDetector.getIdentifiedTags() != null && !AppNameDetector.getIdentifiedTags().isEmpty()) {
            this.additionalAgentConfig.putIfAbsent("tags", AppNameDetector.getIdentifiedTags());
        }
    }

    private void setOneAgentConfigs(String oneConfFilePath, Properties oneConfProp) {
        this.logger.info("Java Agent has been added from OneAgent.");
        this.isAutoAppNameDetectionEnabled = true;
        File oneAgentConf = new File(oneConfFilePath);
        if (oneAgentConf.exists()) {
            try {
                oneConfProp.putAll((Map<?, ?>)Utils.getContentAsProps(oneAgentConf));
            }
            catch (IOException e) {
                this.logger.warn("Unable to read props from one agent conf file at " + oneAgentConf.toString());
            }
        } else {
            this.logger.warn("OneAgentConf " + oneAgentConf.getAbsolutePath() + " doesn't exist!");
        }
    }

    static {
        captureHostDetails = true;
        captureHostDetails = true;
        maxTrackerInSeq = 1000;
    }
}

