/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.ApplicationConfig;
import com.manageengine.apminsight.agent.service.AgentServiceConstants;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyTransactionUtil
implements AgentServiceConstants {
    private static Map<String, ApplicationConfig> keyTransactionsConfig;

    public static void initialize(List<Map> keyTxnConfigs) {
        keyTransactionsConfig = new HashMap<String, ApplicationConfig>();
        for (Map txnConfig : keyTxnConfigs) {
            try {
                ApplicationConfig config = new ApplicationConfig((Map)txnConfig.get("config_info"));
                for (String txnName : (List)txnConfig.get("transactions")) {
                    txnName = txnName.replaceAll("\\*", ".*");
                    keyTransactionsConfig.put(txnName, config);
                }
            }
            catch (Throwable th) {
                JavaAgent.logger.log(Level.WARN, "Error occurred in key transaction initialization. Message: " + th.getMessage());
            }
        }
        JavaAgent.logger.info("Key transactions configuration initialized.");
    }

    public static boolean isKeyTransaction(String sequenceName) {
        return KeyTransactionUtil.ifKeyTxnGetConfig(sequenceName) != null;
    }

    public static ApplicationConfig ifKeyTxnGetConfig(String sequenceName) {
        if (keyTransactionsConfig != null) {
            for (Map.Entry<String, ApplicationConfig> entry : keyTransactionsConfig.entrySet()) {
                if (!sequenceName.matches(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

