/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.AbstractSequenceConfig;
import com.manageengine.apminsight.agent.sequence.SequenceFilterByName;
import com.manageengine.apminsight.agent.sequence.SequenceFilterByUrl;
import com.manageengine.apminsight.agent.trackers.http.HttpParamsObfuscator;
import com.manageengine.apminsight.agent.util.SequenceURINormalizer;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.Map;

public class WebSequenceConfig
extends AbstractSequenceConfig {
    private float apdexT = APDEX_THRESHOLD_DV.floatValue();
    private boolean traceInputParamsRecord = TRANSACTION_TRACE_INPUT_PARAMS_RECORD_DV;
    private boolean seqNamingUseRequestURL = false;
    private boolean seqNamingUseMethodName = false;
    private String excludeHttpErrorsRegex = "404";
    private String trackHttpErrorsRegex = "";
    private boolean captureHttpBytes = true;
    private boolean captureHttpHeaders = false;
    private String excludeHttpHeadersRegex = "Accept|Cookie|Cache-Control|Connection|Host|Accept-Encoding";

    public WebSequenceConfig(Map<String, Object> agentConfig) {
        super(agentConfig);
        this.init(agentConfig);
    }

    @Override
    public void init(Map<String, Object> agentConfig) {
        this.logger.info("WebSequenceConfig initializing.");
        Object tempVar = agentConfig.get("webtransaction.tracking.enabled");
        if (tempVar != null) {
            this.isTrackingEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("apdex.threshold")) != null) {
            try {
                this.apdexT = Float.parseFloat(tempVar.toString());
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "apdex.threshold", Float.valueOf(this.apdexT));
            }
        }
        if ((tempVar = agentConfig.get("transaction.trace.enabled")) != null) {
            this.isTraceEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("webtransaction.trace.input.params.record")) != null) {
            this.traceInputParamsRecord = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("transaction.trace.threshold")) != null) {
            try {
                this.traceThreshold = Float.parseFloat(tempVar.toString());
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "transaction.trace.threshold", Float.valueOf(this.traceThreshold));
            }
        }
        if ((tempVar = agentConfig.get("transaction.tracking.request.interval")) != null) {
            try {
                this.samplingFactor = Short.parseShort(tempVar.toString());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "transaction.tracking.request.interval", this.samplingFactor);
            }
        }
        if ((tempVar = agentConfig.get("transaction.skip.listening")) != null) {
            SequenceFilterByUrl.SequenceFilterByUrlExtension.initialize(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("transaction.skip.patterns")) != null) {
            SequenceFilterByName.initialize(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("transaction.trace.duplicate")) != null) {
            this.traceDuplicate = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("webtransaction.tracker.drop.threshold")) != null) {
            try {
                this.trackerDropThreshold = Integer.parseInt(tempVar.toString());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "webtransaction.tracker.drop.threshold", this.trackerDropThreshold);
            }
        }
        if ((tempVar = agentConfig.get("webtransaction.naming.use.requesturl")) != null) {
            this.seqNamingUseRequestURL = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("webtransaction.naming.use.methodname")) != null) {
            this.seqNamingUseMethodName = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("webtransaction.record.cputime.enabled")) != null) {
            this.isTransactionCpuTimeEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("webtransaction.trace.external.components.count.threshold")) != null) {
            try {
                this.traceAfterExternalComponentCount = Integer.parseInt(tempVar.toString());
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "webtransaction.trace.external.components.count.threshold", this.traceAfterExternalComponentCount);
            }
        }
        if ((tempVar = agentConfig.get("webtransaction.record.memory.allocation.enabled")) != null) {
            this.isTransactionMemoryAllocEnabled = Boolean.parseBoolean(tempVar.toString());
        }
        SequenceURINormalizer.initialize(Boolean.parseBoolean((tempVar = agentConfig.get("webtransaction.routeduri.normalize")) == null ? "true" : tempVar.toString()));
        tempVar = agentConfig.get("webtransaction.trace.input.params.ignore");
        if (tempVar != null) {
            HttpParamsObfuscator.intialize(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("http.errors.ignore")) != null) {
            try {
                this.excludeHttpErrorsRegex = tempVar.toString().replaceAll("\\s+", "").replace(',', '|');
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "http.errors.ignore", this.excludeHttpErrorsRegex);
            }
        }
        JavaAgent.logger.info("Http Errors to Ignore: " + this.excludeHttpErrorsRegex);
        tempVar = agentConfig.get("http.errors.track");
        if (tempVar != null) {
            try {
                this.trackHttpErrorsRegex = tempVar.toString().replaceAll("\\s+", "").replace(',', '|');
            }
            catch (Exception e) {
                this.logger.log(Level.WARN, "Invalid value specified for the key \"{}\". APM Insight will use the previous value \"{}\".", "http.errors.track", this.trackHttpErrorsRegex);
            }
        }
        JavaAgent.logger.info("Http Errors to Track: " + this.trackHttpErrorsRegex);
        tempVar = agentConfig.get("capture.http.network.bytes");
        if (tempVar != null) {
            this.captureHttpBytes = Boolean.parseBoolean(tempVar.toString());
        }
        if ((tempVar = agentConfig.get("webtransaction.trace.request.headers.record")) != null) {
            this.captureHttpHeaders = Boolean.parseBoolean(tempVar.toString());
        }
        if (!StringUtils.isEmptyString((String)(tempVar = agentConfig.get("webtransaction.trace.request.headers.ignore")))) {
            this.excludeHttpHeadersRegex = tempVar.toString().replaceAll("\\s+", "").replace(',', '|');
        }
        if (this.isCaptureHttpHeadersEnabled()) {
            this.logger.info("HTTP Headers to ignore: " + this.excludeHttpHeadersRegex.replace("|", ", "));
        }
    }

    public float getApdexThreshold() {
        return this.apdexT * 1000.0f;
    }

    public boolean isRecordSequenceTraceInputParams() {
        return this.traceInputParamsRecord;
    }

    @Override
    public boolean canTraceDuplicate() {
        return this.traceDuplicate;
    }

    public boolean canSeqNamingUseRequestURL() {
        return this.seqNamingUseRequestURL;
    }

    public boolean seqNamingUseMethodName() {
        return this.seqNamingUseMethodName;
    }

    public String getHTTPErrorsToIgnore() {
        return this.excludeHttpErrorsRegex;
    }

    public String getHTTPErrorsToTrack() {
        return this.trackHttpErrorsRegex;
    }

    public boolean isCaptureHttpBytesEnabled() {
        return this.captureHttpBytes;
    }

    public boolean isCaptureHttpHeadersEnabled() {
        return this.captureHttpHeaders;
    }

    public String getExcludeHttpHeadersRegex() {
        return this.excludeHttpHeadersRegex;
    }
}

