/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.context;

import com.manageengine.apminsight.agent.AgentState;
import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.art.ApplicationInfo;
import com.manageengine.apminsight.agent.config.ApplicationConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ContextInfo {
    private String name;
    private String instanceID;
    private AgentState instanceState;
    private ApplicationConfig config;
    private List<Object> contextMetrics;
    private ConcurrentMap<String, Boolean> rumAppKeys;
    private boolean isRegistered = false;
    public long agentMarkedForDeleteTime;
    private ApplicationInfo appInfo;

    protected ContextInfo(String contextName, String instanceID, String instanceState, Map instanceConfig) {
        this.name = contextName;
        this.instanceID = instanceID;
        try {
            this.instanceState = AgentState.getValueOf(instanceState);
        }
        catch (Exception e) {
            this.instanceState = AgentState.MANAGED;
        }
        this.config = new ApplicationConfig(instanceConfig);
        if (this.instanceID != null) {
            this.appInfo = new ApplicationInfo(this.name, this.instanceID);
        }
    }

    public void setAgentState(AgentState state) {
        this.instanceState = state;
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("webtransaction.tracking.enabled", state == AgentState.MANAGED);
        this.updateConfig(config);
    }

    public boolean isActive() {
        return this.instanceState == AgentState.MANAGED;
    }

    public boolean isDeleted() {
        return this.instanceState == AgentState.MARKED_FOR_DELETE || this.instanceState == AgentState.DELETED;
    }

    public AgentState getInstanceState() {
        return this.instanceState;
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    public void updateConfig(Map config) {
        this.config.reInitialize(config);
    }

    public void setInstanceID(String instanceID, boolean isRegistered) {
        this.instanceID = instanceID;
        this.isRegistered = isRegistered;
        this.appInfo = new ApplicationInfo(this.name, this.instanceID);
    }

    public void setInstanceID(String instanceID) {
        this.setInstanceID(instanceID, true);
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public String getContextName() {
        return this.name;
    }

    public void addContextMetric(Object metric) {
        if (this.contextMetrics == null) {
            this.contextMetrics = new ArrayList<Object>();
        }
        this.contextMetrics.add(metric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRumAppKey(String key) {
        if (this.rumAppKeys == null) {
            ContextInfo contextInfo = this;
            synchronized (contextInfo) {
                if (this.rumAppKeys == null) {
                    this.rumAppKeys = new ConcurrentHashMap<String, Boolean>();
                }
            }
        }
        this.rumAppKeys.putIfAbsent(key, Boolean.FALSE);
    }

    public List<String> getRumAppKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        if (this.rumAppKeys != null) {
            for (Map.Entry e : this.rumAppKeys.entrySet()) {
                if (((Boolean)e.getValue()).booleanValue()) continue;
                keys.add((String)e.getKey());
            }
        }
        return keys;
    }

    public ApplicationInfo getAppInfo() {
        return this.appInfo;
    }

    public void markPushedRumAppKeys(List<String> pushedKeys) {
        for (String key : pushedKeys) {
            this.rumAppKeys.put(key, Boolean.TRUE);
        }
    }

    public List<Object> getDataToDispatch() {
        ArrayList<Object> dataToDispatch = new ArrayList<Object>();
        if (this.contextMetrics != null) {
            dataToDispatch.addAll(this.contextMetrics);
            this.contextMetrics.clear();
        }
        return dataToDispatch;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Name: ");
        str.append(this.name);
        str.append("\tState: ");
        str.append(this.instanceState.toString());
        str.append("\tID: ");
        str.append(this.instanceID);
        return str.toString();
    }

    public String getContextLocation() {
        String contextLocation = JavaAgent.getInstance().getAgentConfig().getAgentInstallDir().getAbsolutePath();
        if (!this.name.isEmpty()) {
            contextLocation = contextLocation + File.separator + "apminsight_monitors" + File.separator + this.name.substring(1);
        }
        return contextLocation;
    }
}

