/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.context;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ContextNameChanger {
    private static Map<Pattern, String> namingPatterns = new HashMap<Pattern, String>();

    public static void initialize(Map<String, String> configProp) {
        if (configProp == null || configProp.isEmpty()) {
            JavaAgent.logger.info("[ContextNameChanger] Unable to initialize as the config is " + (configProp == null ? "null" : "empty"));
            return;
        }
        namingPatterns.clear();
        for (Map.Entry<String, String> entry : configProp.entrySet()) {
            String pattern = entry.getKey();
            try {
                Pattern regex = Pattern.compile(pattern.startsWith("/") ? pattern : "/" + pattern);
                namingPatterns.put(regex, entry.getValue().startsWith("/") ? entry.getValue() : "/" + entry.getValue());
            }
            catch (PatternSyntaxException e) {
                JavaAgent.logger.warn("[ContextNameChanger] Invalid regex pattern " + pattern);
            }
        }
        JavaAgent.logger.info("[ContextNameChanger] Initialized with patterns " + namingPatterns);
    }

    public static void initialize(File confFile) {
        if (confFile.exists()) {
            try {
                Properties props = Utils.getContentAsProps(confFile);
                ContextNameChanger.initialize(props);
            }
            catch (IOException ioe) {
                JavaAgent.logger.warn("[ContextNameChanger] Unable to initalize context naming patterns. Exception: " + ioe.getMessage());
            }
        }
    }

    public static String getContextName(String contextName) {
        if (contextName == null || namingPatterns.isEmpty()) {
            return contextName;
        }
        for (Map.Entry<Pattern, String> entry : namingPatterns.entrySet()) {
            Matcher m = entry.getKey().matcher(contextName);
            if (!m.matches()) continue;
            return entry.getValue();
        }
        return contextName;
    }
}

