/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.dataexporter;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.ResponseCodeHandler;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.exception.FatalException;
import com.manageengine.apminsight.agent.service.AgentServiceConstants;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.json.simple.JSONValue;
import com.manageengine.org.json.simple.parser.JSONParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class DataExporterService
implements AgentServiceConstants {
    private static DataExporterService exporter;
    private String exporterHost;
    private int exporterStatusPort;
    private int exporterDataPort;

    private DataExporterService() {
        JavaAgentConfig agentConfig = JavaAgent.getInstance().getAgentConfig();
        this.exporterHost = agentConfig.getDataExporterHost();
        this.exporterStatusPort = agentConfig.getDataExporterStatusPort();
        this.exporterDataPort = agentConfig.getDataExporterDataPort();
    }

    public static DataExporterService getInstance() {
        if (exporter == null) {
            exporter = new DataExporterService();
        }
        return exporter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object sendData(ContextInfo contextInfo, String operation, Object data) {
        boolean isConnect = operation.equals("connect");
        JavaAgent.logger.info("Data being pushed: " + data);
        try (Socket exporter = new Socket(this.exporterHost, isConnect ? this.exporterStatusPort : this.exporterDataPort);){
            OutputStream os = exporter.getOutputStream();
            if (isConnect) {
                this.flushData(os, JSONValue.toJSONString(data));
                JavaAgent.logger.info("Agent registered with data exporter");
                Object object = this.readResponse(contextInfo, exporter.getInputStream());
                return object;
            }
            if (!(data instanceof List)) {
                JavaAgent.logger.warn("Invalid data format received for data port. Data: " + data);
                throw new RuntimeException("Invalid data formar received");
            }
            for (Object obj : (List)data) {
                StringWriter writer = new StringWriter();
                JSONValue.writeJSONString(obj, writer);
                String encodedData = Base64.getEncoder().encodeToString(writer.toString().getBytes());
                this.flushData(os, encodedData);
            }
            JavaAgent.logger.info("Data pushed to exporter. Size: " + ((List)data).size());
            os.close();
            JavaAgent.logger.info("Data dispatched via exporter");
            return null;
        }
        catch (IOException e) {
            JavaAgent.logger.warn("Error while sending data to exporter. Exception: ", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResponse(ContextInfo contextInfo, InputStream inputStream) {
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        try {
            Object response = new JSONParser().parse(in);
            JavaAgent.logger.info("Response received from exporter: " + response);
            Map respMap = (Map)response;
            String id = (String)respMap.get("instance.id");
            contextInfo.setInstanceID(id);
            Object statusCode = respMap.get("instance.status");
            Integer responseCodeAsInt = StringUtils.getAsInteger(statusCode.toString());
            JavaAgent.logger.info("Collector Response Code: " + responseCodeAsInt + '(' + ResponseCodeHandler.getResponseCode(responseCodeAsInt).getResponseMessage() + ')');
            boolean processFurther = ResponseCodeHandler.processResponseCode(contextInfo, responseCodeAsInt);
            if (!processFurther) {
                throw new FatalException("Collector response code: " + responseCodeAsInt + '(' + ResponseCodeHandler.getResponseCode(responseCodeAsInt).getResponseMessage() + "). Cannot proceed further.");
            }
            contextInfo.updateConfig(respMap);
            Map map = respMap;
            return map;
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Unable to parse response data. Exception: " + th.getMessage(), th);
        }
        finally {
            try {
                in.close();
                inputStream.close();
            }
            catch (IOException ioe) {
                JavaAgent.logger.warn("Unable to close response reader. Exception: ", ioe);
            }
        }
        return null;
    }

    private void flushData(OutputStream os, Object data) {
        PrintWriter writer = new PrintWriter(os);
        writer.write(data + "\n");
        writer.flush();
    }
}

