/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.installer;

import com.manageengine.apminsight.agent.util.FileUtil;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AgentInstaller {
    protected String installationFilename;
    private String fileContent;
    protected static boolean isWindowsOS;
    protected static final String LINE_SEPARATOR;
    private final String javaagentArg = "-javaagent:(.*)apminsight-javaagent.jar";

    public AgentInstaller(String installationFile) {
        this.installationFilename = installationFile;
    }

    public abstract boolean installAgent(String var1) throws IOException;

    protected boolean prepareForInstallation() throws IOException {
        if (!new File(this.installationFilename).exists()) {
            JavaAgentUtil.print("\nUnable to locate server startup file. " + this.installationFilename);
            return false;
        }
        this.readFileContent();
        if (this.isAgentAlreadyAdded()) {
            JavaAgentUtil.print("\nJava agent argument already present in file " + this.installationFilename);
            return false;
        }
        if (!this.locateMarker(this.getMarker())) {
            JavaAgentUtil.print("\nUnable to locate line in " + this.installationFilename + " to add java agent argument");
            return false;
        }
        this.backupFile();
        return true;
    }

    private void readFileContent() throws IOException {
        if (this.fileContent == null) {
            this.fileContent = FileUtil.getInstance().readCharacterFile(this.installationFilename);
        }
    }

    protected boolean isAgentAlreadyAdded() throws IOException {
        return this.doesFileContain("-javaagent:(.*)apminsight-javaagent.jar");
    }

    protected abstract String getMarker();

    protected boolean locateMarker(String marker) throws IOException {
        return this.doesFileContain(marker);
    }

    private boolean doesFileContain(String pattern) throws IOException {
        Pattern regex = Pattern.compile("^(.*)" + pattern + "(.*)$", 8);
        return regex.matcher(this.fileContent).find();
    }

    protected void backupFile() throws IOException {
        File targetFile = new File(this.installationFilename);
        File backupFile = new File(targetFile + ".orig");
        if (backupFile.exists()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            backupFile = new File(targetFile + "." + dateFormat.format(new Date()).toString() + ".orig");
        }
        try {
            FileUtil.getInstance().writeCharacterFile(backupFile, this.fileContent);
            JavaAgentUtil.print(MessageFormat.format("Successfully backed up {0} to {1}", targetFile.getName(), backupFile.getName()));
        }
        catch (IOException e) {
            JavaAgentUtil.print("\nUnable to backup file " + targetFile.getName());
            throw e;
        }
    }

    protected abstract String getAgentArgument();

    protected boolean addArgumentAfterMarker(String marker, String argument) throws IOException {
        return this.addArgument(1, marker, argument);
    }

    protected boolean addArgumentBeforeMarker(String marker, String argument) throws IOException {
        return this.addArgument(-1, marker, argument);
    }

    protected boolean addArgumentReplacingMarker(String marker, String argument) throws IOException {
        return this.addArgument(0, marker, argument);
    }

    private boolean addArgument(int position, String marker, String argument) throws IOException {
        String replacement;
        String regex = "^(.*" + marker + ".*)$";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher m = pattern.matcher(this.fileContent);
        if (!m.find()) {
            return false;
        }
        if (position == 0) {
            replacement = (isWindowsOS ? "rem " : "# ") + m.group(1);
            replacement = replacement + LINE_SEPARATOR;
            replacement = replacement + m.group(1).replace(marker, argument);
        } else {
            replacement = position == -1 ? argument + m.group(1) : m.group(1) + argument;
        }
        this.fileContent = m.replaceFirst(replacement);
        this.writeToFile();
        JavaAgentUtil.print("\nJava Agent argument successfully added to " + this.installationFilename);
        return true;
    }

    private void writeToFile() throws IOException {
        FileUtil.getInstance().writeCharacterFile(this.installationFilename, this.fileContent);
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
        isWindowsOS = System.getProperty("os.name").toLowerCase().startsWith("windows");
    }
}

