/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation;

import com.manageengine.apminsight.agent.instrumentation.BasicAnnotationVisitor;
import com.manageengine.apminsight.agent.instrumentation.interceptor.AnnotationInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.MethodInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.org.objectweb.asm.AnnotationVisitor;
import com.manageengine.org.objectweb.asm.ClassVisitor;
import com.manageengine.org.objectweb.asm.MethodVisitor;
import java.util.Deque;
import java.util.List;

public class AnnotationIdentifier
extends ClassVisitor {
    private Deque<InterceptorDefinition> annotatedMethods;
    private List<InterceptorDefinition> interceptors;
    private String className;

    public AnnotationIdentifier(String className, Deque<InterceptorDefinition> annotatedMethods, List<InterceptorDefinition> annotationInterceptors) {
        super(589824);
        this.className = className;
        this.annotatedMethods = annotatedMethods;
        this.interceptors = annotationInterceptors;
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, final String description, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, description, signature, exceptions);
        if (name.matches("<(cl)?init>")) {
            return mv;
        }
        MethodVisitor methodVisitor = new MethodVisitor(589824, mv){

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                if (visible) {
                    for (InterceptorDefinition interceptor : AnnotationIdentifier.this.interceptors) {
                        if (!((AnnotationInterceptorDefinition)interceptor).annotationMatcher.matches(desc)) continue;
                        StringBuilder attributes = new StringBuilder();
                        BasicAnnotationVisitor annotationVisitor = new BasicAnnotationVisitor(589824, av, attributes);
                        AnnotationIdentifier.this.annotatedMethods.addFirst(new AnnotationInterceptorDefinition(interceptor.interceptorName, new ClassMatcher(AnnotationIdentifier.this.className), null, new MethodMatcher(name, description), attributes));
                        return annotationVisitor;
                    }
                }
                return av;
            }
        };
        return methodVisitor;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String description, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(description, visible);
        for (InterceptorDefinition interceptor : this.interceptors) {
            if (!((AnnotationInterceptorDefinition)interceptor).annotationMatcher.matches(description)) continue;
            StringBuilder attributes = new StringBuilder();
            BasicAnnotationVisitor annotationVisitor = new BasicAnnotationVisitor(589824, av, attributes);
            this.annotatedMethods.addLast(new AnnotationInterceptorDefinition(interceptor.interceptorName, new ClassMatcher(this.className), null, MethodInterceptorDefinition.ALL_METHOD_MATCHER, attributes));
            return annotationVisitor;
        }
        return av;
    }
}

