/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.BasicMethodAdapter;
import com.manageengine.apminsight.agent.instrumentation.LoopAdviceAdapter;
import com.manageengine.apminsight.agent.instrumentation.LoopReader;
import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinition;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.objectweb.asm.ClassVisitor;
import com.manageengine.org.objectweb.asm.MethodVisitor;
import java.util.List;

class BasicClassAdapter
extends ClassVisitor {
    private String className;
    private List<InterceptorDefinition> interceptors;
    private final LoopReader loopReader;

    public BasicClassAdapter(ClassVisitor cv, String className, Class<?> classBeingRedefined, List<InterceptorDefinition> bestMatchingInterceptors, List<InterceptorDefinition> otherMatchingInterceptors) {
        this(cv, className, classBeingRedefined, bestMatchingInterceptors, otherMatchingInterceptors, null);
    }

    public BasicClassAdapter(ClassVisitor cv, String className, Class<?> classBeingRedefined, List<InterceptorDefinition> bestMatchingInterceptors, List<InterceptorDefinition> otherMatchingInterceptors, LoopReader loopReader) {
        super(589824, cv);
        this.className = className;
        this.interceptors = bestMatchingInterceptors.size() > 0 ? bestMatchingInterceptors : otherMatchingInterceptors;
        this.loopReader = loopReader;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String description, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, description, signature, exceptions);
        if (name.matches("<(cl)?init>") || (access & 0x400) != 0) {
            return mv;
        }
        for (InterceptorDefinition interceptor : this.interceptors) {
            if (interceptor.excludeMethodMatcher != null && interceptor.excludeMethodMatcher.matches(name, description)) {
                return mv;
            }
            if (!interceptor.includeMethodMatcher.matches(name, description)) continue;
            JavaAgent.logger.log(Level.DEBUG, "Method 2b instrumented: {}.{}{}", this.className, name, description);
            BasicMethodAdapter ma = this.loopReader != null && this.loopReader.isLoopDetected(name, description) ? new LoopAdviceAdapter(this, this.className, mv, access, name, description, interceptor, this.loopReader) : new BasicMethodAdapter(this, this.className, mv, access, name, description, interceptor);
            return ma;
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
    }
}

