/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.instrumentation.AnnotationIdentifier;
import com.manageengine.apminsight.agent.instrumentation.BasicClassAdapter;
import com.manageengine.apminsight.agent.instrumentation.ByteCodeWriter;
import com.manageengine.apminsight.agent.instrumentation.InstrumentationFilter;
import com.manageengine.apminsight.agent.instrumentation.InstrumentationUtil;
import com.manageengine.apminsight.agent.instrumentation.InterceptorDefinitionFactory;
import com.manageengine.apminsight.agent.instrumentation.LoopReader;
import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinitionIndex;
import com.manageengine.apminsight.agent.instrumentation.interceptor.custom.CustomInterceptorDefinition;
import com.manageengine.apminsight.agent.service.VulnerableJarVersionCollector;
import com.manageengine.apminsight.agent.smart.SmartPackageFilter;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.objectweb.asm.ClassReader;
import com.manageengine.org.objectweb.asm.Opcodes;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClassTransformer
implements ClassFileTransformer,
Opcodes {
    private final List<InterceptorDefinition> annotationInterceptors;
    private final InterceptorDefinitionIndex interceptorIndex;
    private JavaAgentConfig agentConfig;
    private boolean isMssqlDriverStatementClassTransformed = false;

    public ClassTransformer(JavaAgent agent) {
        this.agentConfig = agent.getAgentConfig();
        this.interceptorIndex = InterceptorDefinitionIndex.getInstance();
        this.annotationInterceptors = InterceptorDefinitionFactory.getInstance().getAnnotationInterceptors();
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            ClassReader reader;
            JavaAgent.logger.trace((classBeingRedefined == null ? "Loading Clz: " : "Re-transforming clz: ") + className);
            if (className == null || className.startsWith("$") || className.startsWith("$$") || InstrumentationFilter.isExcludedPackage(className)) {
                JavaAgent.logger.log(Level.TRACE, "Loaded class is one of these - proxy, package excluded");
                return null;
            }
            if (className.matches("com/microsoft/sqlserver/jdbc/SQLServerStatement.*")) {
                if (className.equals("com/microsoft/sqlserver/jdbc/SQLServerStatement")) {
                    this.isMssqlDriverStatementClassTransformed = true;
                } else {
                    this.retransformMSSqlStatementClassesIfNotTransformed();
                }
            }
            if (className.equals("org/apache/tomcat/util/scan/StandardJarScanFilter")) {
                JavaAgentUtil.addAgentJarToSkipSet();
            }
            if ((reader = new ClassReader(classfileBuffer)) == null || (reader.getAccess() & 0x200) != 0 && !Arrays.asList(reader.getInterfaces()).contains("com/datastax/oss/driver/api/core/session/Session")) {
                JavaAgent.logger.log(Level.TRACE, "reader null or Loaded class is an interface");
                return null;
            }
            if (this.agentConfig.isVulnerableJarVersionCheckEnabled() && protectionDomain != null) {
                VulnerableJarVersionCollector.getInstance().collectJarVersionIfVulnerable(className, protectionDomain.getCodeSource());
            }
            ArrayDeque<InterceptorDefinition> annotationMatchingInterceptors = new ArrayDeque<InterceptorDefinition>();
            AnnotationIdentifier annotationReader = new AnnotationIdentifier(className, annotationMatchingInterceptors, this.annotationInterceptors);
            reader.accept(annotationReader, InstrumentationUtil.getClassReaderFlags());
            ArrayDeque<InterceptorDefinition> allInterceptorsQueue = annotationMatchingInterceptors;
            List<InterceptorDefinition> matchingInterceptors = this.interceptorIndex.lookup(className, reader.getSuperName(), reader.getInterfaces());
            if (matchingInterceptors.size() == 0 && annotationMatchingInterceptors.size() == 0) {
                JavaAgent.logger.log(Level.TRACE, "No matching point cuts for the class {}", (Object)className);
                return null;
            }
            for (InterceptorDefinition matchingInterceptor : matchingInterceptors) {
                if (matchingInterceptor.includeMethodMatcher.getMethodNames().contains(".*")) {
                    allInterceptorsQueue.addLast(matchingInterceptor);
                    continue;
                }
                allInterceptorsQueue.addFirst(matchingInterceptor);
            }
            ArrayList<InterceptorDefinition> finalInterceptors = new ArrayList<InterceptorDefinition>(allInterceptorsQueue);
            annotationMatchingInterceptors = null;
            boolean isUserClass = SmartPackageFilter.getInstance().isUserPackage(className);
            if (!isUserClass) {
                for (InterceptorDefinition interceptor : finalInterceptors) {
                    if (!(interceptor instanceof CustomInterceptorDefinition) && !interceptor.interceptorName.matches("com.manageengine.+(Servlet.+|ActionInterceptor.+|SpringController.+|Filter.+|api.Apm.+)")) continue;
                    isUserClass = true;
                    SmartPackageFilter.getInstance().addUserPackage(className);
                    break;
                }
            }
            ByteCodeWriter writer = new ByteCodeWriter(reader, loader);
            try {
                LoopReader loopReader = null;
                if (isUserClass) {
                    loopReader = new LoopReader(finalInterceptors);
                    reader.accept(loopReader, InstrumentationUtil.getClassReaderFlags());
                }
                BasicClassAdapter adapter = new BasicClassAdapter(writer, className, classBeingRedefined, finalInterceptors, null, loopReader);
                reader.accept(adapter, InstrumentationUtil.getClassReaderFlags());
                JavaAgent.logger.info((classBeingRedefined == null ? "clz instrumented: " : "clz re-transformed: ") + className + (isUserClass ? " - user class" : ""));
            }
            catch (Exception ex) {
                if (isUserClass) {
                    JavaAgent.logger.log(Level.WARN, "Exception while creating BasicClassAdapter for userclass " + className, ex);
                } else {
                    JavaAgent.logger.log(Level.WARN, "Exception while creating BasicClassAdapter for class " + className, ex);
                }
                return null;
            }
            return writer.toByteArray();
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.FATAL, "Exception occurred while transforming", th);
            JavaAgent.logger.warn("Arguments: ClassLoader: " + loader + " className: " + className);
            return null;
        }
    }

    private void retransformMSSqlStatementClassesIfNotTransformed() {
        if (!this.isMssqlDriverStatementClassTransformed) {
            JavaAgent.getInstance().getClassRetransformEngine().retransformIfEscapedFromInstrumentation("com/microsoft/sqlserver/jdbc/SQLServerStatement", "com/microsoft/sqlserver/jdbc/SQLServerPreparedStatement");
            this.isMssqlDriverStatementClassTransformed = true;
        }
    }
}

