/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.instrumentation.interceptor.CollectionMapInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinitionIndex;
import com.manageengine.apminsight.agent.instrumentation.interceptor.MethodInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.api.ApmRootTrackerInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.api.ApmTrackerInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.appservers.WebSeqResponseCodeInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.async.CompletableFutureInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.async.JavaAsyncSupplyRunInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.cache.MemcachedInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.cache.RedisInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.cassandra.CassandraInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.custom.CustomInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.ClosePreparedStatementInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.CloseStatementInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.ConnectionInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.PostgresInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.PreparedStatementInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.StatementInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.r2dbc.R2DBCH2InterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.r2dbc.R2DBCMsSqlInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.r2dbc.R2DBCMySqlInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.r2dbc.R2DBCPostgresInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.ejb.EjbInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.ejb3.Ejb3AnnotationInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.elasticsearch.ElasticSearchRestClientInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.elasticsearch.ElasticSearchRestHighLevelClientInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.elasticsearch.ElasticSearchTransportClientInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.grpc.GrpcChannelInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.grpc.GrpcClientCallInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.grpc.GrpcServerCallInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.grpc.GrpcServerCallListenerInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.grpc.GrpcServerListenerInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.hibernate.HibernateSessionImplInterceptor;
import com.manageengine.apminsight.agent.instrumentation.interceptor.httpclient.ApacheHttpClientInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.httpclient.InternalSunHttpClientInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.httpclient.JavaHttpURLConnectionInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.httpclient.JettyHttpClientInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.httpclient.OkHttpClientInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.httpclient.async.ApacheHttpClientAsyncInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.httpclient.async.AsyncHttpClientInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.httpclient.async.SpringReactiveExchangeFunctionInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.httpclient.async.SpringReactiveWebClientInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.internal.ZohoRunnableJobInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.jasper.JasperInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.jaxrs.JaxRSInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.jaxws.JaxWSInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.jersey.Jersey2InterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.loggingframeworks.JavaUtilLoggingInterceptorDefiniton;
import com.manageengine.apminsight.agent.instrumentation.interceptor.loggingframeworks.Log4J2InterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.loggingframeworks.Log4jInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.messaging.ActiveMQInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.messaging.KafkaInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.messaging.RabbitMQInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.micronaut.MicronautControllerInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.micronaut.MicronautNettyInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.mongo.MongoDB4xInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.mongo.MongoDBInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.play2.BaseScalaTemplateInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.play2.ControllerInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.play2.ResultsInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.quarkus.QuarkusVertxInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.reactor.BlockingReactorPublisherInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.reactor.netty.NettyServerInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.restlet.RestletResourceInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.servlets.FilterInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.servlets.JSPInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.servlets.ServletInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.spring.SpringAsyncInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.spring.SpringBatchInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.spring.SpringControllerInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.spring.SpringKafkaInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.spring.SpringServerHttpAdapterInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.spring.SpringServletInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.spring.gateway.ReactorHttpClientInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.spring.gateway.SpringGatewayInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.struts.ActionInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.struts.ActionServletInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.synapse.SynapseMediatorInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.synapse.SynapsePassThruRequestInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.webmethods.WebMethodsInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.apminsight.agent.util.Utils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class InterceptorDefinitionFactory {
    private static InterceptorDefinitionFactory intercepDefFactory = null;
    private static final Class<?>[] INTERCEPTOR_DEFINITIONS = new Class[]{ServletInterceptorDefinition.class, JSPInterceptorDefinition.class, FilterInterceptorDefinition.class, ActionServletInterceptorDefinition.class, ActionInterceptorDefinition.class, StatementInterceptorDefinition.class, ConnectionInterceptorDefinition.class, PreparedStatementInterceptorDefinition.class, CloseStatementInterceptorDefinition.class, ClosePreparedStatementInterceptorDefinition.class, PostgresInterceptorDefinition.class, EjbInterceptorDefinition.class, HibernateSessionImplInterceptor.class, SpringServletInterceptorDefinition.class, Jersey2InterceptorDefinition.class, ControllerInterceptorDefinition.class, BaseScalaTemplateInterceptorDefinition.class, ResultsInterceptorDefinition.class, MemcachedInterceptorDefinition.class, RedisInterceptorDefinition.class, ApacheHttpClientInterceptorDefinition.class, JavaHttpURLConnectionInterceptorDefinition.class, InternalSunHttpClientInterceptorDefinition.class, JettyHttpClientInterceptorDefinition.class, OkHttpClientInterceptorDefinition.class, Log4jInterceptorDefinition.class, Log4J2InterceptorDefinition.class, JavaUtilLoggingInterceptorDefiniton.class, CassandraInterceptorDefinition.class, MongoDBInterceptorDefinition.class, MongoDB4xInterceptorDefinition.class, ElasticSearchTransportClientInterceptorDefinition.class, ElasticSearchRestHighLevelClientInterceptorDefinition.class, ElasticSearchRestClientInterceptorDefinition.class, WebSeqResponseCodeInterceptorDefinition.class, JasperInterceptorDefinition.class, KafkaInterceptorDefinition.class, ActiveMQInterceptorDefinition.class, RabbitMQInterceptorDefinition.class, BlockingReactorPublisherInterceptorDefinition.class, ZohoRunnableJobInterceptorDefinition.class, MicronautNettyInterceptorDefinition.class, ApacheHttpClientAsyncInterceptorDefinition.class, AsyncHttpClientInterceptorDefinition.class, CompletableFutureInterceptorDefinition.class, JavaAsyncSupplyRunInterceptorDefinition.class, GrpcChannelInterceptorDefinition.class, GrpcClientCallInterceptorDefinition.class, GrpcServerCallInterceptorDefinition.class, GrpcServerCallListenerInterceptorDefinition.class, GrpcServerListenerInterceptorDefinition.class, SynapsePassThruRequestInterceptorDefinition.class, SynapseMediatorInterceptorDefinition.class, SpringGatewayInterceptorDefinition.class, ReactorHttpClientInterceptorDefinition.class, WebMethodsInterceptorDefinition.class, QuarkusVertxInterceptorDefinition.class, SpringBatchInterceptorDefinition.class, SpringReactiveExchangeFunctionInterceptorDefinition.class, SpringReactiveWebClientInterceptorDefinition.class, R2DBCH2InterceptorDefinition.class, R2DBCMySqlInterceptorDefinition.class, R2DBCPostgresInterceptorDefinition.class, R2DBCMsSqlInterceptorDefinition.class, NettyServerInterceptorDefinition.class, SpringServerHttpAdapterInterceptorDefinition.class};
    private static final Class<?>[] ANNOTATION_INTERCEPTOR_DEFINITIONS = new Class[]{ApmTrackerInterceptorDefinition.class, ApmRootTrackerInterceptorDefinition.class, Ejb3AnnotationInterceptorDefinition.class, RestletResourceInterceptorDefinition.class, JaxRSInterceptorDefinition.class, JaxWSInterceptorDefinition.class, SpringControllerInterceptorDefinition.class, SpringAsyncInterceptorDefinition.class, SpringKafkaInterceptorDefinition.class, MicronautControllerInterceptorDefinition.class};
    private Map<String, InterceptorDefinition> interceptorDefMap = new HashMap<String, InterceptorDefinition>(INTERCEPTOR_DEFINITIONS.length);
    private Map<String, InterceptorDefinition> annotationInterceptorDefMap = new HashMap<String, InterceptorDefinition>(ANNOTATION_INTERCEPTOR_DEFINITIONS.length);
    private static final Pattern CUSTOM_COMPONENT_PATTERN = Pattern.compile("\\w+");

    private InterceptorDefinitionFactory() {
        this.loadStaticInterceptorDefinitions(INTERCEPTOR_DEFINITIONS, this.interceptorDefMap);
        this.loadStaticInterceptorDefinitions(ANNOTATION_INTERCEPTOR_DEFINITIONS, this.annotationInterceptorDefMap);
        JavaAgent.logger.info("All static interceptors loaded successfully.");
        try {
            Properties customInterceptorProps = Utils.getContentAsProps(new File(JavaAgent.getInstance().getAgentConfig().getInstanceDir(), "instrumentation.conf"));
            this.loadCustomInterceptorDefinitions(customInterceptorProps);
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Error occurred while loading custom interceptors. Exception: " + th.getMessage());
        }
    }

    public static InterceptorDefinitionFactory getInstance() {
        if (intercepDefFactory == null) {
            intercepDefFactory = new InterceptorDefinitionFactory();
        }
        return intercepDefFactory;
    }

    private void loadStaticInterceptorDefinitions(Class<?>[] interceptorDefinitions, Map<String, InterceptorDefinition> interceptorMap) {
        for (Class<?> intercepDefnClz : interceptorDefinitions) {
            String intercepDefClzName = intercepDefnClz.getName();
            if (intercepDefnClz == JavaHttpURLConnectionInterceptorDefinition.class && JavaAgentUtil.isIBMJava()) continue;
            try {
                if (!InterceptorDefinition.class.isAssignableFrom(intercepDefnClz)) {
                    JavaAgent.logger.log(Level.INFO, "RND: {} interceptor is notAssignableForm of InterceptorDefiniton", (Object)intercepDefnClz);
                    continue;
                }
                InterceptorDefinition intercepDef = (InterceptorDefinition)intercepDefnClz.newInstance();
                if (intercepDef != null) {
                    interceptorMap.put(intercepDefClzName, intercepDef);
                }
                JavaAgent.logger.log(Level.TRACE, "interceptor {} successfully loaded", (Object)intercepDefClzName);
            }
            catch (Exception e) {
                JavaAgent.logger.log(Level.WARN, "exception while loading/initializing interceptor: " + intercepDefClzName, e);
            }
        }
    }

    private void loadCustomInterceptorDefinitions(Map<String, String> customIntercepProps) {
        for (Map.Entry<String, String> entry : customIntercepProps.entrySet()) {
            String className = entry.getKey();
            ClassMatcher classMatcher = null;
            try {
                Pattern.compile(className);
                classMatcher = new ClassMatcher(className);
            }
            catch (PatternSyntaxException e) {
                JavaAgent.logger.warn("Invalid class name: " + className + "specified in " + "instrumentation.conf");
                JavaAgent.logger.warn("Skipping the entry: " + entry);
                continue;
            }
            String[] values = entry.getValue().replaceAll("\\s+", "").split(":");
            String methods = values.length > 0 ? values[0] : "";
            MethodMatcher methodMatcher = null;
            if ("".equals(methods)) {
                methodMatcher = MethodInterceptorDefinition.ALL_METHOD_MATCHER;
            } else {
                String[] methodz = methods.split(",");
                MethodMatcher[] methodMatcherz = new MethodMatcher[methodz.length];
                for (int i = 0; i < methodz.length; ++i) {
                    String methName = methodz[i];
                    try {
                        Pattern.compile(methName);
                        methodMatcherz[i] = new MethodMatcher(methodz[i], "/.*/");
                        continue;
                    }
                    catch (PatternSyntaxException e) {
                        JavaAgent.logger.warn("Invalid method name: " + methName + "specified in " + "instrumentation.conf");
                        JavaAgent.logger.warn("Skipping the entry: " + entry);
                        methodMatcherz = null;
                        break;
                    }
                }
                methodMatcher = methodMatcherz != null ? new ManyMethodMatcher(methodMatcherz) : null;
            }
            Component component = Component.APP_CODE;
            if (values.length > 1 && CUSTOM_COMPONENT_PATTERN.matcher(values[1]).matches()) {
                component = Component.get(values[1]);
            }
            if (classMatcher == null || methodMatcher == null) continue;
            String pointCutName = className + component.toString();
            CustomInterceptorDefinition customIntercepDef = new CustomInterceptorDefinition(pointCutName, classMatcher, null, methodMatcher, component);
            JavaAgent.logger.info("Adding custom interceptor: " + customIntercepDef + "to interceptor factory.");
            this.interceptorDefMap.put(pointCutName, customIntercepDef);
        }
        JavaAgent.logger.info("All custom interceptors loaded successfully");
    }

    public void sanitizeInterceptorDefinitions(Map<String, String> customInterceptors, boolean isRootTrackerDefinition) {
        InterceptorDefinitionIndex interceptorDefIndex = InterceptorDefinitionIndex.getInstance();
        for (Map.Entry<String, String> entry : customInterceptors.entrySet()) {
            String className = entry.getKey();
            try {
                Pattern.compile(className);
            }
            catch (Throwable th) {
                JavaAgent.logger.warn("Invalid class name skipping entry: " + className);
                continue;
            }
            try {
                String[] stringArray;
                String[] values = entry.getValue().replaceAll("\\s+", "").split(":");
                if (values.length > 0) {
                    stringArray = values[0].split(",");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                }
                String[] methods = stringArray;
                Component component = values.length > 1 && CUSTOM_COMPONENT_PATTERN.matcher(values[1]).matches() ? Component.get(values[1]) : Component.APP_CODE;
                MethodMatcher[] methodMatcher = null;
                List<InterceptorDefinition> matchingList = interceptorDefIndex.lookup(className, null, null);
                if (matchingList.isEmpty()) {
                    methodMatcher = new MethodMatcher[methods.length];
                    for (int i = 0; i < methods.length; ++i) {
                        methodMatcher[i] = new MethodMatcher(methods[i].equals("") ? "/.*/" : methods[i], "/.*/");
                    }
                } else {
                    ArrayList<MethodMatcher> newMethods = new ArrayList<MethodMatcher>();
                    for (String method : methods) {
                        method = method.equals("") ? "/.*/" : method;
                        boolean matches = false;
                        for (InterceptorDefinition interceptor : matchingList) {
                            matches = interceptor.includeMethodMatcher.matches(method, "/.*/");
                            if (!matches) continue;
                            break;
                        }
                        if (matches) continue;
                        newMethods.add(new MethodMatcher(method, "/.*/"));
                    }
                    if (!newMethods.isEmpty()) {
                        methodMatcher = newMethods.toArray(new MethodMatcher[newMethods.size()]);
                    }
                    newMethods.clear();
                    newMethods = null;
                }
                if (methodMatcher == null) continue;
                String pointcutName = className + System.currentTimeMillis();
                TracingInterceptorDefinition interceptorDef = isRootTrackerDefinition ? new CustomInterceptorDefinition(pointcutName, new ClassMatcher(className), null, new ManyMethodMatcher(methodMatcher), component) : new TracingInterceptorDefinition(pointcutName, new ClassMatcher(className), null, new ManyMethodMatcher(methodMatcher));
                this.interceptorDefMap.put(pointcutName, interceptorDef);
                JavaAgent.getInstance().getClassRetransformEngine().retransformIfEscapedFromInstrumentation(className);
                JavaAgent.logger.log(Level.INFO, "Custom interceptor " + interceptorDef + " added to interceptor factory");
            }
            catch (Throwable th) {
                JavaAgent.logger.log(Level.WARN, "Error occurred while creating interceptor for clz: " + className + " Exception: " + th.getMessage());
            }
        }
        JavaAgent.getInstance().getClassRetransformEngine().retransformEscaped();
    }

    public void loadInterceptorsFromServer(Map<String, Map> customInterceptors) {
        JavaAgent.logger.info("Processing custom instrumentation configuration received from server. " + customInterceptors);
        InterceptorDefinitionIndex interceptorDefIndex = InterceptorDefinitionIndex.getInstance();
        for (Map.Entry<String, Map> entry : customInterceptors.entrySet()) {
            String className = StringUtils.removeAllWhiteSpaces(entry.getKey());
            try {
                Pattern.compile(className);
            }
            catch (Throwable th) {
                JavaAgent.logger.warn("Invalid class name skipping entry: " + className);
                continue;
            }
            try {
                Map methodsComponent = entry.getValue();
                for (Map.Entry methodsEntry : methodsComponent.entrySet()) {
                    String method = StringUtils.removeAllWhiteSpaces((String)methodsEntry.getKey());
                    String componentName = StringUtils.removeAllWhiteSpaces((String)methodsEntry.getValue());
                    method = method.equals("*") ? "/.*/" : method;
                    Component component = CUSTOM_COMPONENT_PATTERN.matcher(componentName).matches() ? Component.get(componentName) : Component.APP_CODE;
                    MethodMatcher methodMatcher = null;
                    List<InterceptorDefinition> matchingList = interceptorDefIndex.lookup(className, null, null);
                    if (matchingList.isEmpty()) {
                        methodMatcher = new MethodMatcher(method, "/.*/");
                    } else {
                        boolean isMethodFound = false;
                        for (InterceptorDefinition interceptor : matchingList) {
                            isMethodFound = interceptor.includeMethodMatcher.matches(method, "/.*/");
                            if (!isMethodFound) continue;
                            JavaAgent.logger.info("No new methods, already instrumented. " + interceptor);
                            break;
                        }
                        if (!isMethodFound) {
                            methodMatcher = new MethodMatcher(method, "/.*/");
                        }
                    }
                    if (methodMatcher == null) continue;
                    String pointcutName = className + System.currentTimeMillis();
                    CustomInterceptorDefinition interceptorDef = new CustomInterceptorDefinition(pointcutName, new ClassMatcher(className), null, methodMatcher, component);
                    this.interceptorDefMap.put(pointcutName, interceptorDef);
                    JavaAgent.getInstance().getClassRetransformEngine().retransformIfEscapedFromInstrumentation(className);
                    JavaAgent.logger.log(Level.INFO, "Custom interceptor " + interceptorDef + " added to interceptor factory");
                }
            }
            catch (Throwable th) {
                JavaAgent.logger.log(Level.WARN, "Error occurred while creating interceptor for clz: " + className + " Exception: " + th.getMessage());
            }
        }
        JavaAgent.getInstance().getClassRetransformEngine().retransformEscaped();
    }

    public List<InterceptorDefinition> getAnnotationInterceptors() {
        return new ArrayList<InterceptorDefinition>(this.annotationInterceptorDefMap.values());
    }

    public void addClassesToInterceptorDefMap() {
        this.interceptorDefMap.put(CollectionMapInterceptorDefinition.name, new CollectionMapInterceptorDefinition());
    }

    public void removeClassesFromInterceptorDefMap() {
        this.interceptorDefMap.remove(CollectionMapInterceptorDefinition.name);
    }

    public InterceptorDefinition getInterceptorDefinition(String pcName) {
        InterceptorDefinition interceptor = this.interceptorDefMap.get(pcName);
        return interceptor != null ? interceptor : this.annotationInterceptorDefMap.get(pcName);
    }
}

