/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.BasicMethodAdapter;
import com.manageengine.apminsight.agent.instrumentation.CustomLabel;
import com.manageengine.apminsight.agent.instrumentation.LoopReader;
import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinition;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.objectweb.asm.ClassVisitor;
import com.manageengine.org.objectweb.asm.Label;
import com.manageengine.org.objectweb.asm.MethodVisitor;
import com.manageengine.org.objectweb.asm.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoopAdviceAdapter
extends BasicMethodAdapter {
    private final List<Integer> loopEntryLabels;
    private final Map<Integer, Integer> entryExitMapper;
    private int labelCount = -1;
    private int loopEntryLabelIndex = -1;
    private int loopExitLabelIdx = -1;
    List<Label> loopEntries = new ArrayList<Label>();
    Map<Label, CustomLabel> customLabelMap = new HashMap<Label, CustomLabel>();
    private boolean loopOpen = false;
    private int loopTrackersVarIndex = -1;

    protected LoopAdviceAdapter(ClassVisitor adapter, String className, MethodVisitor mv, int access, String methodName, String description, InterceptorDefinition matchedInterceptor, LoopReader reader) {
        super(adapter, className, mv, access, methodName, description, matchedInterceptor);
        String nameWithDesc = methodName + description;
        this.loopEntryLabels = reader.getLabelIndexMap().get(nameWithDesc);
        this.entryExitMapper = reader.getExitCountMap().get(nameWithDesc);
    }

    @Override
    protected void onMethodEnter() {
        super.onMethodEnter();
        this.initLoopTrackersArr();
    }

    protected void initLoopTrackersArr() {
        this.loopTrackersVarIndex = this.newLocal(Type.getType("[Lcom/manageengine/apminsight/agent/trackers/LoopTracker;"));
        this.push(this.loopEntryLabels.size());
        this.newArray(Type.getType("Lcom/manageengine/apminsight/agent/trackers/LoopTracker;"));
        this.storeLocal(this.loopTrackersVarIndex);
    }

    @Override
    public void visitLabel(Label label) {
        ++this.labelCount;
        super.visitLabel(label);
        if (this.loopEntryLabels.contains(this.labelCount)) {
            if (!this.loopOpen) {
                CustomLabel label1 = this.customLabelMap.get(label);
                if (label1 == null) {
                    label1 = new CustomLabel(label, this.labelCount, this.entryExitMapper.get(this.labelCount));
                    this.customLabelMap.put(label, label1);
                } else {
                    label1.setIndex(this.labelCount);
                }
                ++this.loopEntryLabelIndex;
                label1.setLoopEntryIndex(this.loopEntryLabelIndex);
                this.instrumentLoopEntry(label1);
                this.loopOpen = true;
            }
            this.loopEntries.add(label);
        }
        if (this.loopExitLabelIdx != -1) {
            this.instrumentLoopExit();
            this.loopExitLabelIdx = -1;
            this.loopOpen = false;
        }
    }

    private void instrumentLoopEntry(CustomLabel entryLabel) {
        super.visitMethodInsn(184, AGENT_INTERNAL_NAME, "getHandler", HANDLE_METHOD_DESC, false);
        this.loadLocal(this.loopTrackersVarIndex);
        super.visitLdcInsn(this.className);
        super.visitLdcInsn(this.methodName);
        super.visitLdcInsn(this.methodDesc);
        super.visitLdcInsn(this.loopEntryLabelIndex);
        this.loadLocal(this.tracerVarId);
        super.visitMethodInsn(182, HANDLER_INTERNAL_NAME, "initAndTrackLoop", "([Lcom/manageengine/apminsight/agent/trackers/LoopTracker;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILcom/manageengine/apminsight/agent/trackers/Tracker;)V", false);
        JavaAgent.logger.log(Level.DEBUG, "Successfully instrumented loop entry for {}.{}.{}", this.className, this.methodName, this.labelCount);
    }

    private void instrumentLoopExit() {
        super.visitMethodInsn(184, AGENT_INTERNAL_NAME, "getHandler", HANDLE_METHOD_DESC, false);
        this.loadLocal(this.loopTrackersVarIndex);
        super.visitLdcInsn(this.loopExitLabelIdx);
        this.loadLocal(this.tracerVarId);
        super.visitMethodInsn(182, HANDLER_INTERNAL_NAME, "endLoop", "([Lcom/manageengine/apminsight/agent/trackers/LoopTracker;ILcom/manageengine/apminsight/agent/trackers/Tracker;)V", false);
        JavaAgent.logger.log(Level.DEBUG, "Successfully instrumented loop exit for {}.{}.{}", this.className, this.methodName, this.loopExitLabelIdx);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        if (this.loopEntries.contains(label) && this.customLabelMap.containsKey(label)) {
            CustomLabel label1 = this.customLabelMap.get(label);
            label1.incrGotoExitCountTracker();
            if (label1.getGotoExitCount() == label1.getGotoExitCountTracker()) {
                this.loopExitLabelIdx = label1.getLoopEntryIndex();
            }
        }
        super.visitJumpInsn(opcode, label);
    }
}

