/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation;

import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinition;
import com.manageengine.org.objectweb.asm.ClassVisitor;
import com.manageengine.org.objectweb.asm.Label;
import com.manageengine.org.objectweb.asm.MethodVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LoopReader
extends ClassVisitor {
    private final List<InterceptorDefinition> interceptors;
    private final Map<String, List<Integer>> labelIndexList = new HashMap<String, List<Integer>>();
    private final Map<String, Map<Integer, Integer>> exitCountMap = new HashMap<String, Map<Integer, Integer>>();

    public LoopReader(List<InterceptorDefinition> customInterceptors) {
        super(589824);
        this.interceptors = customInterceptors;
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, final String description, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, description, signature, exceptions);
        if (name.matches("<(cl)?init>") || (access & 0x400) != 0) {
            return mv;
        }
        for (InterceptorDefinition interceptor : this.interceptors) {
            if (interceptor.excludeMethodMatcher != null && interceptor.excludeMethodMatcher.matches(name, description)) {
                return mv;
            }
            if (!interceptor.includeMethodMatcher.matches(name, description)) continue;
            return new MethodVisitor(589824, mv){
                final Set<Integer> indexList;
                private final List<Label> visitedLabels;
                private final Map<Integer, Integer> entryExitMapper;
                {
                    super(x0, x1);
                    this.indexList = new HashSet<Integer>();
                    this.visitedLabels = new ArrayList<Label>();
                    this.entryExitMapper = new HashMap<Integer, Integer>();
                }

                @Override
                public void visitLabel(Label label) {
                    this.visitedLabels.add(label);
                    super.visitLabel(label);
                }

                @Override
                public void visitJumpInsn(int opcode, Label label) {
                    if (this.visitedLabels.contains(label)) {
                        int idx = this.visitedLabels.indexOf(label);
                        this.indexList.add(idx);
                        int count = this.entryExitMapper.get(idx) == null ? 1 : this.entryExitMapper.get(idx) + 1;
                        this.entryExitMapper.put(idx, count);
                    }
                    super.visitJumpInsn(opcode, label);
                }

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    if (!this.indexList.isEmpty()) {
                        LoopReader.this.labelIndexList.put(name + description, new ArrayList<Integer>(this.indexList));
                        LoopReader.this.exitCountMap.put(name + description, this.entryExitMapper);
                    }
                }
            };
        }
        return mv;
    }

    public Map<String, List<Integer>> getLabelIndexMap() {
        return this.labelIndexList;
    }

    public Map<String, Map<Integer, Integer>> getExitCountMap() {
        return this.exitCountMap;
    }

    public boolean isLoopDetected(String name, String description) {
        if (!this.labelIndexList.isEmpty()) {
            return this.labelIndexList.get(name + description) != null;
        }
        return false;
    }
}

