/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor;

import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.objectweb.asm.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BasicPointcutProperties
implements PointcutProperties {
    protected String interceptedClassName;
    protected String interceptedMethodName;
    protected String interceptedMethodDesc;
    protected String constructed_signature;

    public BasicPointcutProperties(String interceptedClassName, String interceptedMethodName) {
        this.interceptedClassName = interceptedClassName;
        this.interceptedMethodName = interceptedMethodName;
        this.interceptedMethodDesc = "";
        this.constructed_signature = "";
    }

    @Override
    public Component getComponent() {
        return Component.APP_CODE;
    }

    @Override
    public String getInterceptedClassName() {
        return this.interceptedClassName;
    }

    @Override
    public String getInterceptedMethodName() {
        return this.interceptedMethodName;
    }

    @Override
    public String getSignature() {
        if (StringUtils.isEmptyString(this.constructed_signature)) {
            String display_methodArgs = "";
            String display_methodReturnType = "";
            if (!StringUtils.isEmptyString(this.interceptedMethodDesc)) {
                List<Type> arg_types = Arrays.asList(Type.getArgumentTypes(this.interceptedMethodDesc));
                display_methodArgs = arg_types.stream().map(at -> at.getClassName()).collect(Collectors.joining(","));
                display_methodReturnType = Type.getReturnType(this.interceptedMethodDesc).getClassName();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.interceptedClassName).append('.');
            sb.append(this.interceptedMethodName).append("(");
            sb.append(display_methodArgs).append(")").append(display_methodReturnType);
            this.constructed_signature = sb.toString();
        }
        return this.constructed_signature;
    }

    public int hashCode() {
        return Objects.hash(this.interceptedClassName, this.interceptedMethodName);
    }

    public boolean equals(Object o) {
        return this.hashCode() == o.hashCode();
    }

    public String toString() {
        return this.getSignature();
    }

    @Override
    public void setInterceptedMethodDesc(String interceptedMethodDesc) {
        this.interceptedMethodDesc = interceptedMethodDesc;
    }
}

