/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor;

import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.memoryleaks.config.AutomaticLeakDetection;
import com.manageengine.apminsight.agent.trackers.Tracker;

public class CollectionMapInterceptorDefinition
extends TracingInterceptorDefinition {
    private static Long timer = System.currentTimeMillis();
    public static String name = "java/util";

    public CollectionMapInterceptorDefinition() {
        super(name, new AnyClassTypeMatcher(CollectionMapInterceptorDefinition.getClassMatcher()), null, new ManyMethodMatcher(CollectionMapInterceptorDefinition.getMethodTypeMatcher()));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thizObj, Object[] args) {
        AutomaticLeakDetection.OnDemandCollectionRecorder.getInstance().addToRouter(thizObj);
        AutomaticLeakDetection.getInstance().addToTracer(thizObj);
        return null;
    }

    private static ClassMatcher[] getClassMatcher() {
        return new ClassMatcher[]{new ClassMatcher("java/util/WeakHashMap$KeySet"), new ClassMatcher("java/util/Collections$EmptyList"), new ClassMatcher("java/util/AbstractSet"), new ClassMatcher("java/util/Vector"), new ClassMatcher("java/util/HashMap"), new ClassMatcher("java/util/concurrent/CopyOnWriteArrayList"), new ClassMatcher("java/util/AbstractSequentialList"), new ClassMatcher("java/util/ArrayList"), new ClassMatcher("java/util/concurrent/ConcurrentHashMap$EntrySetView"), new ClassMatcher("java/util/Arrays$ArrayList"), new ClassMatcher("java/util/Collections$EmptySet"), new ClassMatcher("java/util/Properties"), new ClassMatcher("java/util/ArrayList$SubList"), new ClassMatcher("java/util/WeakHashMap"), new ClassMatcher("java/util/ArrayDeque"), new ClassMatcher("java/util/concurrent/ConcurrentHashMap$CollectionView"), new ClassMatcher("java/util/concurrent/ConcurrentHashMap"), new ClassMatcher("java/util/LinkedHashMap$LinkedEntrySet"), new ClassMatcher("java/util/Collections$SetFromMap"), new ClassMatcher("java/util/Hashtable$EntrySet"), new ClassMatcher("java/util/HashSet"), new ClassMatcher("java/util/Collections$UnmodifiableCollection"), new ClassMatcher("java/util/AbstractCollection"), new ClassMatcher("java/util/jar/Attributes"), new ClassMatcher("java/util/Collections$SynchronizedCollection"), new ClassMatcher("java/util/Hashtable"), new ClassMatcher("java/util/concurrent/ConcurrentHashMap$KeySetView"), new ClassMatcher("java/util/HashMap$KeySet"), new ClassMatcher("java/util/HashMap$EntrySet"), new ClassMatcher("java/util/Collections$UnmodifiableList"), new ClassMatcher("java/util/IdentityHashMap"), new ClassMatcher("java/util/Collections$UnmodifiableRandomAccessList"), new ClassMatcher("java/util/TreeMap"), new ClassMatcher("java/util/TreeMap$Values"), new ClassMatcher("java/util/Collections$EmptyMap"), new ClassMatcher("java/util/LinkedList"), new ClassMatcher("java/util/LinkedHashSet"), new ClassMatcher("java/util/Stack"), new ClassMatcher("java/util/Collections$SynchronizedMap"), new ClassMatcher("java/util/concurrent/ConcurrentHashMap$ValuesView"), new ClassMatcher("java/util/LinkedHashMap"), new ClassMatcher("java/util/HashMap$Values"), new ClassMatcher("java/util/Collections$SynchronizedSet"), new ClassMatcher("java/util/AbstractMap"), new ClassMatcher("java/util/AbstractList")};
    }

    private static MethodMatcher[] getMethodTypeMatcher() {
        return new MethodMatcher[]{new MethodMatcher("put", "/.*/"), new MethodMatcher("get", "/.*/"), new MethodMatcher("remove", "/.*/"), new MethodMatcher("get", "/.*/"), new MethodMatcher("getValue", "/.*/"), new MethodMatcher("get", "/.*/"), new MethodMatcher("firstKey", "/.*/"), new MethodMatcher("lastKey", "/.*/"), new MethodMatcher("nextKey", "/.*/"), new MethodMatcher("previousKey", "/.*/"), new MethodMatcher("elementAt", "/.*/"), new MethodMatcher("poll", "/.*/"), new MethodMatcher("pollFirst", "/.*/"), new MethodMatcher("pollLast", "/.*/"), new MethodMatcher("contains", "/.*/"), new MethodMatcher("containsKey", "/.*/"), new MethodMatcher("containsValue", "/.*/"), new MethodMatcher("lowerEntry", "/.*/"), new MethodMatcher("lowerKey", "/.*/"), new MethodMatcher("floorEntry", "/.*/"), new MethodMatcher("floorKey", "/.*/"), new MethodMatcher("ceilingEntry", "/.*/"), new MethodMatcher("ceilingKey", "/.*/"), new MethodMatcher("higherEntry", "/.*/"), new MethodMatcher("higherKey", "/.*/"), new MethodMatcher("pollFirstEntry", "/.*/"), new MethodMatcher("pollLastEntry", "/.*/"), new MethodMatcher("put", "/.*/"), new MethodMatcher("putIfAbsent", "/.*/"), new MethodMatcher("add", "/.*/"), new MethodMatcher("offer", "/.*/"), new MethodMatcher("take", "/.*/"), new MethodMatcher("addElement", "/.*/"), new MethodMatcher("addFirst", "/.*/"), new MethodMatcher("addLast", "/.*/"), new MethodMatcher("offerFirst", "/.*/"), new MethodMatcher("offerLast", "/.*/")};
    }
}

