/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor;

import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.InterfaceTypeMatcher;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class InterceptorDefinitionIndex {
    private InterceptorIndexSpace exactClassLookup = new InterceptorIndexSpace();
    private InterceptorIndexSpace interfaceTypeLookup = new InterceptorIndexSpace();
    private InterceptorIndexSpace classTypeLookup = new InterceptorIndexSpace();
    private static InterceptorDefinitionIndex thiz = new InterceptorDefinitionIndex();
    private static final String JAVA_LANG_OBJ = "java/lang/Object";
    private static final String REGEX_ALL = "/.*";

    private InterceptorDefinitionIndex() {
    }

    public static InterceptorDefinitionIndex getInstance() {
        return thiz;
    }

    public void add(ClassTypeMatcher classTypeMatcher, InterceptorDefinition interceptorDef) {
        if (classTypeMatcher != null) {
            if (classTypeMatcher instanceof AnyClassTypeMatcher) {
                for (ClassTypeMatcher ctm : ((AnyClassTypeMatcher)classTypeMatcher).listMatchers()) {
                    this.add(ctm, interceptorDef);
                }
            } else if (classTypeMatcher instanceof ClassMatcher) {
                this.exactClassLookup.put(classTypeMatcher.getClassName(), interceptorDef);
            } else if (classTypeMatcher instanceof InterfaceTypeMatcher) {
                this.interfaceTypeLookup.put(classTypeMatcher.getClassName(), interceptorDef);
            } else {
                this.classTypeLookup.put(classTypeMatcher.getClassName(), interceptorDef);
            }
        }
    }

    public List<InterceptorDefinition> lookup(String clzName, String superClzName, String[] interfacesNames) {
        LinkedList<InterceptorDefinition> matchingInterceptors = new LinkedList<InterceptorDefinition>();
        List<InterceptorDefinition> intercepDefList = this.lookup(clzName, this.exactClassLookup);
        if (intercepDefList != null) {
            matchingInterceptors.addAll(intercepDefList);
        }
        if (superClzName != null && !JAVA_LANG_OBJ.equals(superClzName) && (intercepDefList = this.lookup(superClzName, this.classTypeLookup)) != null) {
            matchingInterceptors.addAll(0, intercepDefList);
        }
        if (interfacesNames != null) {
            for (String interf : interfacesNames) {
                intercepDefList = this.lookup(interf, this.interfaceTypeLookup);
                if (intercepDefList == null) continue;
                matchingInterceptors.addAll(0, intercepDefList);
                break;
            }
        }
        return matchingInterceptors;
    }

    private List<InterceptorDefinition> lookup(String lookupKey, InterceptorIndexSpace lookupSource) {
        List intercepDefList = (List)lookupSource.get(lookupKey);
        if (intercepDefList == null) {
            String[] portions = lookupKey.split("/");
            int i = portions.length;
            int trimScale = portions[i - 1].length() + 1;
            int lookupKeyLength = lookupKey.length();
            while (i > lookupSource.minPortion && (intercepDefList = (List)lookupSource.get(lookupKey.substring(0, lookupKeyLength - trimScale) + REGEX_ALL)) == null) {
                trimScale += portions[--i - 1].length() + 1;
            }
        }
        return intercepDefList;
    }

    static class InterceptorIndexSpace
    extends HashMap<String, LinkedList<InterceptorDefinition>> {
        private static final long serialVersionUID = 9836483648343L;
        private int minPortion = Integer.MAX_VALUE;

        InterceptorIndexSpace() {
        }

        @Override
        public List<InterceptorDefinition> put(String key, InterceptorDefinition value) {
            LinkedList<InterceptorDefinition> list = (LinkedList<InterceptorDefinition>)this.get(key);
            if (list == null) {
                list = new LinkedList<InterceptorDefinition>();
                super.put(key, list);
            }
            list.addFirst(value);
            int keyPortion = key.split("/").length;
            if (key.endsWith(InterceptorDefinitionIndex.REGEX_ALL)) {
                --keyPortion;
            }
            this.minPortion = keyPortion < this.minPortion ? keyPortion : this.minPortion;
            return list;
        }
    }
}

