/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.async;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.tracing.AsyncTracerService;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractAsyncTracingInterceptorDefinition
extends TracingInterceptorDefinition {
    private static Map<AsyncOperations, List<String>> operations_MethodsMapping = new HashMap<AsyncOperations, List<String>>();

    public AbstractAsyncTracingInterceptorDefinition(String interceptorName, ClassTypeMatcher classTypeMatcher, MethodMatcher excludeMethodMatcher, MethodMatcher includeMethodMatcher, String[] executionMethods, String[] completeMethods, String[] failedMethods, String[] abortMethods) {
        super(interceptorName, classTypeMatcher, excludeMethodMatcher, includeMethodMatcher);
        if (executionMethods != null) {
            operations_MethodsMapping.get((Object)AsyncOperations.EXECUTION).addAll(Arrays.asList(executionMethods));
        }
        if (completeMethods != null) {
            operations_MethodsMapping.get((Object)AsyncOperations.COMPLETED).addAll(Arrays.asList(completeMethods));
        }
        if (failedMethods != null) {
            operations_MethodsMapping.get((Object)AsyncOperations.FAILED).addAll(Arrays.asList(failedMethods));
        }
        if (abortMethods != null) {
            operations_MethodsMapping.get((Object)AsyncOperations.ABORT).addAll(Arrays.asList(abortMethods));
        }
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args) {
        if (operations_MethodsMapping.get((Object)AsyncOperations.EXECUTION).contains(methodName)) {
            return this.handleExecution(thisObj, args);
        }
        this.handleExit(methodName, thisObj, args);
        return null;
    }

    private void handleExit(String methodName, Object thisObj, Object[] args) {
        try {
            CallerAsyncRootTracker tracker = AsyncTracerService.getInstance().evictTracker(thisObj.hashCode());
            if (tracker == null) {
                return;
            }
            if (operations_MethodsMapping.get((Object)AsyncOperations.COMPLETED).contains(methodName)) {
                this.handleCompletion(thisObj, args);
            } else if (operations_MethodsMapping.get((Object)AsyncOperations.FAILED).contains(methodName)) {
                this.handleFailure(thisObj, args);
            } else if (operations_MethodsMapping.get((Object)AsyncOperations.ABORT).contains(methodName)) {
                this.handleAbort(thisObj, args);
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[AbstractAsyncID] Exception while handling async exit.", th);
        }
    }

    protected abstract void handleAbort(Object var1, Object[] var2);

    protected abstract void handleFailure(Object var1, Object[] var2);

    protected abstract void handleCompletion(Object var1, Object[] var2);

    protected abstract Tracker handleExecution(Object var1, Object[] var2);

    static {
        operations_MethodsMapping.put(AsyncOperations.EXECUTION, new ArrayList());
        operations_MethodsMapping.put(AsyncOperations.COMPLETED, new ArrayList());
        operations_MethodsMapping.put(AsyncOperations.FAILED, new ArrayList());
        operations_MethodsMapping.put(AsyncOperations.ABORT, new ArrayList());
    }

    private static enum AsyncOperations {
        EXECUTION,
        COMPLETED,
        FAILED,
        ABORT;

    }
}

