/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.async;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.tracing.AsyncTracerService;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.PsuedoTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.async.CompletableFutureTracker;

public class CompletableFutureInterceptorDefinition
extends TracingInterceptorDefinition {
    private static final String SUPPLYASYNC = "supplyAsync";
    private static final String COMPLETEVALUE = "completeValue";
    private static final String COMPLETETHROWABLE = "completeThrowable";
    private static final String CANCEL = "cancel";
    private static final String JOIN = "join";

    public CompletableFutureInterceptorDefinition() {
        super(CompletableFutureInterceptorDefinition.class.getName(), new ClassMatcher("java/util/concurrent/CompletableFuture"), null, new ManyMethodMatcher(new MethodMatcher(SUPPLYASYNC, "(Ljava/util/function/Supplier;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"), new MethodMatcher(COMPLETEVALUE, "(Ljava/lang/Object;)Z"), new MethodMatcher(COMPLETETHROWABLE, "(Ljava/lang/Throwable;)Z"), new MethodMatcher(CANCEL, "(Z)Z"), new MethodMatcher(JOIN, "/.*/")));
        JavaAgent.getInstance().getClassRetransformEngine().retransformIfEscapedFromInstrumentation("java/util/concurrent/CompletableFuture");
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args) {
        if (methodName.equals(SUPPLYASYNC)) {
            if (args != null && args.length == 2) {
                try {
                    return new CompletableFutureTracker(new BasicPointcutProperties(className, methodName));
                }
                catch (Throwable th) {
                    JavaAgent.logger.warn("Error occurred in initializing CFTracker.", th);
                }
            }
        } else {
            if (methodName.equals(JOIN)) {
                return new PsuedoTracker(System.currentTimeMillis(), 0, "Join() invoked, Waiting for async task(s) to complete");
            }
            CallerAsyncRootTracker tracker = AsyncTracerService.getInstance().evictTracker(thisObj.hashCode());
            if (tracker != null) {
                switch (methodName) {
                    case "completeValue": {
                        tracker.markCompleted(args[0]);
                        break;
                    }
                    case "completeThrowable": {
                        Throwable th = args != null && args.length > 0 ? (Throwable)args[0] : null;
                        tracker.markFailed(th);
                        break;
                    }
                    case "cancel": {
                        tracker.markCancelled();
                    }
                }
            }
        }
        return null;
    }
}

