/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.async;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.tracing.AsyncTracerService;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.async.CompletableFutureTracker;
import com.manageengine.apminsight.agent.trackers.background.BackgroundSeqRootTracker;
import java.lang.reflect.Field;
import java.util.concurrent.CompletableFuture;

public class JavaAsyncSupplyRunInterceptorDefinition
extends TracingInterceptorDefinition {
    public JavaAsyncSupplyRunInterceptorDefinition() {
        super(JavaAsyncSupplyRunInterceptorDefinition.class.getName(), new ClassMatcher("java/util/concurrent/CompletableFuture$AsyncSupply"), null, new MethodMatcher("run", "()V"));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args) {
        BasicPointcutProperties pointcut = new BasicPointcutProperties(className, methodName);
        try {
            CompletableFutureTracker callerTracker = (CompletableFutureTracker)AsyncTracerService.getInstance().evictTracker(this.findCompletableFutureObjectID(thisObj));
            if (callerTracker != null) {
                return callerTracker.getAsyncRunTracker(pointcut);
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Error occurred while fetching caller tracker. {}", th.getMessage());
        }
        return new BackgroundSeqRootTracker(pointcut, thisObj, args);
    }

    private int findCompletableFutureObjectID(Object thiz) {
        try {
            Field[] fields;
            for (Field field : fields = thiz.getClass().getDeclaredFields()) {
                if (field.getType() != CompletableFuture.class) continue;
                field.setAccessible(true);
                Object obj = field.get(thiz);
                return obj.hashCode();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }
}

