/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.cache;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.InterfaceTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.cache.CachedFrameworkTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class RedisInterceptorDefinition
extends TracingInterceptorDefinition {
    public static final String[] SET_METHOD_DESC = new String[]{"(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;J)Ljava/lang/String;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)Ljava/lang/String;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "(Ljava/lang/String;[B)V", "(Ljava/lang/String;Ljava/lang/String;)Lredis/clients/jedis/Response;", "([B[B)Ljava/lang/String;", "([B[BLredis/clients/jedis/params/SetParams;)Ljava/lang/String;", "(Ljava/lang/String;Ljava/lang/String;Lredis/clients/jedis/params/SetParams;)Ljava/lang/String;"};
    public static final String[] GET_METHOD_DESC = new String[]{"(Ljava/lang/String;)[B", "(Ljava/lang/String;)Ljava/lang/String;", "(Ljava/lang/String;)Lredis/clients/jedis/Response;", "([B)[B"};
    public static final String[] DEL_METHOD_DESC = new String[]{"(Ljava/lang/String;)Z", "(Ljava/lang/String;)Ljava/lang/Long;", "([Ljava/lang/String;)Ljava/lang/Long;", "(Ljava/lang/String;)Lredis/clients/jedis/Response;", "([Ljava/lang/String;)Lredis/clients/jedis/Response;", "([B)Ljava/lang/Long;", "([[B)Ljava/lang/Long;", "(Ljava/lang/String;)J", "([Ljava/lang/String;)J", "([B)J", "([[B)J"};
    public static final String[] INCR_DECR_METHOD_DESC = new String[]{"(Ljava/lang/String;)Ljava/lang/Long;", "(Ljava/lang/String;)J", "(Ljava/lang/String;)Lredis/clients/jedis/Response;", "([B)Ljava/lang/Long;", "([B)J", "(Ljava/lang/String;)J"};
    public static final String JREDIS_BY_METHOD_DESC = "(Ljava/lang/String;I)J";
    public static final String[] JEDIS_BY_METHOD_DESC = new String[]{"(Ljava/lang/String;J)Ljava/lang/Long;", "(Ljava/lang/String;J)Lredis/clients/jedis/Response;", "([BJ)Ljava/lang/Long;", "(Ljava/lang/String;J)J", "([BJ)J"};

    public RedisInterceptorDefinition() {
        super(RedisInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new ClassMatcher("redis/clients/jedis/Jedis"), new ClassMatcher("redis/clients/jedis/Pipeline"), new ClassMatcher("redis/clients/jedis/Connection"), new ClassMatcher("redis/clients/jedis/Protocol"), new InterfaceTypeMatcher("org/jredis/JRedis"), new ClassMatcher("redis/clients/jedis/BinaryJedis"), new InterfaceTypeMatcher("org/jredis/connector/Connection")), null, new ManyMethodMatcher(new MethodMatcher("get", GET_METHOD_DESC), new MethodMatcher("set", SET_METHOD_DESC), new MethodMatcher("del", DEL_METHOD_DESC), new MethodMatcher("incr", INCR_DECR_METHOD_DESC), new MethodMatcher("decr", INCR_DECR_METHOD_DESC), new MethodMatcher("incrby", JREDIS_BY_METHOD_DESC), new MethodMatcher("decrby", JREDIS_BY_METHOD_DESC), new MethodMatcher("incrBy", JEDIS_BY_METHOD_DESC), new MethodMatcher("decrBy", JEDIS_BY_METHOD_DESC), new MethodMatcher("mget", new String[]{"([Ljava/lang/String;)Ljava/util/List;", "([Ljava/lang/String;)Lredis/clients/jedis/Response;", "([[B)Ljava/util/List;"}), new MethodMatcher("mset", new String[]{"([Ljava/lang/String;)Ljava/lang/String;", "([Ljava/lang/String;)Lredis/clients/jedis/Response;", "([[B)Ljava/lang/String;"}), new MethodMatcher("sync", "()V"), new MethodMatcher("syncAndReturnAll", "()Ljava/util/List;"), new MethodMatcher("hget", new String[]{"(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "(Ljava/lang/String;Ljava/lang/String;)Lredis/clients/jedis/Response;", "([B[B)[B"}), new MethodMatcher("hgetAll", new String[]{"(Ljava/lang/String;)Ljava/util/Map;", "(Ljava/lang/String;)Lredis/clients/jedis/Response;", "([B)Ljava/util/Map;"}), new MethodMatcher("hset", new String[]{"(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Long;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lredis/clients/jedis/Response;", "(Ljava/lang/String;Ljava/util/Map;)Lredis/clients/jedis/Response;", "([B[B[B)Ljava/lang/Long;", "([BLjava/util/Map;)Ljava/lang/Long;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)J", "(Ljava/lang/String;Ljava/util/Map;)J", "([B[B[B)J", "([BLjava/util/Map;)J"}), new MethodMatcher("hdel", new String[]{"(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/Long;", "(Ljava/lang/String;[Ljava/lang/String;)Lredis/clients/jedis/Response;", "([B[[B)Ljava/lang/Long;", "(Ljava/lang/String;[Ljava/lang/String;)J", "([B[[B)J"}), new MethodMatcher("hincrBy", new String[]{"(Ljava/lang/String;Ljava/lang/String;J)Ljava/lang/Long;", "(Ljava/lang/String;Ljava/lang/String;J)Lredis/clients/jedis/Response;", "([B[BJ)Ljava/lang/Long;", "(Ljava/lang/String;Ljava/lang/String;J)J", "([B[BJ)J"}), new MethodMatcher("hmset", new String[]{"(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;", "(Ljava/lang/String;Ljava/util/Map;)Lredis/clients/jedis/Response;", "([BLjava/util/Map;)Ljava/lang/String;"}), new MethodMatcher("smembers", new String[]{"(Ljava/lang/String;)Ljava/util/Set;", "(Ljava/lang/String;)Lredis/clients/jedis/Response;", "([B)Ljava/util/Set;"}), new MethodMatcher("sendCommand", new String[]{"(Lredis/clients/jedis/commands/ProtocolCommand;[[B)V", "(Lredis/clients/jedis/commands/ProtocolCommand;[Ljava/lang/String;)V", "(Lredis/clients/jedis/Protocol$Command;[[B)Lredis/clients/jedis/Connection;", "(Lredis/clients/jedis/CommandArguments;)V"}), new MethodMatcher("serviceRequest", "(Lorg/jredis/protocol/Command;[[B)Lorg/jredis/protocol/Response;")));
    }

    @Override
    public Tracker getTracker(String interceptedClzName, String interceptedMethName, Object thisObj, Object[] args) {
        if (interceptedMethName.equals("sendCommand")) {
            interceptedMethName = this.getMethodfromCommand(args);
        }
        BasicPointcutProperties p = new BasicPointcutProperties(interceptedClzName, interceptedMethName){

            @Override
            public Component getComponent() {
                return Component.REDIS;
            }
        };
        Tracker currOpenTracker = SequenceSpace.SEQUENCE_BOOK.get().getCurrentOpenTracker();
        if (currOpenTracker != null && currOpenTracker instanceof CachedFrameworkTracker) {
            return null;
        }
        CachedFrameworkTracker redisTracker = new CachedFrameworkTracker(p, thisObj, args);
        String address = this.extractServerAddress(thisObj);
        redisTracker.setServerAddr(address);
        return redisTracker;
    }

    private String extractServerAddress(Object serverInfoObj) {
        String address;
        block12: {
            address = null;
            Object clientObj = null;
            try {
                String clzName = serverInfoObj.getClass().getName();
                if (clzName.contains("jedis")) {
                    Method method;
                    clientObj = serverInfoObj;
                    if (clzName.endsWith("jedis.Jedis")) {
                        method = serverInfoObj.getClass().getMethod("getClient", new Class[0]);
                        clientObj = method.invoke(serverInfoObj, new Object[0]);
                    } else if (clzName.endsWith("jedis.Pipeline")) {
                        Field f = null;
                        try {
                            f = serverInfoObj.getClass().getSuperclass().getDeclaredField("client");
                        }
                        catch (NoSuchFieldException n) {
                            f = serverInfoObj.getClass().getDeclaredField("connection");
                        }
                        if (f != null) {
                            f.setAccessible(true);
                            clientObj = f.get(serverInfoObj);
                        }
                    }
                    try {
                        method = clientObj.getClass().getMethod("getHost", new Class[0]);
                        address = (String)method.invoke(clientObj, new Object[0]);
                        method = clientObj.getClass().getMethod("getPort", new Class[0]);
                        address = address + ":" + method.invoke(clientObj, new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        Method method2 = clientObj.getClass().getDeclaredMethod("getHostAndPort", new Class[0]);
                        method2.setAccessible(true);
                        address = method2.invoke(clientObj, new Object[0]).toString();
                    }
                    break block12;
                }
                if (clzName.contains("jredis")) {
                    Class<?> clz = serverInfoObj.getClass().getClassLoader().loadClass("org.jredis.ri.alphazero.connection.ConnectionBase");
                    Field field = clz.getDeclaredField("socketAddress");
                    field.setAccessible(true);
                    address = field.get(serverInfoObj).toString();
                }
            }
            catch (Throwable th) {
                JavaAgent.logger.log(Level.WARN, "[RedisTracker] Unable to extract redis server address. Exception: " + th.getMessage());
                address = null;
            }
        }
        return address;
    }

    private String getMethodfromCommand(Object[] args) {
        String methName = "";
        if (args[0].getClass().getSimpleName().equals("CommandArguments")) {
            try {
                Method m = args[0].getClass().getMethod("getCommand", new Class[0]);
                methName = m.invoke(args[0], new Object[0]).toString();
            }
            catch (Throwable th) {
                JavaAgent.logger.warn("Exception while invoking getCommand for Redis operation " + th.getMessage());
            }
        } else {
            methName = args[0].toString();
        }
        return methName;
    }
}

