/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.db;

import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutPropertiesPoolService;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.DBInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.PreparedStatementInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.InterfaceTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.db.StatementTracker;

public class StatementInterceptorDefinition
extends DBInterceptorDefinition {
    private static final String[] EXECUTE_METHOD_DESC = new String[]{"(Ljava/lang/String;)Z", "(Ljava/lang/String;I)Z", "(Ljava/lang/String;[I)Z", "(Ljava/lang/String;[Ljava/lang/String;)Z"};
    private static final String[] EXECUTEUPADTE_METHOD_DESC = new String[]{"(Ljava/lang/String;)I", "(Ljava/lang/String;I)I", "(Ljava/lang/String;[I)I", "(Ljava/lang/String;[Ljava/lang/String;)I"};
    public static final String STMT_EXECUTEBATCH = "executeBatch";

    public StatementInterceptorDefinition() {
        this(StatementInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new InterfaceTypeMatcher("java/sql/Statement"), new InterfaceTypeMatcher("com/mysql/cj/jdbc/JdbcStatement"), new InterfaceTypeMatcher("com/ibm/db2/jcc/DB2Statement"), new InterfaceTypeMatcher("com/mysql/jdbc/Statement"), new ClassMatcher("oracle/jdbc/driver/OracleStatement"), new InterfaceTypeMatcher("oracle/jdbc/internal/OracleStatement"), new ClassMatcher("weblogic/jdbc/wrapper/Statement"), new ClassTypeMatcher("weblogic/jdbc/wrapper/Statement"), new ClassMatcher("org/postgresql/jdbc3/AbstractJdbc3Statement"), new ClassMatcher("org/postgresql/jdbc2/AbstractJdbc2Statement"), new ClassMatcher("org/postgresql/jdbc/PgStatement"), new ClassMatcher("com/yugabyte/jdbc/PgStatement"), new ClassMatcher("com/sybase/jdbc2/jdbc/SybStatement"), new ClassMatcher("com/sybase/jdbc3/jdbc/SybStatement"), new ClassMatcher("com/sybase/jdbc4/jdbc/SybStatement"), new ClassMatcher("com/ibm/as400/access/AS400JDBCStatement"), new ClassMatcher("com/ibm/as400/access/JDStatementProxy"), new ClassMatcher("com/informix/jdbc/IfxStatement"), new InterfaceTypeMatcher("com/microsoft/sqlserver/jdbc/ISQLServerStatement")), null, new ManyMethodMatcher(new MethodMatcher("execute", EXECUTE_METHOD_DESC), new MethodMatcher("executeUpdate", EXECUTEUPADTE_METHOD_DESC), new MethodMatcher("executeQuery", "(Ljava/lang/String;)Ljava/sql/ResultSet;"), new MethodMatcher("addBatch", "(Ljava/lang/String;)V"), new MethodMatcher(STMT_EXECUTEBATCH, "()[I")));
    }

    public StatementInterceptorDefinition(String name, ClassTypeMatcher classTypeMatcher, MethodMatcher excludeMethodMatcher, MethodMatcher includeMethodMatcher) {
        super(name, classTypeMatcher, excludeMethodMatcher, includeMethodMatcher);
    }

    @Override
    public Tracker getTracker(String interceptedClz, String interceptedMethod, Object thisObj, Object[] args) {
        SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
        if (seqSpace.isActiveTransaction() && seqSpace.getConfig().captureSql) {
            if ("addBatch".equals(interceptedMethod)) {
                seqSpace.getQueryHolder().addBatchQuery(thisObj, (String)args[0]);
                return null;
            }
            return new StatementTracker(PointcutPropertiesPoolService.getOrCreateDBPointcutProperties(interceptedClz, interceptedMethod, this.getComponent(interceptedClz)), thisObj, args, this instanceof PreparedStatementInterceptorDefinition);
        }
        return null;
    }
}

