/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.db.r2dbc;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutPropertiesPoolService;
import com.manageengine.apminsight.agent.instrumentation.interceptor.db.DBInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.InterfaceTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.tracing.AsyncTracerService;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.db.r2dbc.R2DBCPostgreSqlTracker;
import com.manageengine.apminsight.agent.trackers.db.r2dbc.R2DBCPostgresExecuteTracker;
import java.lang.reflect.Field;

public class R2DBCPostgresInterceptorDefinition
extends DBInterceptorDefinition {
    public R2DBCPostgresInterceptorDefinition() {
        super(R2DBCPostgresInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new InterfaceTypeMatcher("io/r2dbc/postgresql/api/PostgresqlStatement"), new ClassMatcher("io/r2dbc/postgresql/PostgresqlConnection")), null, new ManyMethodMatcher(new MethodMatcher("execute", "(Ljava/lang/String;)Lreactor/core/publisher/Flux;"), new MethodMatcher("beginTransaction", "()Lreactor/core/publisher/Mono;")));
    }

    @Override
    public Tracker getTracker(String interceptedClzName, String interceptedMethName, Object thisObj, Object[] args) {
        Object contextObj;
        SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
        if (seqSpace.getConfig().captureSql && (contextObj = this.getContextObject(interceptedMethName, thisObj)) != null) {
            CallerAsyncRootTracker beginTracker;
            if (seqSpace.isActiveTransaction() && interceptedMethName.equals("beginTransaction")) {
                CallerAsyncRootTracker r2PgTracker = AsyncTracerService.getInstance().getTracker(contextObj.hashCode());
                return r2PgTracker == null ? new R2DBCPostgreSqlTracker(PointcutPropertiesPoolService.getOrCreateDBPointcutProperties(interceptedClzName, interceptedMethName, Component.PGSQL), thisObj, contextObj, args, false) : null;
            }
            if (interceptedMethName.equals("execute") && (beginTracker = AsyncTracerService.getInstance().evictTracker(contextObj.hashCode())) != null) {
                return new R2DBCPostgresExecuteTracker((R2DBCPostgreSqlTracker)beginTracker, thisObj, args);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getContextObject(String interceptedMethName, Object thisObj) {
        Object contextObj = null;
        Field f = null;
        try {
            try {
                f = thisObj.getClass().getDeclaredField("connectionContext");
            }
            catch (NoSuchFieldException ne) {
                try {
                    f = thisObj.getClass().getDeclaredField("context");
                }
                catch (NoSuchFieldException ne1) {
                    if (interceptedMethName.equals("execute")) {
                        f = thisObj.getClass().getDeclaredField("resources");
                        f.setAccessible(true);
                        Object resources = f.get(thisObj);
                        f = resources.getClass().getDeclaredField("connection");
                        f.setAccessible(true);
                        Object psconn = f.get(resources);
                        f = psconn.getClass().getDeclaredField("connectionContext");
                        f.setAccessible(true);
                        contextObj = f.get(psconn);
                    }
                }
            }
            finally {
                if (f != null && contextObj == null) {
                    f.setAccessible(true);
                    contextObj = f.get(thisObj);
                }
            }
            return contextObj;
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[R2DBC PostgresInterceptor] Exception when getting connection context for intercepted method {} : {}", interceptedMethName, th.getMessage());
            return null;
        }
    }
}

