/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.grpc;

import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.InterfaceTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.HandHoldingSpace;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.grpc.GrpcMetadataHandler;
import com.manageengine.apminsight.agent.trackers.grpc.GrpcServerCall;
import com.manageengine.apminsight.agent.trackers.grpc.GrpcServerCallTracker;
import com.manageengine.apminsight.agent.trackers.grpc.GrpcServerTracker;

public class GrpcServerListenerInterceptorDefinition
extends TracingInterceptorDefinition {
    public GrpcServerListenerInterceptorDefinition() {
        super(GrpcServerListenerInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new ClassMatcher("io/grpc/internal/ServerImpl$ServerTransportListenerImpl"), new InterfaceTypeMatcher("io/grpc/internal/ServerStream")), null, new ManyMethodMatcher(new MethodMatcher("wrapMethod", "(Lio/grpc/internal/ServerStream;Lio/grpc/ServerMethodDefinition;Lio/grpc/internal/StatsTraceContext;)Lio/grpc/ServerMethodDefinition;"), new MethodMatcher("startWrappedCall", "(Ljava/lang/String;Lio/grpc/internal/ServerImpl$ServerTransportListenerImpl$ServerCallParameters;Lio/grpc/Metadata;)Lio/grpc/internal/ServerStreamListener;"), new MethodMatcher("startCall", "(Lio/grpc/internal/ServerStream;Ljava/lang/String;Lio/grpc/ServerMethodDefinition;Lio/grpc/Metadata;Lio/grpc/Context$CancellableContext;Lio/grpc/internal/StatsTraceContext;Lio/perfmark/Tag;)Lio/grpc/internal/ServerStreamListener;"), new MethodMatcher("startCall", "(Lio/grpc/internal/ServerStream;Ljava/lang/String;Lio/grpc/ServerMethodDefinition;Lio/grpc/Metadata;Lio/grpc/Context$CancellableContext;Lio/grpc/internal/StatsTraceContext;)Lio/grpc/internal/ServerStreamListener;"), new MethodMatcher("close", "(Lio/grpc/Status;Lio/grpc/Metadata;)V"), new MethodMatcher("cancel", "(Lio/grpc/Status;)V")));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args) {
        if (methodName.equals("startCall") || methodName.equals("wrapMethod")) {
            BasicPointcutProperties pointcut = new BasicPointcutProperties(className, methodName);
            GrpcServerTracker serverTracker = new GrpcServerTracker(pointcut, thisObj, args);
            if (methodName.equals("startCall")) {
                this.checkDTHeaderInRequest(args[3], serverTracker.getServerCall());
                return serverTracker;
            }
            return null;
        }
        if (methodName.equals("startWrappedCall")) {
            GrpcServerTracker serverTracker = (GrpcServerTracker)HandHoldingSpace.SPACE.get().getObjectWithID(args[0]);
            if (serverTracker != null) {
                this.checkDTHeaderInRequest(args[2], serverTracker.getServerCall());
            }
            return serverTracker;
        }
        GrpcServerCallTracker serverCallTracker = (GrpcServerCallTracker)HandHoldingSpace.SPACE.get().consumeObject(thisObj);
        if (serverCallTracker == null) {
            return null;
        }
        if (methodName.equals("close") && serverCallTracker.isDTHeaderPresent()) {
            serverCallTracker.setResponseHeader(args[1]);
        }
        serverCallTracker.setStatus(args[0]);
        return null;
    }

    private void checkDTHeaderInRequest(Object metadata, GrpcServerCall serverCall) {
        boolean isDTHeaderPresent = GrpcMetadataHandler.containsHeader(metadata, "X-Site24x7-Id");
        serverCall.setDtHeaderPresent(isDTHeaderPresent);
    }
}

