/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.httpclient.async;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.HttpClientPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.InterfaceTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.tracing.AsyncTracerService;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.httpclient.async.apache.ApacheHttpClientAsyncTracker;

public class ApacheHttpClientAsyncInterceptorDefinition
extends TracingInterceptorDefinition {
    private static final String EXECUTION_METHOD = "execute";
    private static final String OPERATION_COMPLETED = "completed";
    private static final String OPERATION_FAILED = "failed";

    public ApacheHttpClientAsyncInterceptorDefinition() {
        super(ApacheHttpClientAsyncInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new InterfaceTypeMatcher(" org/apache/http/nio/client/HttpAsyncClient"), new ClassMatcher(" org/apache/http/concurrent/BasicFuture"), new InterfaceTypeMatcher(" org/apache/http/concurrent/FutureCallback")), null, new ManyMethodMatcher(new MethodMatcher(EXECUTION_METHOD, new String[]{"(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/protocol/HttpContext;Lorg/apache/http/concurrent/FutureCallback;)Ljava/util/concurrent/Future;", "(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/concurrent/FutureCallback;)Ljava/util/concurrent/Future;", "(Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/protocol/HttpContext;Lorg/apache/http/concurrent/FutureCallback;)Ljava/util/concurrent/Future;", "(Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/concurrent/FutureCallback;)Ljava/util/concurrent/Future;"}), new MethodMatcher(OPERATION_COMPLETED, new String[]{"(Ljava/lang/Object;)V", "(Ljava/lang/Object;)Z"}), new MethodMatcher(OPERATION_FAILED, new String[]{"(Ljava/lang/Exception;)V", "(Ljava/lang/Exception;)Z"}), new MethodMatcher("cancelled", "()V"), new MethodMatcher("cancel", "(Z)Z")));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args) {
        if (methodName.equals(EXECUTION_METHOD)) {
            Tracker currOpenTracker = SequenceSpace.SEQUENCE_BOOK.get().getCurrentOpenTracker();
            if (currOpenTracker != null && currOpenTracker instanceof ApacheHttpClientAsyncTracker || args == null || args.length == 0) {
                return null;
            }
            if (args[0] != null && args[0].getClass().getSimpleName().equals("HttpHost")) {
                Object obj = args[0];
                args[0] = args[1];
                args[1] = obj;
            }
            return new ApacheHttpClientAsyncTracker(new HttpClientPointcutProperties(className, methodName), thisObj, args);
        }
        this.handleCompletion(methodName, thisObj, args);
        return null;
    }

    private void handleCompletion(String methodName, Object thisObj, Object[] args) {
        try {
            CallerAsyncRootTracker tracker = AsyncTracerService.getInstance().evictTracker(thisObj.hashCode());
            if (tracker == null) {
                return;
            }
            switch (methodName) {
                case "completed": {
                    tracker.markCompleted(args[0]);
                    break;
                }
                case "failed": {
                    Throwable th = args != null && args.length > 0 ? (Throwable)args[0] : null;
                    tracker.markFailed(th);
                    break;
                }
                default: {
                    tracker.markCancelled();
                    break;
                }
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("ApacheAsyncHttp, error in handling completion of async.", th);
        }
    }
}

