/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.httpclient.async;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.InterfaceTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.HandHoldingSpace;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.httpclient.async.SpringReactiveExchangeFunctionTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class SpringReactiveWebClientInterceptorDefinition
extends TracingInterceptorDefinition {
    public static final String[] ENTITY_METHOD_DESC = new String[]{"(Ljava/lang/Class;)Lreactor/core/publisher/Mono;", "(Lorg/springframework/core/ParameterizedTypeReference;)Lreactor/core/publisher/Mono;"};

    public SpringReactiveWebClientInterceptorDefinition() {
        super(SpringReactiveWebClientInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new InterfaceTypeMatcher("org/springframework/web/reactive/function/client/WebClient$RequestBodyUriSpec"), new InterfaceTypeMatcher("org/springframework/web/reactive/function/client/ClientResponse")), null, new ManyMethodMatcher(new MethodMatcher("initRequestBuilder", "()Lorg/springframework/web/reactive/function/client/ClientRequest$Builder;"), new MethodMatcher("toEntity", ENTITY_METHOD_DESC), new MethodMatcher("toEntityList", ENTITY_METHOD_DESC), new MethodMatcher("body", "(Lorg/springframework/web/reactive/function/BodyExtractor;)Ljava/lang/Object;")));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args) {
        if (methodName.equals("initRequestBuilder")) {
            this.setDTHeaderInRequest(thisObj);
        } else {
            Object inserterRequest = null;
            try {
                Field f = thisObj.getClass().getDeclaredField("requestSupplier");
                f.setAccessible(true);
                Object requestSupplier = f.get(thisObj);
                Field[] supplierFields = requestSupplier.getClass().getDeclaredFields();
                supplierFields[1].setAccessible(true);
                inserterRequest = supplierFields[1].get(requestSupplier);
            }
            catch (Throwable th) {
                JavaAgent.logger.warn("[ReactiveWebClient] Exception occured when trying to get object of " + thisObj.getClass().getSimpleName() + ": " + th.getMessage());
                return null;
            }
            SpringReactiveExchangeFunctionTracker storedExchangeFuncTracker = (SpringReactiveExchangeFunctionTracker)HandHoldingSpace.SPACE.get().consumeObject(inserterRequest);
            if (storedExchangeFuncTracker != null) {
                storedExchangeFuncTracker.setStatusCode(this.getStatusCodefromResponse(thisObj));
                storedExchangeFuncTracker.getDTHeaderFromResponse(inserterRequest);
            }
        }
        return null;
    }

    private int getStatusCodefromResponse(Object respObj) {
        try {
            Method m = respObj.getClass().getMethod("statusCode", new Class[0]);
            m.setAccessible(true);
            int respCode = Integer.parseInt(m.invoke(respObj, new Object[0]).toString().split(" ")[0]);
            return respCode;
        }
        catch (Exception e) {
            JavaAgent.logger.warn("[ReactiveWebClient] Unable to get response code " + e.getMessage());
            return 0;
        }
    }

    public void setDTHeaderInRequest(Object requestObject) {
        try {
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            if (seqSpace.getConfig() != null && seqSpace.getConfig().isDistributedTracingEnabled()) {
                Class<?> requestClass = requestObject.getClass();
                Field f = requestClass.getDeclaredField("headers");
                f.setAccessible(true);
                Object headerObj = f.get(requestObject);
                if (headerObj == null) {
                    Method m = requestClass.getDeclaredMethod("getHeaders", new Class[0]);
                    m.setAccessible(true);
                    headerObj = m.invoke(requestObject, new Object[0]);
                }
                Class<?> clz = headerObj.getClass();
                Method m = clz.getMethod("add", String.class, String.class);
                m.setAccessible(true);
                m.invoke(headerObj, "X-Site24x7-Id", JavaAgent.getInstance().agentConfig.getDistributedTracingId());
                JavaAgent.logger.debug("[DistributedTracing] Outgoing request id added to header Reactive WebClient request.");
            }
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "[ReactiveWebClient] Unable to set DT header in request. Exception: " + e.getMessage());
        }
    }
}

