/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.jasper;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JasperInterceptorDefinition
extends TracingInterceptorDefinition {
    boolean isAlreadyUnderProcessing = false;

    public JasperInterceptorDefinition() {
        super(JasperInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new ClassMatcher("org/apache/jasper/compiler/Generator"), new ClassMatcher("org/apache/jasper/compiler/Generator$GenerateVisitor")), null, new ManyMethodMatcher(new MethodMatcher("generate", "(Lorg/apache/jasper/compiler/ServletWriter;Lorg/apache/jasper/compiler/Compiler;Lorg/apache/jasper/compiler/Node$Nodes;)V"), new MethodMatcher("visit", "(Lorg/apache/jasper/compiler/Node$TemplateText;)V")));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Tracker getTracker(String className, String methodName, Object clientObj, Object[] args) {
        if (JavaAgent.getInstance().getAgentConfig().isForceStopRumInjection()) return null;
        try {
            if (className.equals("org/apache/jasper/compiler/Generator") && methodName.equals("generate")) {
                Object compiler = args[1];
                Object jspCompilationContext = compiler.getClass().getMethod("getCompilationContext", new Class[0]).invoke(compiler, new Object[0]);
                String jspPage = (String)jspCompilationContext.getClass().getMethod("getJspFile", new Class[0]).invoke(jspCompilationContext, new Object[0]);
                String jspServletFile = (String)jspCompilationContext.getClass().getMethod("getServletJavaFileName", new Class[0]).invoke(jspCompilationContext, new Object[0]);
                JavaAgent.logger.info("[Jasper Interceptor] JSP \"" + jspPage + "\" is being compiled to: \"" + jspServletFile + "\"");
                return super.getTracker(className, methodName, clientObj, args);
            }
            Object templateTextNode = args[0];
            String text = (String)templateTextNode.getClass().getMethod("getText", new Class[0]).invoke(templateTextNode, new Object[0]);
            if (StringUtils.isEmptyString(text)) return null;
            Pattern htmlCommentPattern = Pattern.compile("<!\\s*--.*?--\\s*\\>", 32);
            Matcher matcher = htmlCommentPattern.matcher(text);
            int start = 0;
            while (matcher.find()) {
                this.processTemplateText(clientObj, templateTextNode, text.substring(start, matcher.start()), false);
                this.processTemplateText(clientObj, templateTextNode, text.substring(matcher.start(), matcher.end()), true);
                start = matcher.end();
            }
            this.processTemplateText(clientObj, templateTextNode, text.substring(start), false);
            Method m = templateTextNode.getClass().getMethod("setText", String.class);
            m.setAccessible(true);
            m.invoke(templateTextNode, "");
            return null;
        }
        catch (Throwable t) {
            try {
                JavaAgent.logger.warn("[Jasper Interceptor] Error: ", t.getCause());
                return null;
            }
            catch (Throwable t2) {
                JavaAgent.logger.info("Error in JasperTracker " + t2.getCause());
                return null;
            }
        }
    }

    private void processTemplateText(Object visitor, Object templateTextNode, String templateText, boolean isComment) throws Exception {
        Pattern htmlHeadTagEndPattern = Pattern.compile("</head(?!er)[^>]*>", 34);
        Matcher matcher = htmlHeadTagEndPattern.matcher(templateText);
        if (!isComment && matcher.find()) {
            this.visitWithTemplateText(visitor, templateTextNode, templateText.substring(0, matcher.start()));
            this.visitWithScriptlet(visitor, templateTextNode);
            this.visitWithTemplateText(visitor, templateTextNode, templateText.substring(matcher.start()));
        } else {
            this.visitWithTemplateText(visitor, templateTextNode, templateText);
        }
    }

    private void visitWithScriptlet(Object visitor, Object templateTextNode) throws Exception {
        ClassLoader classLoader = templateTextNode.getClass().getClassLoader();
        Class<?> scriptletNode = Class.forName("org.apache.jasper.compiler.Node$Scriptlet", false, classLoader);
        Class<?> mark = Class.forName("org.apache.jasper.compiler.Mark", false, classLoader);
        Class<?> node = Class.forName("org.apache.jasper.compiler.Node", false, classLoader);
        Constructor<?> cs = scriptletNode.getDeclaredConstructor(String.class, mark, node);
        cs.setAccessible(true);
        Object scriptlet = cs.newInstance(this.getScriptletContentToInject(), null, null);
        Method m = visitor.getClass().getMethod("visit", scriptletNode);
        m.setAccessible(true);
        m.invoke(visitor, scriptlet);
        JavaAgent.logger.info("[Jasper Interceptor] Successfully injected RUM API");
    }

    private void visitWithTemplateText(Object visitor, Object templateTextNode, String templateText) throws Exception {
        templateTextNode.getClass().getMethod("setText", String.class).invoke(templateTextNode, templateText);
        Method m = visitor.getClass().getMethod("visit", templateTextNode.getClass());
        m.setAccessible(true);
        m.invoke(visitor, templateTextNode);
    }

    private String getScriptletContentToInject() {
        return "\n\ttry {\n\t\tout.write(com.manageengine.apminsight.agent.rum.RumApi.getRUMSnippet_toInject());\n\t}\n\tcatch(java.lang.Throwable t) {}\n";
    }
}

