/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.jaxrs;

import com.manageengine.apminsight.agent.JavaAgent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JaxRSRequestPathFinder {
    private Map<String, Map<String, String[]>> classReqPathMapper = new ConcurrentHashMap<String, Map<String, String[]>>();

    private String[] extractData(String interceptedClassName, String interceptedMethodName, Object thisObj) {
        try {
            Class<?> clz = thisObj.getClass();
            String clzName = clz.getName().replaceAll("\\.", "/");
            if (!clzName.equals(interceptedClassName)) {
                JavaAgent.logger.debug("Jax RS class object mismatch, trying super class. clz: " + clz.getName());
                clz = clz.getSuperclass();
            }
            HashMap<String, String[]> data = new HashMap<String, String[]>();
            String classPathValue = "/";
            for (Annotation annotation : clz.getAnnotations()) {
                if (!annotation.annotationType().getSimpleName().equals("Path")) continue;
                classPathValue = this.getAnnotationValue(annotation);
                classPathValue = classPathValue + (!classPathValue.endsWith("/") ? "/" : "");
            }
            for (Method method : clz.getDeclaredMethods()) {
                String methodName = method.getName();
                String[] info = new String[]{"", classPathValue};
                if (data.containsKey(methodName)) {
                    data.put(methodName, info);
                    JavaAgent.logger.debug("Jax RS method overloading found, skipping " + clz.getName() + "." + methodName);
                    continue;
                }
                for (Annotation annotation : method.getAnnotations()) {
                    String annotationName = annotation.annotationType().getSimpleName();
                    if (annotationName.matches("GET|POST|PUT|DELETE|HEAD|OPTIONS")) {
                        info[0] = annotationName;
                        continue;
                    }
                    if (!annotationName.equals("Path")) continue;
                    info[1] = info[1] + this.getAnnotationValue(annotation);
                }
                data.put(methodName, info);
            }
            this.classReqPathMapper.put(interceptedClassName, data);
            return (String[])data.get(interceptedMethodName);
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Unable to get metadata for JaxRS class. clz: " + interceptedClassName);
            this.classReqPathMapper.put(interceptedClassName, new HashMap());
            return new String[]{"", ""};
        }
    }

    private String getAnnotationValue(Annotation annotation) {
        String value = "";
        try {
            Method m = annotation.annotationType().getDeclaredMethod("value", new Class[0]);
            value = (String)m.invoke((Object)annotation, new Object[0]);
            value = value.startsWith("/") ? value.substring(1) : value;
        }
        catch (Throwable th) {
            JavaAgent.logger.debug("JAX Unable to get annotation path. Exception: " + th.getMessage());
        }
        return value;
    }

    public String[] getHttpInfo(String clzName, String methodName, Object thisObj) {
        Map<String, String[]> methods = this.classReqPathMapper.get(clzName);
        if (methods == null) {
            return this.extractData(clzName, methodName, thisObj);
        }
        return methods.get(methodName);
    }
}

