/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.loggingframeworks;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.loggingframeworks.AbstractLoggerInterceptionDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.tracing.exception.ErrorRecord;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.text.MessageFormat;
import java.util.regex.Pattern;

public class JavaUtilLoggingInterceptorDefiniton
extends AbstractLoggerInterceptionDefinition {
    private static final Pattern JAVA_UTIL_LOGGING_LOG_METHOD_LEVEL_PATTERN = Pattern.compile("^.*(warning|severe).*$");
    private static final String LOG_METHOD_ARGS_LEVEL_STRING_THROW = "(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/Throwable;)V";
    private static final String LOG_METHOD_ARGS_LEVEL_STRING_OBJARR = "(Ljava/util/logging/Level;Ljava/lang/String;[Ljava/lang/Object;)V";
    private static final String LOG_METHOD_ARGS_LEVEL_STRING_OBJ = "(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/Object;)V";
    private static final String LOG_METHOD_ARGS_LEVEL_STRING = "(Ljava/util/logging/Level;Ljava/lang/String;)V";
    private static final String WARNING_METHOD = "warning";
    private static final String SEVERE_METHOD = "severe";
    private static final String WARNING_METHOD_ARGS = "(Ljava/lang/String;)V";
    private static final String SEVERE_METHOD_ARGS = "(Ljava/lang/String;)V";
    private static final String JAVA_UTIL_LOGGING_LOGGER = "java/util/logging/Logger";

    public JavaUtilLoggingInterceptorDefiniton() {
        super(JavaUtilLoggingInterceptorDefiniton.class.getName(), new AnyClassTypeMatcher(new ClassMatcher(JAVA_UTIL_LOGGING_LOGGER), new ClassTypeMatcher(JAVA_UTIL_LOGGING_LOGGER)), null, new ManyMethodMatcher(new MethodMatcher("log", LOG_METHOD_ARGS_LEVEL_STRING_THROW)), new String[]{WARNING_METHOD}, new String[]{SEVERE_METHOD});
        JavaAgent.getInstance().getClassRetransformEngine().retransformIfEscapedFromInstrumentation(JAVA_UTIL_LOGGING_LOGGER);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Tracker getTracker(String interceptedClz, String interceptedMethod, Object thisObj, Object[] args) {
        long logTime = System.currentTimeMillis();
        if (SequenceSpace.SEQUENCE_BOOK.get().currentTrackersCount() == 0) {
            SequenceSpace.SEQUENCE_BOOK.remove();
            return null;
        }
        if (args == null || args.length == 0) {
            StringBuilder sb = new StringBuilder("[JavaUtilLoggingInterceptorDefiniton] ");
            sb.append(interceptedClz);
            sb.append('.');
            sb.append(interceptedMethod);
            sb.append(" received zero arguments!");
            JavaAgent.logger.warn(sb.toString());
            return null;
        }
        try {
            String message = null;
            String logMethod = null;
            if ("log".equals(interceptedMethod)) {
                String levelAsString = args[0].toString().toLowerCase();
                if (!JAVA_UTIL_LOGGING_LOG_METHOD_LEVEL_PATTERN.matcher(levelAsString).matches()) return null;
                message = args.length > 2 && !(args[2] instanceof Throwable) ? MessageFormat.format(args[1].toString(), args[2]) : (args.length > 1 && args[1] != null ? args[1].toString() : "");
                logMethod = levelAsString;
            } else {
                message = (args[0] + "").trim();
                logMethod = interceptedMethod;
            }
            ErrorRecord logRecord = this.createLogRecord(logMethod, logTime, message, this.createLoggedThrowable(args));
            SequenceSpace.SEQUENCE_BOOK.get().getLogRecordBag().add(logRecord);
            return null;
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("[JavaUtilLoggingInterceptorDefiniton] ");
            sb.append(interceptedClz);
            sb.append('.');
            sb.append(interceptedMethod);
            sb.append(" unable to record the logging");
            JavaAgent.logger.log(Level.WARN, sb.toString(), e);
        }
        return null;
    }
}

