/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.messaging;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.messaging.MessagingTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Field;
import java.util.List;

public class KafkaInterceptorDefinition
extends TracingInterceptorDefinition {
    public KafkaInterceptorDefinition() {
        super(KafkaInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new ClassMatcher("org/apache/kafka/clients/producer/KafkaProducer"), new ClassMatcher("org/apache/kafka/clients/consumer/KafkaConsumer"), new ClassMatcher("org/apache/kafka/clients/producer/internals/RecordAccumulator")), null, new ManyMethodMatcher(new MethodMatcher("send", new String[]{"(Lorg/apache/kafka/clients/producer/ProducerRecord;Lorg/apache/kafka/clients/producer/Callback;)Ljava/util/concurrent/Future;"}), new MethodMatcher("append", new String[]{"(Lorg/apache/kafka/common/TopicPartition;J[B[B[Lorg/apache/kafka/common/header/Header;Lorg/apache/kafka/clients/producer/Callback;JZJ)Lorg/apache/kafka/clients/producer/internals/RecordAccumulator$RecordAppendResult;", "(Lorg/apache/kafka/common/TopicPartition;J[B[B[Lorg/apache/kafka/common/header/Header;Lorg/apache/kafka/clients/producer/Callback;J)Lorg/apache/kafka/clients/producer/internals/RecordAccumulator$RecordAppendResult;"}), new MethodMatcher("poll", new String[]{"(Lorg/apache/kafka/common/utils/Timer;Z)Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "(J)Lorg/apache/kafka/clients/consumer/ConsumerRecords;"})));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object clientObj, Object[] args) {
        if (className.equals("org/apache/kafka/clients/producer/internals/RecordAccumulator") && methodName.equals("append")) {
            this.updateServerInfoForProducer(args);
            return null;
        }
        String serverInfo = null;
        if (JavaAgentConfig.captureHostDetails) {
            serverInfo = this.extractServerInfo(clientObj);
        }
        BasicPointcutProperties pointcutProperties = new BasicPointcutProperties(className, methodName){

            @Override
            public Component getComponent() {
                return Component.KAFKA;
            }
        };
        return new MessagingTracker(serverInfo, pointcutProperties, clientObj, args);
    }

    private String extractServerInfo(Object clientObj) {
        try {
            Object cluster = this.getClusterObjFromClient(clientObj);
            Object nodeList = cluster.getClass().getMethod("nodes", new Class[0]).invoke(cluster, new Object[0]);
            if (!((List)nodeList).isEmpty()) {
                Object node = ((List)nodeList).get(0);
                return this.extractAddressFromNodeObj(node);
            }
            return null;
        }
        catch (Throwable t) {
            JavaAgent.logger.log(Level.WARN, "[Kafka] Couldn't extract server address", t);
            return null;
        }
    }

    private void updateServerInfoForProducer(Object[] args) {
        try {
            Tracker tOpen = SequenceSpace.SEQUENCE_BOOK.get().getCurrentOpenTracker();
            if (tOpen instanceof MessagingTracker) {
                Object topicPartition = args[0];
                Object clientObj = ((MessagingTracker)tOpen).getClientObj();
                Object cluster = this.getClusterObjFromClient(clientObj);
                Object node = cluster.getClass().getMethod("leaderFor", topicPartition.getClass()).invoke(cluster, topicPartition.getClass().cast(topicPartition));
                String address = this.extractAddressFromNodeObj(node);
                ((MessagingTracker)tOpen).setServerAddress(address);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Object getClusterObjFromClient(Object clientObj) throws Throwable {
        Field metadataField = clientObj.getClass().getDeclaredField("metadata");
        metadataField.setAccessible(true);
        Object metadata = metadataField.get(clientObj);
        return metadata.getClass().getMethod("fetch", new Class[0]).invoke(metadata, new Object[0]);
    }

    private String extractAddressFromNodeObj(Object node) throws Throwable {
        String host = (String)node.getClass().getMethod("host", new Class[0]).invoke(node, new Object[0]);
        String port = String.valueOf(node.getClass().getMethod("port", new Class[0]).invoke(node, new Object[0]));
        return host + ":" + port;
    }
}

