/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.spring.gateway;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.spring.gateway.SpringGatewayRootTracker;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.trackers.Tracker;
import java.lang.reflect.Method;

public class SpringGatewayInterceptorDefinition
extends TracingInterceptorDefinition {
    public SpringGatewayInterceptorDefinition() {
        super(SpringGatewayInterceptorDefinition.class.getName(), new ClassMatcher("org/springframework/cloud/gateway/filter/NettyRoutingFilter"), null, new MethodMatcher("filter", "(Lorg/springframework/web/server/ServerWebExchange;Lorg/springframework/cloud/gateway/filter/GatewayFilterChain;)Lreactor/core/publisher/Mono;"));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args) {
        try {
            Object request = this.getRequest(args[0]);
            return new SpringGatewayRootTracker(new BasicPointcutProperties(className, methodName), request);
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[Spring Gateway] Unable to detect url. Exception: " + th.getMessage());
            return null;
        }
    }

    private Object getRequest(Object serverExchange) throws Exception {
        Method m = serverExchange.getClass().getMethod("getRequest", new Class[0]);
        m.setAccessible(true);
        return m.invoke(serverExchange, new Object[0]);
    }
}

