/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.spring.gateway;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.WebSequenceConfig;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.trackers.WebSeqRootTracker;
import com.manageengine.apminsight.agent.trackers.http.HttpParamsObfuscator;
import com.manageengine.apminsight.agent.util.SequenceURINormalizer;
import com.manageengine.apminsight.agent.util.StringUtils;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;

public class SpringGatewayRootTracker
extends WebSeqRootTracker {
    private String uri;
    private String method;
    private String params;

    public SpringGatewayRootTracker(PointcutProperties pointcutProperties, Object request) {
        super(pointcutProperties, null, null);
        this.extractReqeustInfo(request);
    }

    private void extractReqeustInfo(Object request) {
        try {
            Method method = request.getClass().getMethod("getURI", new Class[0]);
            this.uri = method.invoke(request, new Object[0]).toString();
            method = request.getClass().getMethod("getMethod", new Class[0]);
            this.method = method.invoke(request, new Object[0]).toString();
            method = request.getClass().getMethod("getQueryParams", new Class[0]);
            this.params = method.invoke(request, new Object[0]).toString();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[SpringGateway] Unable to extract request info. Exception: " + th.getMessage());
        }
    }

    @Override
    protected String assignSequenceName() {
        try {
            URL url = new URL(this.uri);
            WebSequenceConfig webSeqConfig = ContextInfoManager.getInstance().getContextInfoOrDefault(this.httpContext).getConfig().getWebSeqConfig();
            this.unnormalizedSeqName = url.getPath();
            this.seqName = SequenceURINormalizer.normalizeURI(this.unnormalizedSeqName);
            if (webSeqConfig.canSeqNamingUseRequestURL()) {
                String hostPart = url.getHost() + (url.getPort() != -1 ? ":" + url.getPort() : "") + "/";
                this.unnormalizedSeqName = hostPart + this.unnormalizedSeqName;
                this.seqName = hostPart + this.seqName;
            }
            if (webSeqConfig.seqNamingUseMethodName()) {
                this.unnormalizedSeqName = this.method + " - " + this.unnormalizedSeqName;
                this.seqName = this.method + " - " + this.seqName;
            }
            this.params = webSeqConfig.isRecordSequenceTraceInputParams() ? HttpParamsObfuscator.obfuscate(this.params) : null;
            this.hasMetric = true;
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[Spring Gateway] Trouble assigning seq name. Exception: " + th.getMessage());
        }
        return StringUtils.isEmptyString(this.seqName) ? "unknown" : this.seqName;
    }

    @Override
    public Map<String, Object> getContextualMetrics() {
        LinkedHashMap<String, Object> xtraMetrics = new LinkedHashMap<String, Object>(4, 1.0f);
        xtraMetrics.put("http_method_name", this.method);
        if (this.params != null) {
            xtraMetrics.put("http_query_str", this.params);
        }
        return xtraMetrics;
    }
}

