/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.synapse;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.HttpClientPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.tracing.AsyncTracerService;
import com.manageengine.apminsight.agent.trackers.CalleeAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.MethodTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.httpclient.async.apache.nio.ApacheNioHttpRequestTracker;
import com.manageengine.apminsight.agent.trackers.synapse.SynapsePassThruClientCallTracker;
import com.manageengine.apminsight.agent.trackers.synapse.SynapseSourceHandlerTracker;
import java.lang.reflect.Method;

public class SynapsePassThruRequestInterceptorDefinition
extends TracingInterceptorDefinition {
    public SynapsePassThruRequestInterceptorDefinition() {
        super(SynapsePassThruRequestInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new ClassMatcher("org/apache/synapse/transport/passthru/PassThroughHttpSender"), new ClassMatcher("org/apache/synapse/transport/passthru/DeliveryAgent"), new ClassMatcher("org/apache/synapse/transport/passthru/ServerWorker"), new ClassMatcher("org/apache/synapse/transport/passthru/SourceHandler"), new ClassMatcher("org/apache/synapse/transport/passthru/TargetHandler")), null, new ManyMethodMatcher(new MethodMatcher("run", "()V"), new MethodMatcher("sendRequestContent", "(Lorg/apache/axis2/context/MessageContext;Lorg/apache/axis2/addressing/EndpointReference;)V"), new MethodMatcher("submitResponse", "(Lorg/apache/axis2/context/MessageContext;)V"), new MethodMatcher("submitRequest", "(Lorg/apache/http/nio/NHttpClientConnection;Lorg/apache/http/conn/routing/HttpRoute;Lorg/apache/axis2/context/MessageContext;)V"), new MethodMatcher("requestReceived", "(Lorg/apache/http/nio/NHttpServerConnection;)V"), new MethodMatcher("responseReady", "(Lorg/apache/http/nio/NHttpServerConnection;)V"), new MethodMatcher("requestReady", "(Lorg/apache/http/nio/NHttpClientConnection;)V"), new MethodMatcher("responseReceived", "(Lorg/apache/http/nio/NHttpClientConnection;)V")));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args) {
        try {
            BasicPointcutProperties bp = new BasicPointcutProperties(className, methodName);
            if (className.endsWith("SourceHandler")) {
                if (methodName.equals("requestReceived")) {
                    return new SynapseSourceHandlerTracker(bp, thisObj, args);
                }
                return new ApacheNioHttpRequestTracker.ApacheNioHttpServerResponseTracker(bp, thisObj, args);
            }
            if (className.endsWith("ServerWorker")) {
                try {
                    Method m = thisObj.getClass().getMethod("getSourceRequest", new Class[0]);
                    Object req = m.invoke(thisObj, new Object[0]);
                    m = req.getClass().getMethod("getRequest", new Class[0]);
                    req = m.invoke(req, new Object[0]);
                    SynapseSourceHandlerTracker t = (SynapseSourceHandlerTracker)AsyncTracerService.getInstance().evictTracker(req.hashCode());
                    return t != null ? new CalleeAsyncRootTracker(bp, t) : null;
                }
                catch (Throwable th) {
                    JavaAgent.logger.warn("[SynapseServer] Unable to get caller tracker for server worker. Exception: ", th);
                }
            }
            if (methodName.equals("sendRequestContent")) {
                bp = new HttpClientPointcutProperties(className, methodName);
                return new SynapsePassThruClientCallTracker(bp, thisObj, args);
            }
            if (methodName.equals("submitRequest")) {
                CallerAsyncRootTracker t = AsyncTracerService.getInstance().evictTracker(args[2].hashCode());
                if (t != null) {
                    t.setCallbackObj(args[0]);
                }
                return null;
            }
            if (className.endsWith("TargetHandler")) {
                if (methodName.equals("requestReady")) {
                    CallerAsyncRootTracker t = AsyncTracerService.getInstance().evictTracker(args[0].hashCode());
                    if (t != null) {
                        t.setCallbackObj(args[0]);
                    }
                    return null;
                }
                SynapsePassThruClientCallTracker t = (SynapsePassThruClientCallTracker)AsyncTracerService.getInstance().evictTracker(args[0].hashCode());
                if (t != null) {
                    t.setStatus(args[0]);
                    return new CalleeAsyncRootTracker(bp, t);
                }
                return null;
            }
            return new MethodTracker(bp, thisObj, args);
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Exception in SynapsePassThruInterceptor. Exception: " + th.getMessage(), th);
            return null;
        }
    }
}

