/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.integration;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.service.AgentServiceConstants;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.apminsight.agent.util.Utils;
import com.manageengine.org.apache.hc.client5.http.classic.methods.HttpGet;
import com.manageengine.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.manageengine.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class PlusServerIntegration
implements Runnable,
JavaAgentConstants,
AgentServiceConstants {
    private static final String PLUS_SCRIPT_FILE_URL = "https://staticdownloads.site24x7.com/server/Site24x7InstallScript.sh";
    private static final String PLUS_SCRIPT_FILENAME = "Site24x7InstallScript.sh";
    private static boolean integInProgress = false;

    @Override
    public void run() {
        Thread.currentThread().setName("PlusIntegrationService");
        if (integInProgress) {
            JavaAgent.logger.info("Server agent integration already in progress. Abroting new request.");
            return;
        }
        integInProgress = true;
        if (this.checkIfAlreadyInstalled()) {
            JavaAgent.logger.info("Site24x7 Server agent is already installed. Hence quitting new installation request.");
            return;
        }
        try {
            File plusAgentInstallScript = this.downloadScriptFile();
            this.executeScript(plusAgentInstallScript);
            plusAgentInstallScript.delete();
        }
        catch (Exception ex) {
            JavaAgent.logger.warn("Unable to install server agent. Exception: " + ex.getMessage());
        }
        integInProgress = false;
    }

    private boolean checkIfAlreadyInstalled() {
        boolean isInstalled = false;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"sh", "-c", "ps -ef | grep Site24x7Agent"});
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            while (line != null) {
                if (line.endsWith("lib/Site24x7Agent")) {
                    isInstalled = true;
                    break;
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception ex) {
            JavaAgent.logger.warn("Unable to check whether the server agent is already installed. Exception: " + ex.getMessage());
        }
        return isInstalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadScriptFile() throws IOException {
        File scriptFile = null;
        CloseableHttpClient client = JavaAgent.getInstance().getAgentService().getHttpClient();
        HttpGet request = new HttpGet(PLUS_SCRIPT_FILE_URL);
        try {
            CloseableHttpResponse resp = client.execute(request);
            scriptFile = new File(JavaAgentUtil.getAgentInstallDirectory(), PLUS_SCRIPT_FILENAME);
            if (scriptFile.exists()) {
                scriptFile.delete();
            }
            scriptFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(scriptFile);
            InputStream is = resp.getEntity().getContent();
            try {
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = is.read(buffer)) > 0) {
                    fos.write(buffer, 0, bytesRead);
                }
            }
            finally {
                is.close();
                fos.close();
            }
        }
        catch (Exception ex) {
            JavaAgent.logger.warn("Unable to download script from our servers. Exception: " + ex.getMessage());
        }
        return scriptFile;
    }

    private void executeScript(File scriptFile) throws IOException, InterruptedException {
        String licenseKey = JavaAgent.getInstance().agentConfig.getLicenseKey();
        ProcessBuilder processBuilder = null;
        if (JavaAgent.getInstance().agentConfig.isProxyEnabled()) {
            StringBuilder proxy = new StringBuilder();
            Properties props = Utils.getContentAsProps(new File(System.getProperty("apminsight.home"), "apminsight.conf"));
            if (props.getProperty("proxy.auth.username") != null) {
                proxy.append(props.getProperty("proxy.auth.username"));
                proxy.append(':');
                proxy.append(props.getProperty("proxy.auth.password"));
                proxy.append('@');
            }
            proxy.append(props.getProperty("proxy.server.host"));
            proxy.append(':');
            proxy.append(props.getProperty("proxy.server.port"));
            processBuilder = new ProcessBuilder(scriptFile.getAbsolutePath(), "-i", "-key=" + licenseKey, "-proxy=" + proxy.toString(), "-nr");
        } else {
            processBuilder = new ProcessBuilder(scriptFile.getAbsolutePath(), "-i", "-key=" + licenseKey, "-nr");
        }
        scriptFile.setExecutable(true);
        Process process = processBuilder.start();
        int exitValue = process.waitFor();
        JavaAgent.logger.info(exitValue == 0 ? "Successfully installed the Site24x7 server agent. Integration complete" : "Error installing Site24x7 Server agent process exited with value " + exitValue);
    }
}

