/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.jvm;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.communication.http.HttpClientBuilder;
import com.manageengine.apminsight.agent.communication.http.HttpConfig;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.apache.hc.client5.http.classic.methods.HttpGet;
import com.manageengine.org.apache.hc.client5.http.classic.methods.HttpPut;
import com.manageengine.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.manageengine.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.manageengine.org.apache.hc.core5.http.io.entity.EntityUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostEnvIdentifier
implements JavaAgentConstants {
    private static String actualHostType = "";

    public static String getHostType() {
        CloseableHttpResponse response;
        HttpGet request2;
        CloseableHttpClient httpClient;
        if (System.getenv("OPENSHIFT_BUILD_NAMESPACE") != null) {
            JavaAgent.logger.info("Agent is hosted in OpenShift");
            actualHostType = "OPENSHIFT";
        }
        if (HostEnvIdentifier.isKubernetes()) {
            JavaAgent.logger.info("Agent is hosted in Kubernetes");
            System.setProperty("is.autoscale.environment", "true");
            actualHostType = "KUBERNETES";
            return "DOCKER";
        }
        if (HostEnvIdentifier.isDocker()) {
            JavaAgent.logger.info("Agent is hosted in DOCKER");
            actualHostType = "DOCKER";
            return "DOCKER";
        }
        if (System.getenv("WEBSITE_SITE_NAME") != null && System.getenv("KUDU_APPPATH") != null) {
            JavaAgent.logger.info("Agent is hosted in AZURE WEBAPP service");
            actualHostType = "AZURE";
            return "AZURE";
        }
        try {
            httpClient = new HttpClientBuilder().setHttpConfig(new HttpConfig(2, 1)).build();
        }
        catch (Exception e) {
            JavaAgent.logger.error("[HostEnvIdentifier] Error initializing HttpClient", e);
            return HostEnvIdentifier.getFallbackHostType();
        }
        try {
            request2 = new HttpGet("http://169.254.169.254/latest/meta-data/instance-id");
            response = httpClient.execute(request2);
            if (response.getCode() == 200) {
                JavaAgent.logger.info("Agent is hosted in AWS EC2");
                String ec2InstanceID = EntityUtils.toString(response.getEntity());
                System.setProperty("cloud.instance.id", ec2InstanceID);
                HostEnvIdentifier.detectAutoscaleEnv("AWS", httpClient, null);
                actualHostType = "AWS";
                return "AWS";
            }
            if (response.getCode() == 401) {
                HttpPut tokenReq = new HttpPut("http://169.254.169.254/latest/api/token");
                tokenReq.addHeader("X-aws-ec2-metadata-token-ttl-seconds", 30);
                String token = EntityUtils.toString(httpClient.execute(tokenReq).getEntity());
                request2.addHeader("X-aws-ec2-metadata-token", token);
                response = httpClient.execute(request2);
                if (response.getCode() == 200) {
                    JavaAgent.logger.info("Agent is hosted in AWS EC2");
                    String ec2InstanceID = EntityUtils.toString(response.getEntity());
                    System.setProperty("cloud.instance.id", ec2InstanceID);
                    HostEnvIdentifier.detectAutoscaleEnv("AWS", httpClient, token);
                    actualHostType = "AWS";
                    return "AWS";
                }
            }
        }
        catch (Throwable request2) {
            // empty catch block
        }
        try {
            String uri = System.getenv("ECS_CONTAINER_METADATA_URI");
            uri = uri == null ? "http://169.254.170.2/v2/metadata" : uri;
            HttpGet request3 = new HttpGet(uri);
            CloseableHttpResponse response2 = httpClient.execute(request3);
            if (response2.getCode() == 200) {
                JavaAgent.logger.info("Agent is hosted in AWS Fargate");
                System.setProperty("is.autoscale.environment", "true");
                return "AWS";
            }
        }
        catch (Throwable uri) {
            // empty catch block
        }
        try {
            request2 = new HttpGet("http://169.254.169.254/metadata/v1/maintenance");
            request2.addHeader("Metadata", "true");
            response = httpClient.execute(request2);
            if (response.getCode() == 200) {
                JavaAgent.logger.info("Agent is hosted in AZURE VM");
                HostEnvIdentifier.detectAutoscaleEnv("AZURE", httpClient, null);
                actualHostType = "AZURE";
                return "AZURE";
            }
        }
        catch (Throwable request4) {
            // empty catch block
        }
        try {
            request2 = new HttpGet("http://metadata.google.internal/computeMetadata/v1/instance/id");
            request2.addHeader("Metadata-Flavor", "Google");
            response = httpClient.execute(request2);
            if (response.getCode() == 200) {
                JavaAgent.logger.info("Agent is hosted in GCP");
                actualHostType = "GCP";
                return "GCP";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            httpClient.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return HostEnvIdentifier.getFallbackHostType();
    }

    private static void detectAutoscaleEnv(String hostType, CloseableHttpClient httpClient, String token) {
        boolean isCloudEnv = false;
        try {
            switch (hostType) {
                case "AWS": {
                    CloseableHttpResponse response;
                    HttpGet request = new HttpGet("http://169.254.169.254/latest/meta-data/autoscaling/target-lifecycle-state");
                    if (token != null) {
                        request.addHeader("X-aws-ec2-metadata-token", token);
                    }
                    if ((response = httpClient.execute(request)).getCode() != 200) break;
                    isCloudEnv = true;
                    break;
                }
                case "AZURE": {
                    HttpGet request = new HttpGet("http://169.254.169.254/metadata/instance/compute/vmScaleSetName?api-version=2023-11-15&format=text");
                    request.addHeader("Metadata", "true");
                    CloseableHttpResponse response = httpClient.execute(request);
                    if (response.getCode() != 200) break;
                    String scaleSetName = EntityUtils.toString(response.getEntity());
                    if (StringUtils.isEmptyString(scaleSetName)) {
                        isCloudEnv = true;
                    }
                    break;
                }
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Unable to detect autoscaling env, Exception: " + th.getMessage());
        }
        JavaAgent.logger.info("Agent hosted in cloud env: " + isCloudEnv);
        System.setProperty("is.autoscale.environment", Boolean.toString(isCloudEnv));
    }

    private static boolean isKubernetes() {
        if (System.getenv("KUBERNETES_SERVICE_HOST") != null) {
            String hostname = System.getenv("HOSTNAME");
            if (!StringUtils.isEmptyString(hostname)) {
                System.setProperty("apminsight.hostname", hostname);
            }
            return true;
        }
        return false;
    }

    private static String getFallbackHostType() {
        String hostType = System.getProperty("agent.host.environment");
        if (hostType != null) {
            JavaAgent.logger.info("Agent is hosted in custom environment: " + hostType);
            return hostType.toUpperCase();
        }
        return "";
    }

    private static boolean isDocker() {
        File dockerenvFile = new File(File.separator + ".dockerenv");
        if (dockerenvFile.exists()) {
            try {
                String line;
                String dockId = null;
                BufferedReader reader = null;
                File dockerFile = new File("/proc/self/cgroup");
                if (dockerFile.exists() && dockerFile.canRead()) {
                    reader = new BufferedReader(new FileReader(dockerFile));
                    Pattern p = Pattern.compile("^/(docker/|lxc/|.+?/docker-|ecs/.+?/|kubepods/.+?/)([a-f0-9]+)($|\\.scope|/kubepods.*)");
                    while ((line = reader.readLine()) != null) {
                        Matcher m;
                        String[] parts = line.split(":");
                        if (parts.length != 3 || !parts[1].matches("^cpu(.+|$)") || !(m = p.matcher(parts[2])).matches()) continue;
                        dockId = m.group(2);
                        break;
                    }
                    reader.close();
                }
                if (dockId == null) {
                    dockerFile = new File("/proc/self/mountinfo");
                    reader = new BufferedReader(new FileReader(dockerFile));
                    while ((line = reader.readLine()) != null) {
                        String[] parts = line.split("docker/containers/");
                        if (parts.length != 2) continue;
                        dockId = parts[1].split("/", 2)[0];
                        break;
                    }
                    reader.close();
                }
                if (dockId != null && System.getProperty("apminsight.hostname") == null) {
                    System.setProperty("apminsight.hostname", dockId);
                }
            }
            catch (IOException ioe) {
                JavaAgent.logger.warn("Exception while trying to get container ID for Docker : " + ioe.getMessage());
            }
            return true;
        }
        return false;
    }

    public static String getActualHostType() {
        return actualHostType;
    }
}

