/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.jvm.monitor;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.jvm.monitor.ThreadMetricsCollector;
import com.manageengine.apminsight.agent.jvm.monitor.VmMetricsCollector;
import com.manageengine.apminsight.agent.metrics.GlobalMetrics;
import com.manageengine.apminsight.agent.metrics.JvmMetric;
import com.manageengine.apminsight.agent.metrics.ThreadMetric;
import com.manageengine.apminsight.agent.metrics.VirtualMachineMetric;
import com.manageengine.apminsight.agent.metrics.store.MetricStore;
import com.manageengine.apminsight.agent.metrics.store.MetricStoreController;

public class JvmMonitor {
    private static JvmMonitor singletonThiz;
    private final VmMetricsCollector vmMetricCollector = new VmMetricsCollector();
    private final ThreadMetricsCollector threadMetricCollector = new ThreadMetricsCollector();
    protected VirtualMachineMetric vmMetric = new VirtualMachineMetric();
    protected ThreadMetric threadMetric = new ThreadMetric();

    private JvmMonitor() {
    }

    public static JvmMonitor getInstance() {
        if (singletonThiz == null) {
            singletonThiz = new JvmMonitor();
        }
        return singletonThiz;
    }

    public void startPolling() {
        if (!JavaAgent.getInstance().agentConfig.isCaptureJVMMetricsEnabled()) {
            JavaAgent.logger.info("[JvmMonitor] Jvm Metric Collection is disabled by user");
            return;
        }
        Thread.currentThread().setName("apminsight-jvm-monitor");
        JavaAgent.logger.debug("[JvmMonitor] Jvm Metric Collection Started.");
        this.vmMetric = this.vmMetricCollector.startDataCollection();
        this.threadMetric = this.threadMetricCollector.startDataCollection();
        this.pushMetricsToStore();
        JavaAgent.logger.info("[JvmMonitor] Jvm Metric Collection Finished.");
    }

    private void pushMetricsToStore() {
        if (ContextInfoManager.getInstance().getDefaultContextInfo().isActive()) {
            MetricStore activeMetricStore = MetricStoreController.getMetricStore();
            JvmMetric jvmMetric = (JvmMetric)activeMetricStore.getMetric(GlobalMetrics.I_JVM, true).getMetricData();
            jvmMetric.recordData(this.vmMetric, this.threadMetric);
        }
    }

    public VirtualMachineMetric getVmMetric() {
        return this.vmMetric;
    }

    public ThreadMetric getThreadMetric() {
        return this.threadMetric;
    }
}

