/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.jvm.monitor;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.metrics.ThreadMetric;
import com.manageengine.apminsight.agent.tracing.StackTrace;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class ThreadMetricsCollector {
    private int liveCount = -1;
    private int daemonCount = -1;
    private long totalStartedCount = -1L;
    private int peakCount = -1;
    private int sleepCount = -1;
    private int blockedThreadsCount = -1;
    private long cpuTime = -1L;
    private long userTime = -1L;
    private long totalCpuTime = -1L;
    private long totalUserTime = -1L;
    private float cpuUtil = -1.0f;
    private Long threadId = 0L;
    private static boolean isCpuTimeEnabled = false;
    private static ThreadMXBean threadMXBean;
    private Thread.State timedWaiting = Thread.State.TIMED_WAITING;
    private String terminated = Thread.State.TERMINATED.toString();
    private HashMap<Long, Object[]> allThreadsInfo = new HashMap();
    private HashMap<Long, Object[]> deadlockedThreads = new LinkedHashMap<Long, Object[]>();
    private static Pattern excludePattern;
    private long jvmUptime;
    private String excludedThreads = "agentsc.*|apminsight.*";

    public ThreadMetricsCollector() {
        try {
            threadMXBean = ManagementFactory.getThreadMXBean();
            excludePattern = Pattern.compile(this.excludedThreads);
            if (threadMXBean.isThreadCpuTimeSupported()) {
                threadMXBean.setThreadCpuTimeEnabled(true);
                isCpuTimeEnabled = true;
            } else {
                JavaAgent.logger.log(Level.WARN, "[ThreadMetricsCollector] Cannot collect CPU Time Metrics. ThreadCpuTime is not supported");
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[ThreadMetricsCollector] Initialization Failed! " + th);
        }
    }

    public ThreadMetric startDataCollection() {
        this.reset();
        this.collectMetrics();
        return this.formatCollectedData();
    }

    private void collectMetrics() {
        try {
            this.collectThreadBeanMetrics();
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[ThreadMetricsCollector] Failed to get metrics from ThreadMXBean instance. " + th);
        }
        try {
            this.collectThreadInfoMetrics(1);
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[ThreadMetricsCollector] Failed to get metrics from ThreadInfo Instance. " + th);
        }
        try {
            this.collectDeadlockedThreads();
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[ThreadMetricsCollector] Failed to get deadlocked thread metrics. " + th);
        }
    }

    private void collectThreadBeanMetrics() throws Throwable {
        this.liveCount = threadMXBean.getThreadCount();
        this.daemonCount = threadMXBean.getDaemonThreadCount();
        this.peakCount = threadMXBean.getPeakThreadCount();
        this.totalStartedCount = threadMXBean.getTotalStartedThreadCount();
    }

    private void collectThreadInfoMetrics(int stackDepth) throws Throwable {
        Object[] info = null;
        boolean isExists = false;
        int processorCount = Runtime.getRuntime().availableProcessors();
        for (ThreadInfo threadInfo : threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), stackDepth)) {
            if (excludePattern.matcher(threadInfo.getThreadName()).matches()) {
                --this.liveCount;
                --this.daemonCount;
                --this.totalStartedCount;
                --this.peakCount;
                continue;
            }
            if (threadInfo.getThreadState() == Thread.State.BLOCKED) {
                this.blockedThreadsCount = this.blockedThreadsCount < 0 ? 1 : this.blockedThreadsCount + 1;
            }
            this.threadId = threadInfo.getThreadId();
            if (this.allThreadsInfo.containsKey(this.threadId)) {
                info = this.allThreadsInfo.get(this.threadId);
                isExists = true;
            } else {
                info = new Object[3];
                isExists = false;
            }
            info[0] = threadInfo.getThreadState().toString();
            if (threadInfo.getThreadState() == this.timedWaiting && threadInfo.getStackTrace()[0].getMethodName().equals("sleep")) {
                ++this.sleepCount;
            }
            if (isCpuTimeEnabled) {
                this.cpuTime = TimeUnit.NANOSECONDS.toMillis(threadMXBean.getThreadCpuTime(this.threadId));
                this.userTime = TimeUnit.NANOSECONDS.toMillis(threadMXBean.getThreadUserTime(this.threadId));
                this.totalCpuTime += info[1] == null || this.cpuTime < (Long)info[1] ? this.cpuTime : this.cpuTime - (Long)info[1];
                this.totalUserTime += info[2] == null || this.userTime < (Long)info[2] ? this.userTime : this.userTime - (Long)info[2];
            }
            info[1] = this.cpuTime;
            info[2] = this.userTime;
            if (isExists) continue;
            this.allThreadsInfo.put(this.threadId, info);
        }
        this.totalCpuTime /= (long)processorCount;
        this.totalUserTime /= (long)processorCount;
        long currentJvmUptime = ManagementFactory.getRuntimeMXBean().getUptime();
        this.cpuUtil = Math.min((float)this.totalCpuTime * 100.0f / (float)(currentJvmUptime - this.jvmUptime), 100.0f);
        this.jvmUptime = currentJvmUptime;
    }

    private void collectDeadlockedThreads() throws Throwable {
        Object[] info = null;
        long[] deadlockedThreadsId = threadMXBean.findMonitorDeadlockedThreads();
        if (deadlockedThreadsId == null) {
            return;
        }
        for (ThreadInfo threadInfo : threadMXBean.getThreadInfo(deadlockedThreadsId, JavaAgent.getInstance().agentConfig.threadDumpMaxDepth)) {
            info = new Object[]{threadInfo.getThreadName(), threadInfo.getLockName().split("@")[0], threadInfo.getLockOwnerId(), threadInfo.getLockOwnerName(), new StackTrace(threadInfo.getStackTrace())};
            this.deadlockedThreads.put(threadInfo.getThreadId(), info);
        }
    }

    private ThreadMetric formatCollectedData() {
        ThreadMetric metric = new ThreadMetric();
        metric.recordData(this.liveCount, this.daemonCount, this.totalStartedCount, this.peakCount, this.sleepCount, this.blockedThreadsCount, this.totalCpuTime, this.totalUserTime, this.cpuUtil, this.allThreadsInfo, this.deadlockedThreads);
        return metric;
    }

    private void reset() {
        this.blockedThreadsCount = -1;
        this.peakCount = -1;
        this.sleepCount = -1;
        this.daemonCount = -1;
        this.liveCount = -1;
        this.totalUserTime = -1L;
        this.totalCpuTime = -1L;
        this.totalStartedCount = -1L;
        this.cpuUtil = -1.0f;
        this.deadlockedThreads.clear();
        int count = 0;
        Long[] deadThreadIds = new Long[this.allThreadsInfo.size()];
        try {
            for (Map.Entry<Long, Object[]> entry : this.allThreadsInfo.entrySet()) {
                if (entry.getValue()[0].toString().equals(this.terminated)) {
                    deadThreadIds[count++] = entry.getKey();
                    continue;
                }
                entry.getValue()[0] = this.terminated;
            }
            while (count > 0) {
                this.allThreadsInfo.remove(deadThreadIds[--count]);
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[ThreadMetricsCollector] Failed to reset thread metrics. " + th);
        }
    }
}

