/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.jvm.monitor;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;

public class ThreadMxBeanUtil {
    private static boolean isThreadCpuTimeEnabled = false;
    private static boolean isThreadAllocatedMemoryEnabled = false;
    private static Method methodGetThreadAllocBytes = null;
    private static ThreadMXBean threadMxBean = null;

    public static void initialize() {
        threadMxBean = ManagementFactory.getThreadMXBean();
        try {
            if (threadMxBean.isThreadCpuTimeSupported() && !(isThreadCpuTimeEnabled = threadMxBean.isThreadCpuTimeEnabled())) {
                threadMxBean.setThreadCpuTimeEnabled(true);
                isThreadCpuTimeEnabled = true;
                JavaAgent.logger.info("ThreadMxBeanUtil: Thread Cpu time set to enabled.");
            }
        }
        catch (Exception e) {
            isThreadCpuTimeEnabled = false;
            JavaAgent.logger.log(Level.WARN, "ThreadMxBeanUtil", e);
        }
        JavaAgent.logger.info("ThreadMxBeanUtil: Cpu time extraction for threads are " + (isThreadCpuTimeEnabled ? "" : " not ") + "supported.");
        try {
            Class<?> sunThreadMXBeanClz = Class.forName("com.sun.management.ThreadMXBean");
            Method m = sunThreadMXBeanClz.getMethod("isThreadAllocatedMemorySupported", new Class[0]);
            if (((Boolean)m.invoke((Object)threadMxBean, new Object[0])).booleanValue()) {
                m = sunThreadMXBeanClz.getMethod("setThreadAllocatedMemoryEnabled", Boolean.TYPE);
                m.invoke((Object)threadMxBean, true);
                isThreadAllocatedMemoryEnabled = true;
                JavaAgent.logger.log(Level.INFO, "ThreadMxBeanUtil: Thread allocated memory set to enabled.");
            }
            methodGetThreadAllocBytes = sunThreadMXBeanClz.getMethod("getThreadAllocatedBytes", Long.TYPE);
        }
        catch (Exception e) {
            isThreadAllocatedMemoryEnabled = false;
            JavaAgent.logger.log(Level.WARN, "ThreadMxBeanUtil", e);
        }
        JavaAgent.logger.info("ThreadMxBeanUtil: Memory allocation info for threads are " + (isThreadAllocatedMemoryEnabled ? "" : " not ") + "supported.");
    }

    public static long getCurrThreadTotalCpuTimeInNanoSec() {
        return ThreadMxBeanUtil.getThreadTotalCpuTimeInNanoSec(Thread.currentThread().getId());
    }

    public static long getThreadTotalCpuTimeInNanoSec(long id) {
        if (isThreadCpuTimeEnabled) {
            try {
                return ManagementFactory.getThreadMXBean().getThreadCpuTime(id);
            }
            catch (Exception e) {
                JavaAgent.logger.log(Level.WARN, "ThreadMxBeanUtil: Unable to get thread Cpu time. Exception: " + e.getMessage());
            }
        }
        return -1L;
    }

    public static long getCurrThreadAllocatedBytes() {
        return ThreadMxBeanUtil.getThreadAllocatedBytes(Thread.currentThread().getId());
    }

    public static long getThreadAllocatedBytes(long id) {
        if (isThreadAllocatedMemoryEnabled) {
            try {
                return (Long)methodGetThreadAllocBytes.invoke((Object)threadMxBean, id);
            }
            catch (Exception e) {
                JavaAgent.logger.log(Level.WARN, "ThreadMxBeanUtil: Unable to extract memory information. Exception: " + e.getMessage());
            }
        }
        return -1L;
    }

    public static StackTraceElement[] getStackTrace(long threadId) {
        return ManagementFactory.getThreadMXBean().getThreadInfo(threadId).getStackTrace();
    }

    public static ThreadInfo[] dumpAllThreads(boolean withLockInfo) {
        return ManagementFactory.getThreadMXBean().dumpAllThreads(withLockInfo, withLockInfo);
    }
}

