/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.logging;

import com.manageengine.apminsight.agent.exception.FatalException;
import com.manageengine.apminsight.agent.logging.AgentLogManager;
import com.manageengine.apminsight.agent.logging.LoggingConfig;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.apache.logging.log4j.core.LoggerContext;
import com.manageengine.org.apache.logging.log4j.core.config.Configuration;
import com.manageengine.org.apache.logging.log4j.core.config.Configurator;
import com.manageengine.org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import com.manageengine.org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import com.manageengine.org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import com.manageengine.org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import com.manageengine.org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import com.manageengine.org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import com.manageengine.org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import com.manageengine.org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class AgentLoggingInitializer {
    private static final AgentLoggingInitializer INSTANCE = new AgentLoggingInitializer();
    LoggerContext loggerContext = null;

    private AgentLoggingInitializer() {
    }

    public static AgentLoggingInitializer getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(LoggingConfig agentLoggingConfig) throws FatalException {
        HashMap<String, String> sysProps = new HashMap<String, String>();
        sysProps.put("apm.log4j2.loggerContextFactory", "com.manageengine.org.apache.logging.log4j.core.impl.Log4jContextFactory");
        sysProps.put("APMLog4jContextSelector", "com.manageengine.org.apache.logging.log4j.core.selector.BasicContextSelector");
        sysProps.put("apm.log4j2.disable.jmx", "true");
        this.overrideSystemProperties(sysProps);
        ConfigurationBuilder<BuiltConfiguration> configurationBuilder = ConfigurationBuilderFactory.newConfigurationBuilder();
        configurationBuilder.setStatusLevel(Level.ERROR);
        if (agentLoggingConfig.getLogger() == LoggingConfig.STARTUP_LOGGER.getLogger() || agentLoggingConfig.getLogger() == LoggingConfig.CONSOLE_LOGGER.getLogger()) {
            this.configureAgentStartupLogger(configurationBuilder, agentLoggingConfig);
        } else {
            this.configureAgentLogger(configurationBuilder, agentLoggingConfig);
            this.configureDiagnosticLogger(configurationBuilder);
        }
        try {
            if (this.loggerContext == null) {
                this.loggerContext = Configurator.initialize((Configuration)configurationBuilder.build());
            } else {
                this.loggerContext.reconfigure((Configuration)configurationBuilder.build());
            }
        }
        finally {
            this.rollbackOverriddenSystemProperties(sysProps);
        }
        if (this.loggerContext == null) {
            String error = "[APMInsight][SEVERE]: Agent logging initialization failed! Agent startup aborted.";
            JavaAgentUtil.writeToErrStream(error);
            throw new FatalException(error);
        }
        AgentLogManager.getInstance().setLoggerContext(this.loggerContext);
        this.deleteObsoleteLogFiles(agentLoggingConfig);
    }

    private void configureAgentStartupLogger(ConfigurationBuilder<BuiltConfiguration> configurationBuilder, LoggingConfig config) {
        RootLoggerComponentBuilder rootLogger = configurationBuilder.newRootLogger(config.getLevel());
        if (config == LoggingConfig.CONSOLE_LOGGER) {
            rootLogger.add(configurationBuilder.newAppenderRef(this.addNewConsoleAppender(configurationBuilder, config)));
        } else {
            rootLogger.add(configurationBuilder.newAppenderRef(this.addNewRollingFileAppender(configurationBuilder, config)));
        }
        configurationBuilder.add(rootLogger);
    }

    private void configureAgentLogger(ConfigurationBuilder<BuiltConfiguration> configurationBuilder, LoggingConfig config) {
        LoggerComponentBuilder agentLogger = configurationBuilder.newLogger(config.getLoggerName(), config.getLevel());
        agentLogger.addAttribute("additivity", "false");
        agentLogger.add(configurationBuilder.newAppenderRef(this.addNewRollingFileAppender(configurationBuilder, config)));
        configurationBuilder.add(agentLogger);
    }

    private void configureDiagnosticLogger(ConfigurationBuilder<BuiltConfiguration> configurationBuilder) {
        LoggingConfig config = LoggingConfig.DIAGNOSTIC_LOGGER;
        LoggerComponentBuilder diagnosticLogger = configurationBuilder.newLogger(config.getLoggerName(), config.getLevel());
        diagnosticLogger.addAttribute("additivity", "false");
        diagnosticLogger.add(configurationBuilder.newAppenderRef(this.addNewRollingFileAppender(configurationBuilder, config)));
        configurationBuilder.add(diagnosticLogger);
    }

    private String addNewConsoleAppender(ConfigurationBuilder<BuiltConfiguration> configurationBuilder, LoggingConfig config) {
        AppenderComponentBuilder consoleAppender = configurationBuilder.newAppender(config.getAppenderName(), "Console");
        LayoutComponentBuilder patternLayout = configurationBuilder.newLayout("PatternLayout");
        patternLayout.addAttribute("pattern", config.getLogPattern());
        consoleAppender.add(patternLayout);
        configurationBuilder.add(consoleAppender);
        return config.getAppenderName();
    }

    private String addNewRollingFileAppender(ConfigurationBuilder<BuiltConfiguration> configurationBuilder, LoggingConfig config) {
        AppenderComponentBuilder rollingFileAppender = configurationBuilder.newAppender(config.getAppenderName(), "RollingFile");
        String logFileName = config.getLogDir() + "/" + config.getLogFileName();
        rollingFileAppender.addAttribute("fileName", logFileName);
        rollingFileAppender.addAttribute("filePattern", logFileName + ".%i");
        rollingFileAppender.addAttribute("createOnDemand", "true");
        LayoutComponentBuilder patternLayout = configurationBuilder.newLayout("PatternLayout");
        patternLayout.addAttribute("pattern", config.getLogPattern());
        rollingFileAppender.add(patternLayout);
        rollingFileAppender.addComponent((ComponentBuilder<?>)configurationBuilder.newComponent("Policies").addComponent((ComponentBuilder<?>)configurationBuilder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", config.getLogLimit() + "MB")));
        rollingFileAppender.addComponent((ComponentBuilder<?>)configurationBuilder.newComponent("DefaultRolloverStrategy").addAttribute("fileIndex", "").addComponent((ComponentBuilder<?>)configurationBuilder.newComponent("Delete").addAttribute("basePath", config.getLogDir()).addComponent((ComponentBuilder<?>)configurationBuilder.newComponent("IfFileName").addAttribute("regex", config.getLogFileNamePattern())).addComponent((ComponentBuilder<?>)configurationBuilder.newComponent("IfAccumulatedFileCount").addAttribute("exceeds", config.getLogFileCount()))));
        configurationBuilder.add(rollingFileAppender);
        return config.getAppenderName();
    }

    private void deleteObsoleteLogFiles(final LoggingConfig config) {
        File logDir = new File(config.getLogDir());
        File[] logFiles = logDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return Pattern.compile("^" + config.getLogFileNamePattern() + "$").matcher(name).matches();
            }
        });
        if (logFiles.length > config.getLogFileCount()) {
            Arrays.sort(logFiles, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return -1 * Long.valueOf(file1.lastModified()).compareTo(file2.lastModified());
                }
            });
            for (int i = config.getLogFileCount(); i < logFiles.length; ++i) {
                try {
                    logFiles[i].delete();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void overrideSystemProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String propValueToSet = entry.getValue();
            properties.put(entry.getKey(), System.getProperty(entry.getKey()));
            System.setProperty(entry.getKey(), propValueToSet);
        }
    }

    private void rollbackOverriddenSystemProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String originalValue = entry.getValue();
            if (originalValue != null) {
                System.setProperty(entry.getKey(), originalValue);
                continue;
            }
            System.clearProperty(entry.getKey());
        }
    }
}

