/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.logging;

import com.manageengine.apminsight.agent.logging.AgentLogManager;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.logging.LoggingConstants;
import com.manageengine.org.apache.logging.log4j.Level;

public enum LoggingConfig {
    AGENT_LOGGER("APMInsight-Agent", ".", "apminsight.log", 5, 10, LoggingConstants.LOG_LEVEL_DV, "[%d{dd MMM yyyy HH:mm:ss.SSS}][%t][%p]: %m%n", "agentRollingFile", false),
    CONSOLE_LOGGER("APMInsight-Console", null, null, 0, 0, LoggingConstants.LOG_LEVEL_DV, "[%d{dd MMM yyyy HH:mm:ss.SSS}]-APM-[%t][%p]: %m%n", "agentConsole", true),
    DIAGNOSTIC_LOGGER("APMInsight-Diagnostics", ".", "apminsight_diagnostics.log", 5, 3, LoggingConstants.LOG_LEVEL_DV, "%m%n", "agentDiagnosticsRollingFile", false),
    STARTUP_LOGGER("APMInsight-Startup", ".", "apminsight_startup.log", 1, 5, LoggingConstants.LOG_LEVEL_DV, "[%d{dd MMM yyyy HH:mm:ss.SSS}][%t][%p]: %m%n", "agentStartupRollingFile", true);

    private String loggerName;
    private String appenderName;
    private String logDir;
    private String logFileName;
    private int logLimit;
    private int logFileCount;
    private Level level;
    private String logPattern;
    private String logFileNamePattern;
    private AgentLogger logger;
    private boolean isRootLogger;

    private LoggingConfig(String loggerName, String logDir, String logFileName, int logLimit, int logFileCount, Level level, String logPattern, String appenderName, boolean isRootLogger) {
        this.loggerName = loggerName;
        this.logDir = logDir;
        this.logFileName = logFileName;
        this.logLimit = logLimit;
        this.logFileCount = logFileCount;
        this.level = level;
        this.logPattern = logPattern;
        this.logFileNamePattern = logFileName + ".*";
        this.appenderName = appenderName;
        this.isRootLogger = isRootLogger;
    }

    public LoggingConfig setLogDir(String logDir) {
        this.logDir = logDir;
        return this;
    }

    public LoggingConfig setLogFileName(String logFileName) {
        this.logFileName = logFileName;
        return this;
    }

    public LoggingConfig setLevel(Level level) {
        this.level = level;
        return this;
    }

    public LoggingConfig setLogFileNamePattern(String logFileNamePattern) {
        this.logFileNamePattern = logFileNamePattern;
        return this;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getAppenderName() {
        return this.appenderName;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public int getLogLimit() {
        return this.logLimit;
    }

    public int getLogFileCount() {
        return this.logFileCount;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getLogPattern() {
        return this.logPattern;
    }

    public String getLogFileNamePattern() {
        return this.logFileNamePattern;
    }

    public boolean isRootLogger() {
        return this.isRootLogger;
    }

    public AgentLogger getLogger() {
        if (this.logger == null) {
            this.logger = AgentLogManager.getInstance().getLogger(this);
        }
        return this.logger;
    }

    public String toString() {
        return "LoggingConfig{loggerName='" + this.loggerName + '\'' + ", appenderName='" + this.appenderName + '\'' + ", logDir='" + this.logDir + '\'' + ", logFileName='" + this.logFileName + '\'' + ", logLimit=" + this.logLimit + ", logFileCount=" + this.logFileCount + ", level=" + this.level + ", logPattern='" + this.logPattern + '\'' + ", logFileNamePattern='" + this.logFileNamePattern + '\'' + ", isRootLogger=" + this.isRootLogger + '}';
    }
}

