/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memory.calc;

import com.manageengine.apminsight.agent.JavaAgent;
import java.lang.ref.PhantomReference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class CalculatorUtil {
    public static final int STRING_SIZE = 64;
    public static final int NUMBER_SIZE = 24;
    public static final int BOOLEAN_SIZE = 24;
    public static final int MAP_ENTRY_SIZE = 48;
    public static final int ATOMIC_REFERENCE_SIZE = 24;
    public static final String COLLECTION = "collection";
    public static final String MAP = "map";
    public static final String OTHERS = "others";
    public static Boolean isDebugEnabled = Boolean.FALSE;
    public static final String UTIL_PACKAGE = "java.util";
    public static final String UTIL_CONCURRENT_PACKAGE = "java.util.concurrent";
    public static final String UTIL_ATOMIC_PACKAGE = "java.util.concurrent.atomic";
    public static final String UTIL_LOCKS_PACKAGE = "java.util.concurrent.locks";
    protected static final String[] CLASS_NAME_PATTERN_IN = new String[]{Object.class.getName()};
    protected static String[] EXCLUDED_PACKAGE_ARR = new String[]{"sun.", "com.sun.", "java.", "javax.", "com.bea.", "org.jboss.", "weblogic.", "com.ibm.", "com.oracle.", "com.mysql.", "com.tibco", "activemq.", "ibm.mq.", "fiorano", "oracle.", "com.opensymphony", "progress.", "com.evermind", "kodo.", "com.microsoft", "com.pointbase.", "jrockit.", "org."};
    protected static final String[] PACKAGE_NAME_PATTERNS_IN = new String[]{"java.util", "java.util.concurrent", "java.util.concurrent.atomic", "java.util.concurrent.locks"};
    protected static final String[] PACKAGE_NAME_STARTS = new String[]{"org.apache.commons.collections."};
    protected static final Class[] CLASS_NAMES_IN = new Class[]{String.class, Number.class, Boolean.class, ConcurrentHashMap.class, Map.class, Collection.class, AtomicBoolean.class, StringBuilder.class, StringBuffer.class, AtomicReference.class, WeakReference.class, SoftReference.class, PhantomReference.class, StackTraceElement.class, Throwable.class};
    private static Set<String> unSupportedSizeMethodClasses = new HashSet<String>();
    protected static Pattern EXCLUDED_PACKAGE_PATTERN;

    public static Pattern compilePattern(Set<String> packagePrefixes) {
        StringBuilder regularExp = new StringBuilder();
        for (String s : packagePrefixes) {
            regularExp.append("|");
            regularExp.append("((\\[)*L?" + Pattern.quote(s) + "(.)*)");
        }
        return Pattern.compile(regularExp.toString());
    }

    public static boolean unSupportedSizeMethodClasses(String candidateClassName) {
        return unSupportedSizeMethodClasses.contains(candidateClassName);
    }

    public static int getCollectionSize(Collection collection) {
        return CalculatorUtil.calculateShallowSize(COLLECTION, collection);
    }

    public static int getMapSize(Map map) {
        return CalculatorUtil.calculateShallowSize(MAP, map);
    }

    private static int calculateShallowSize(String objectType, Object obj) {
        int size = -1;
        if (unSupportedSizeMethodClasses.contains(obj.getClass().getName())) {
            return size;
        }
        try {
            if (COLLECTION.equals(objectType)) {
                size = ((Collection)obj).size();
            } else if (MAP.equals(objectType)) {
                size = ((Map)obj).size();
            } else {
                JavaAgent.logger.warn("Un identified object type while calculating calculateShallowSize  [" + obj.getClass().getName() + "] : ");
            }
        }
        catch (Exception e) {
            unSupportedSizeMethodClasses.add(obj.getClass().getName());
            JavaAgent.logger.fatal("Exception occured in calculateShallowSize for object [" + obj.getClass().getName() + "] : ", e);
        }
        return size;
    }

    public static String formatInput(long tobeFormatted) {
        if (tobeFormatted < 1000L) {
            return Long.toString(tobeFormatted);
        }
        StringBuilder strBuilder = new StringBuilder(Long.toString(tobeFormatted)).reverse();
        StringBuilder strResult = new StringBuilder(strBuilder.length() + 3);
        char[] charArr = strBuilder.toString().toCharArray();
        for (int i = 0; i < charArr.length; ++i) {
            char singleChar = charArr[i];
            boolean isSeparated = i != 0 && i % 3 == 0;
            if (isSeparated) {
                strResult.append(',');
            }
            strResult.append(singleChar);
        }
        return strResult.reverse().toString();
    }

    static {
        HashSet<String> set = new HashSet<String>(Arrays.asList(EXCLUDED_PACKAGE_ARR));
        EXCLUDED_PACKAGE_PATTERN = CalculatorUtil.compilePattern(set);
    }
}

