/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memory.calc;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memory.calc.CalculatorUtil;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class ClassPackagePatterns {
    private static ConcurrentMap<Class, Boolean> removedClasses = new ConcurrentHashMap<Class, Boolean>();
    private static ConcurrentMap<Class, Boolean> selectedClasses = new ConcurrentHashMap<Class, Boolean>();
    private Set<String> manualIncludes = Collections.emptySet();
    private Set<String> manualExcludes = Collections.emptySet();
    private AtomicReference<Set<String>> manualExcludesReference = new AtomicReference<Set<String>>(this.manualExcludes);
    private AtomicReference<Set<String>> manualIncludesReference = new AtomicReference<Set<String>>(this.manualIncludes);
    private static Boolean dummy = Boolean.TRUE;

    public void setManualExcludes(Set<String> set) {
        this.manualExcludesReference.set(set);
    }

    public void setManualIncludes(Set<String> set) {
        this.manualIncludesReference.set(set);
    }

    public static String getPackageName(String className) {
        int inx = className.lastIndexOf(46);
        if (inx != -1) {
            return className.substring(0, inx);
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean includeClass(Class cls) {
        boolean result = false;
        String className = cls.getName();
        String pkgName = ClassPackagePatterns.getPackageName(className);
        if (selectedClasses.containsKey(cls)) {
            return true;
        }
        if (removedClasses.containsKey(cls)) {
            return false;
        }
        try {
            for (Class clazz : CalculatorUtil.CLASS_NAMES_IN) {
                if (!clazz.isAssignableFrom(cls)) continue;
                boolean bl = result = true;
                return bl;
            }
            for (String string : CalculatorUtil.CLASS_NAME_PATTERN_IN) {
                if (!string.equals(className)) continue;
                boolean bl = result = true;
                return bl;
            }
            for (String string : CalculatorUtil.PACKAGE_NAME_PATTERNS_IN) {
                if (!string.equals(pkgName)) continue;
                boolean bl = result = true;
                return bl;
            }
            for (String string : CalculatorUtil.PACKAGE_NAME_STARTS) {
                if (!pkgName.startsWith(string)) continue;
                boolean bl = result = true;
                return bl;
            }
            Set<String> manualIncludes = this.manualIncludesReference.get();
            if (manualIncludes.size() > 0) {
                for (String manualInclude : manualIncludes) {
                    if (!className.startsWith(manualInclude)) continue;
                    boolean bl = result = true;
                    return bl;
                }
            }
            if (CalculatorUtil.EXCLUDED_PACKAGE_PATTERN.matcher(className).matches()) {
                boolean localIterator = result = false;
                return localIterator;
            }
            Set<String> manualExcludes = this.manualExcludesReference.get();
            for (String string : manualExcludes) {
                if (!className.startsWith(string)) continue;
                boolean bl = result = false;
                return bl;
            }
            boolean bl = result = true;
            return bl;
        }
        finally {
            if (result) {
                if (selectedClasses.putIfAbsent(cls, dummy) == null) {
                    JavaAgent.logger.info("This class has been included for object size calculation " + cls);
                }
            } else if (removedClasses.putIfAbsent(cls, dummy) == null) {
                JavaAgent.logger.info("This class has been exlucded for object size calculation:" + cls);
            }
        }
    }
}

