/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memory.calc;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memory.calc.KeyValueEntryFields;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class EntryFields {
    private static final String HASHTABLE_ENTRY = "java.util.Hashtable$Entry";
    private static final String HASHMAP_ENTRY = "java.util.HashMap$Entry";
    private static final String HASHMAP_NODE = "java.util.HashMap$Node";
    private static final String CONCURRENT_HASHMAP_ENTRY = "java.util.concurrent.ConcurrentHashMap$HashEntry";
    private static final String CONCURRENT_HASHMAP_SEGMENT = "java.util.concurrent.ConcurrentHashMap$Segment";
    private static final String CONCURRENT_HASHMAP_NODE = "java.util.concurrent.ConcurrentHashMap$Node";
    private static final String REENTRANT_LOCK_SYNC = "java.util.concurrent.locks.ReentrantLock$Sync";
    private static final String REENTRANT_LOCK_NFSYNC = "java.util.concurrent.locks.ReentrantLock$NonfairSync";
    private static final String REENTRANT_LOCK_FSYNC = "java.util.concurrent.locks.ReentrantLock$FairSync";
    private Class entryClass;
    KeyValueEntryFields entryfields;

    public EntryFields(Class clazz) {
        this(clazz, false);
    }

    public EntryFields(Class clazz, Boolean flag) {
        if (clazz.getName().equals(ConcurrentHashMap.class.getName())) {
            this.findConcurrentMapFields(clazz.getDeclaredFields(), flag);
        } else if (clazz.getName().equals(ReentrantLock.class.getName())) {
            this.findReentrantFields(flag);
        } else {
            this.findFields(clazz.getDeclaredFields());
        }
    }

    private void findReentrantFields(Boolean isLock) {
        try {
            Field[] fields;
            for (Field fld : fields = ReentrantLock.class.getDeclaredFields()) {
                fld.setAccessible(true);
                if (!fld.getType().getName().equals(REENTRANT_LOCK_SYNC)) continue;
                Object reEntrantObj = null;
                if (isLock.booleanValue()) {
                    reEntrantObj = fld.get(new ReentrantLock(true));
                    if (!reEntrantObj.getClass().getName().equals(REENTRANT_LOCK_FSYNC)) continue;
                    this.entryClass = reEntrantObj.getClass();
                    continue;
                }
                reEntrantObj = fld.get(new ReentrantLock(false));
                if (!reEntrantObj.getClass().getName().equals(REENTRANT_LOCK_NFSYNC)) continue;
                this.entryClass = reEntrantObj.getClass();
            }
        }
        catch (Exception e) {
            JavaAgent.logger.fatal(" Exception occurred in  findReentrantFields , EntryFields : ", e);
        }
    }

    private void findFields(Field[] fields) {
        try {
            for (Field fld : fields) {
                fld.setAccessible(true);
                Class<?> classType = fld.getType();
                if (!classType.isArray()) continue;
                String innerClassObjName = classType.getComponentType().getName();
                Field[] resultantFields = null;
                if (!innerClassObjName.equals(HASHTABLE_ENTRY) && !innerClassObjName.equals(HASHMAP_ENTRY) && !innerClassObjName.equals(HASHMAP_NODE)) continue;
                this.entryClass = classType.getComponentType();
                this.entryfields = new KeyValueEntryFields();
                Field[] sfields = this.entryClass.getSuperclass().getDeclaredFields();
                Field[] cfields = this.entryClass.getDeclaredFields();
                resultantFields = new Field[sfields.length + cfields.length];
                System.arraycopy(sfields, 0, resultantFields, 0, sfields.length);
                System.arraycopy(cfields, 0, resultantFields, sfields.length, cfields.length);
                this.populateWrapperFields(resultantFields);
                break;
            }
        }
        catch (Exception e) {
            JavaAgent.logger.fatal(" Exception occurred in  findFields , EntryFields : ", e);
        }
    }

    private void findConcurrentMapFields(Field[] fields, Boolean isSegment) {
        try {
            for (Field fld : fields) {
                fld.setAccessible(true);
                Class<?> classType = fld.getType();
                if (!classType.isArray()) continue;
                String innerClassObjName = classType.getComponentType().getName();
                Field[] resultantFields = null;
                if (!isSegment.booleanValue() && (innerClassObjName.equals(CONCURRENT_HASHMAP_ENTRY) || innerClassObjName.equals(CONCURRENT_HASHMAP_NODE))) {
                    this.entryClass = classType.getComponentType();
                    this.entryfields = new KeyValueEntryFields();
                    resultantFields = this.entryClass.getDeclaredFields();
                    this.populateWrapperFields(resultantFields);
                    break;
                }
                if (!isSegment.booleanValue() || !innerClassObjName.equals(CONCURRENT_HASHMAP_SEGMENT)) continue;
                this.entryClass = classType.getComponentType();
                this.findConcurrentMapFields(this.entryClass.getDeclaredFields(), false);
            }
        }
        catch (Exception e) {
            JavaAgent.logger.fatal(" Exception occurred in  findConcurrentMapFields , EntryFields : ", e);
        }
    }

    void populateWrapperFields(Field[] resultantFields) {
        for (Field entryFld : resultantFields) {
            entryFld.setAccessible(true);
            if (entryFld.getName().equals("key")) {
                this.entryfields.setKey(entryFld);
                continue;
            }
            if (entryFld.getName().equals("value")) {
                this.entryfields.setValue(entryFld);
                continue;
            }
            if (!entryFld.getName().equals("next")) continue;
            this.entryfields.setEntry(entryFld);
        }
    }

    public Class getEntryClass() {
        return this.entryClass;
    }

    public KeyValueEntryFields getEntryFields() {
        return this.entryfields;
    }
}

