/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memory.calc;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memory.calc.CalculatorUtil;
import com.manageengine.apminsight.agent.memory.calc.ClassPackagePatterns;
import com.manageengine.apminsight.agent.memory.calc.ComponentWrapper;
import com.manageengine.apminsight.agent.memory.calc.FieldHolder;
import com.manageengine.apminsight.agent.memory.calc.KeyValueEntryFields;
import com.manageengine.apminsight.agent.memory.calc.ObjectPersistence;
import com.manageengine.apminsight.agent.memory.calc.ReservedFields;
import com.manageengine.apminsight.agent.memoryleaks.config.MemoryLeaksEvents;
import com.manageengine.apminsight.agent.memoryleaks.monitor.Histogram;
import java.lang.instrument.Instrumentation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class MemoryCalculator {
    private Instrumentation instrumentObj;
    private boolean logDebug = Boolean.FALSE;
    private int queueSize = 1000000;
    private int objectMaxLimit = 1000000;
    private Object rootObj;
    private String name;
    private int id;
    private long objectUUID = -1L;
    private boolean isDumpNeeded = false;
    private boolean isObjectSummaryNeeded = false;
    private ObjectPersistence pers;
    private String prevObjectPersistanceFileName;
    private MemoryLeaksEvents eventsSender;
    private boolean isOptimizationSet = false;
    private static final Boolean DUMMY_BOOL = Boolean.TRUE;
    private String rootClassName;
    private long totalSize;
    private Queue<Object> objectQueue;
    private Map<Object, Boolean> visited;
    private Map<String, AtomicInteger> objectMapCounter;
    private Map<String, AtomicLong> objectWeightMap;
    private StringBuilder debugData;
    private boolean isTraceLogEnabled;
    private ReservedFields reservedFields;
    private ClassPackagePatterns clazzPatterns;
    private StringBuilder errorInfo;
    private boolean isQueueLimitReached;
    private int objectLimitCount;
    private List errorParams = new ArrayList();

    public MemoryCalculator(Instrumentation instrumentObj) {
        this.instrumentObj = instrumentObj;
        this.pers = new ObjectPersistence();
        this.eventsSender = MemoryLeaksEvents.getInstance();
        this.init();
    }

    public void init() {
        this.clazzPatterns = new ClassPackagePatterns();
        this.reservedFields = new ReservedFields(this.clazzPatterns);
        this.visited = new IdentityHashMap<Object, Boolean>(5120);
        this.objectMapCounter = new HashMap<String, AtomicInteger>();
        this.objectWeightMap = new HashMap<String, AtomicLong>();
        this.errorInfo = new StringBuilder();
        this.objectQueue = new LinkedList<Object>();
        this.debugData = new StringBuilder(256);
    }

    public void setMaxElementsInQueue(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setManualExcludes(Set<String> manualExcludes) {
        this.reservedFields.setManualExcludes(manualExcludes);
    }

    public void setManualIncludes(Set<String> manualIncludes) {
        this.reservedFields.setManualIncludes(manualIncludes);
    }

    public void setOptimization(boolean isOptimizationSet) {
        this.isOptimizationSet = isOptimizationSet;
    }

    public long objectDeepSize(Object rootObj) {
        long resultSize = -1L;
        try {
            this.logDebug = false;
            this.rootObj = rootObj;
            this.name = rootObj.getClass().getName();
            this.id = System.identityHashCode(rootObj);
            resultSize = this.computeSize();
        }
        catch (Exception ex) {
            JavaAgent.logger.fatal("Exception occured in computing object's size for " + rootObj.getClass() + ", negative object size will be returned", ex);
        }
        return resultSize;
    }

    protected final long computeSize() {
        return this.computeAndGetSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long computeAndGetSize() {
        if (this.rootObj == null) {
            return 0L;
        }
        this.isTraceLogEnabled = false;
        this.cleanAtStart();
        this.totalSize = 0L;
        this.rootClassName = this.rootObj.getClass().getName();
        int maxQueue = 0;
        long startTime = System.currentTimeMillis();
        try {
            Class<?> compType = this.rootObj.getClass().getComponentType();
            if (compType != null && !compType.isPrimitive()) {
                this.addtoQueue(new ComponentWrapper(this.rootObj));
                if (this.isTraceLogEnabled) {
                    JavaAgent.logger.info("adding component" + compType.getSimpleName() + "[]\n");
                }
            } else {
                this.addObjectToQueue(this.rootObj);
            }
            ArrayDeque queue = new ArrayDeque();
            if (this.isDumpNeeded) {
                this.pers.createFile(this.id, this.rootClassName);
            }
            while (!this.objectQueue.isEmpty()) {
                if (this.visited.size() > this.objectMaxLimit && this.objectMaxLimit != -1) {
                    this.errorInfo.append("apminsight.memoryleaks.object.calculation.max.limit");
                    this.errorParams.add(this.objectMaxLimit);
                    this.errorParams.add(CalculatorUtil.formatInput(this.totalSize));
                    this.errorParams.add(System.currentTimeMillis() - startTime);
                    break;
                }
                Object obj = this.objectQueue.poll();
                if (this.objectQueue.size() > this.queueSize && this.queueSize != -1) {
                    this.isQueueLimitReached = true;
                    JavaAgent.logger.info("Maximum Queue size limit reached for " + this.queueSize + " with name " + this.getName() + ", skipping the object name " + obj.getClass().getName());
                    continue;
                }
                boolean isArray = false;
                if (obj instanceof ComponentWrapper) {
                    obj = ((ComponentWrapper)obj).object;
                    isArray = true;
                }
                Class<?> cls = obj.getClass();
                if (!this.reservedFields.isFilteredClass(obj.getClass()) && this.visited.put(obj, DUMMY_BOOL) != null) continue;
                long size = this.instrumentObj.getObjectSize(obj);
                this.addToSize(size, obj.getClass());
                if (this.isDumpNeeded) {
                    this.pers.printElements(obj, 0, this.reservedFields);
                }
                if (isArray) {
                    Object[] leafArray = (Object[])obj;
                    this.sizeOrAddToQueue(leafArray);
                    if (!this.logDebug || this.objectQueue.size() <= maxQueue) continue;
                    maxQueue = this.objectQueue.size();
                    continue;
                }
                FieldHolder[] fields = this.reservedFields.fetchFields(cls);
                for (int i = fields.length - 1; i >= 0; --i) {
                    FieldHolder wrapper = fields[i];
                    try {
                        Object val = wrapper.field.get(obj);
                        if (val == null) continue;
                        if (wrapper.isOnlyObjectArray) {
                            this.addtoQueue(new ComponentWrapper(val));
                            if (!this.isTraceLogEnabled) continue;
                            JavaAgent.logger.info("Adding " + wrapper.field + "[]\n");
                            continue;
                        }
                        this.addObjectToQueue(val);
                        if (!this.logDebug || this.objectQueue.size() <= maxQueue) continue;
                        maxQueue = this.objectQueue.size();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        JavaAgent.logger.fatal("Exception occured while fetching the value for wrapper" + wrapper);
                    }
                }
            }
            if (this.isQueueLimitReached) {
                ArrayList<Integer> params = new ArrayList<Integer>();
                params.add(this.queueSize);
                params.add(this.objectLimitCount);
                this.eventsSender.addUiEvent(0L, "apminsight.memoryleaks.object.queue.max", params);
            }
            if (this.errorInfo.length() > 0) {
                JavaAgent.logger.info("For " + this.getName() + " the error info is : " + this.errorInfo.toString());
            }
        }
        finally {
            if (this.isDumpNeeded && this.pers.writerObj != null) {
                this.prevObjectPersistanceFileName = this.pers.getFileName();
                this.pers.writeToFile();
                this.pers.closeIOStreams();
            }
            if (this.logDebug) {
                this.logDebug(maxQueue, startTime);
            }
            this.cleanAtEnd();
        }
        return this.totalSize;
    }

    private void cleanAtStart() {
        this.objectMapCounter.clear();
        this.objectWeightMap.clear();
        this.errorInfo.setLength(0);
        this.objectLimitCount = 0;
        this.isQueueLimitReached = false;
        this.errorParams = new ArrayList();
    }

    private void cleanAtEnd() {
        this.visited.clear();
        this.objectQueue.clear();
        this.debugData.setLength(0);
    }

    private void logDebug(int queueSize, long start) {
        this.debugData.append("--The [").append(this.rootClassName).append("], timetaken [").append(System.currentTimeMillis() - start).append("], and size in bytes are [").append(this.totalSize);
        this.debugData.append("], number of visited elements [").append(this.visited.size()).append("], queue size maximum[").append(queueSize).append("]  -- \n");
    }

    private void addToClassSizeCounter(long sz, Class cls, int counter) {
        String clazzName = this.getClassName(cls);
        AtomicLong size = this.objectWeightMap.get(clazzName);
        if (size == null) {
            size = new AtomicLong(0L);
            this.objectWeightMap.put(clazzName, size);
        }
        size.addAndGet(sz);
        AtomicInteger count = this.objectMapCounter.get(clazzName);
        if (count == null) {
            count = new AtomicInteger(0);
            this.objectMapCounter.put(clazzName, count);
        }
        count.addAndGet(counter);
    }

    private void addToSize(long sz, Class cls) {
        this.addToSizeCounter(sz, cls, 1);
    }

    private void addToSizeCounter(long sz, Class cls, int counter) {
        this.totalSize += sz;
        if (this.isObjectSummaryNeeded) {
            this.addToClassSizeCounter(sz, cls, counter);
        }
    }

    private String getClassName(Class cls) {
        if (cls.getComponentType() != null) {
            return cls.getComponentType().getName() + "[]";
        }
        return cls.getName();
    }

    private void defaultComponentType(Object[] componentArr, Class type) {
        int endIndex = 0;
        endIndex = this.calculateEndIndex(componentArr.length);
        for (int j = componentArr.length - 1; j >= endIndex; --j) {
            Object val = componentArr[j];
            if (val == null) continue;
            Class<?> clazz = val.getClass();
            if (clazz == String.class) {
                long size = 64 + ((String)val).length() * 2;
                this.addToSize(size, String.class);
                continue;
            }
            if (clazz == Boolean.class) {
                this.addToSize(24L, clazz);
                continue;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                this.addToSize(24L, clazz);
                continue;
            }
            if (clazz.isArray()) {
                if (!clazz.getComponentType().isPrimitive()) {
                    this.addtoQueue(new ComponentWrapper(val));
                    continue;
                }
                this.addToSize(this.instrumentObj.getObjectSize(val), clazz);
                continue;
            }
            this.addtoQueue(val);
        }
        if (endIndex > 0) {
            JavaAgent.logger.info("Componet added,  queue size is  " + this.objectQueue.size());
        }
    }

    private void addObjectToQueue(Object val) {
        if (this.isOptimizationSet) {
            this.addtoQueue(val);
            return;
        }
        if (val instanceof String) {
            long size = 64 + ((String)val).length() * 2;
            this.addToSize(size, String.class);
        } else if (val instanceof Number) {
            this.addToSize(24L, val.getClass());
        } else if (val instanceof AtomicReference) {
            this.addToSize(24L, val.getClass());
            Object obj = ((AtomicReference)val).get();
            if (obj != null) {
                this.addtoQueue(obj);
            }
        } else {
            this.addtoQueue(val);
        }
    }

    private void incrementComponentObj(Object[] arr, Class type, int size) {
        for (int j = arr.length - 1; j >= 0; --j) {
            Object val = arr[j];
            if (val == null) continue;
            this.addToSize(size, type);
        }
    }

    private String getName() {
        StringBuilder sb = new StringBuilder(this.rootClassName + ", name " + this.name + ", id " + this.id);
        return sb.toString();
    }

    private int calculateEndIndex(int len) {
        int endIndex = 0;
        if (this.queueSize != -1) {
            int n = endIndex = this.objectQueue.size() + len > this.queueSize ? len - 1 - (this.queueSize - this.objectQueue.size()) : 0;
            if (endIndex > 0) {
                JavaAgent.logger.info("Maximum queue size is reached for object name[" + this.getName() + "]  the queue size is " + this.queueSize + " in the array.object size " + this.objectQueue.size() + ", array length " + len + ", end Index " + endIndex + ", stats are " + (len - 1 - endIndex));
                this.isQueueLimitReached = true;
                this.objectLimitCount += endIndex;
            }
        }
        return endIndex;
    }

    private void analyzeEntryElements(Object[] arr, KeyValueEntryFields flds) {
        int endIndex = 0;
        endIndex = this.calculateEndIndex(arr.length);
        for (int j = arr.length - 1; j >= endIndex; --j) {
            Object entry = arr[j];
            if (entry == null) continue;
            try {
                this.sizeOrAddEntryElement(flds, entry);
                continue;
            }
            catch (IllegalAccessException e) {
                JavaAgent.logger.fatal("Exception occured while fetching the Map-Entry data " + entry);
            }
        }
    }

    private void addtoQueue(Object obj) {
        if (this.clazzPatterns.includeClass(obj.getClass())) {
            if (this.objectQueue.size() <= this.queueSize && this.queueSize != -1) {
                this.objectQueue.add(obj);
                if (this.isTraceLogEnabled) {
                    JavaAgent.logger.info("Pushing " + obj.getClass().getSimpleName() + "\n");
                }
            } else {
                this.isQueueLimitReached = true;
                ++this.objectLimitCount;
            }
        }
    }

    private void sizeOrAddEntryElement(KeyValueEntryFields fieldWrapper, Object entry) throws IllegalAccessException {
        Object obj;
        this.addToSize(48L, entry.getClass());
        if (fieldWrapper.getKey() != null && (obj = fieldWrapper.getKey().get(entry)) != null) {
            this.addObjectToQueue(obj);
        }
        if (fieldWrapper.getValue() != null && (obj = fieldWrapper.getValue().get(entry)) != null) {
            this.addObjectToQueue(obj);
        }
        if (fieldWrapper.getEntry() != null && (obj = fieldWrapper.getEntry().get(entry)) != null) {
            this.addtoQueue(obj);
        }
    }

    private void sizeOrAddToQueue(Object[] arr) {
        Class<?> type = arr.getClass().getComponentType();
        if (this.isOptimizationSet) {
            this.defaultComponentType(arr, type);
            return;
        }
        if (type == ReservedFields.mapEntry) {
            this.analyzeEntryElements(arr, ReservedFields.mapFields);
        } else if (type == ReservedFields.tableEntry) {
            this.analyzeEntryElements(arr, ReservedFields.tableFields);
        } else if (type == ReservedFields.concurrentEntry) {
            this.analyzeEntryElements(arr, ReservedFields.concurrentFields);
        } else if (type == String.class) {
            for (int j = arr.length - 1; j >= 0; --j) {
                Object val = arr[j];
                if (val == null) continue;
                long size = 64 + ((String)val).length() * 2;
                this.addToSize(size, String.class);
            }
        } else if (type == Boolean.class) {
            this.incrementComponentObj(arr, type, 24);
        } else if (Number.class.isAssignableFrom(type)) {
            this.incrementComponentObj(arr, type, 24);
        } else {
            this.defaultComponentType(arr, type);
        }
    }

    public Histogram constructAndGetHistogram() {
        Histogram histogram = new Histogram(this.id, this.name, this.rootObj.getClass().getName(), this.totalSize, new HashMap<String, AtomicInteger>(this.objectMapCounter), new HashMap<String, AtomicLong>(this.objectWeightMap), this.errorInfo.toString(), this.errorParams);
        histogram.setObjectUUID(this.objectUUID);
        this.cleanAtStart();
        return histogram;
    }

    public Histogram objectSummaryData() {
        Histogram summaryHisto = null;
        if (this.isObjectSummaryNeeded) {
            summaryHisto = new Histogram(this.id, this.name, this.rootObj.getClass().getName(), this.totalSize, this.objectMapCounter, this.objectWeightMap, this.errorInfo.toString(), this.errorParams);
            summaryHisto.setObjectUUID(this.objectUUID);
        }
        return summaryHisto;
    }

    public void setIsDumpEnabled(Boolean enabled) {
        this.isDumpNeeded = enabled;
    }

    public boolean isDumpEnabled() {
        return this.isDumpNeeded;
    }

    public void setIsSummaryEnabled(Boolean enabled) {
        this.isObjectSummaryNeeded = enabled;
    }

    public String getPrevObjectPersistanceFileName() {
        return this.prevObjectPersistanceFileName;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void setObjectUUID(long objectUUID) {
        this.objectUUID = objectUUID;
    }
}

