/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memory.calc;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memory.calc.ComponentWrapper;
import com.manageengine.apminsight.agent.memory.calc.FieldHolder;
import com.manageengine.apminsight.agent.memory.calc.ReservedFields;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;

public class ObjectPersistence {
    private String filePath;
    public PrintStream writerObj;
    private StringBuilder str = new StringBuilder();
    private String fileName = null;
    private final int incrementValue = 3;

    public ObjectPersistence() {
        this.init();
    }

    public void init() {
        this.filePath = System.getProperty("user.home");
    }

    public void writeToFile() {
        this.writerObj.print(this.str.toString());
        this.clear();
    }

    public void clear() {
        this.str = new StringBuilder();
        this.fileName = null;
    }

    public void closeIOStreams() {
        if (this.writerObj != null) {
            this.writerObj.flush();
            this.writerObj.close();
            this.writerObj = null;
        }
    }

    public void createFile(int hashCode, String clazzName) {
        try {
            this.fileName = this.filePath + "/MemoryLeak_" + clazzName + "_" + hashCode + "_" + System.currentTimeMillis() + ".txt";
            this.writerObj = new PrintStream(new File(this.fileName));
        }
        catch (Exception e) {
            JavaAgent.logger.fatal("Exception while creating file for memory leak");
        }
    }

    public void printElements(Object obj, int spaces, ReservedFields reservedFields) {
        try {
            if (obj != null) {
                if (obj instanceof ComponentWrapper) {
                    obj = ((ComponentWrapper)obj).object;
                }
                if (Map.class.isAssignableFrom(obj.getClass())) {
                    this.indentation(spaces);
                    this.str.append("Object : [" + obj.hashCode() + "] " + obj.getClass().getName());
                    this.printMapData(obj, spaces + this.incrementValue);
                } else if (obj.getClass().isPrimitive()) {
                    this.indentation(spaces);
                    this.str.append("Object : [ " + obj.hashCode() + " ]  ( " + obj.getClass().getName() + "  )");
                } else if (obj.getClass().isArray()) {
                    this.indentation(spaces);
                    this.str.append("Array : [" + obj.hashCode() + "]  ( " + obj.getClass().getSimpleName() + "  )");
                    this.printArrayElements(obj, spaces + 3);
                } else {
                    Field field;
                    int i;
                    this.indentation(spaces);
                    this.str.append("Object : [" + obj.hashCode() + "] ( " + obj.getClass().getName() + " )");
                    String type = "object";
                    FieldHolder[] objectArray = reservedFields.fetchFields(obj.getClass(), type);
                    type = "primitive";
                    FieldHolder[] primitiveArray = reservedFields.fetchFields(obj.getClass(), type);
                    for (i = 0; i < objectArray.length; ++i) {
                        field = objectArray[i].field;
                        if (field == null) continue;
                        if (Map.class.isAssignableFrom(field.getType())) {
                            this.indentation(spaces + this.incrementValue);
                            this.str.append(field.getName() + " : [" + field.hashCode() + "]  ( " + field.getType().getName() + " )");
                            this.printMapData(field.get(obj), spaces + 2 * this.incrementValue);
                            continue;
                        }
                        if (field.getType().isArray()) {
                            this.indentation(spaces + this.incrementValue);
                            this.str.append(field.getName() + " : [" + field.hashCode() + "]  ( " + field.getType().getSimpleName() + " )");
                            this.printArrayElements(field.get(obj), spaces + 2 * this.incrementValue);
                            continue;
                        }
                        this.indentation(spaces + this.incrementValue);
                        this.str.append(field.getName() + " : [" + field.hashCode() + "]  ( " + field.getType().getName() + " )");
                    }
                    for (i = 0; i < primitiveArray.length; ++i) {
                        field = primitiveArray[i].field;
                        if (!field.isAccessible()) continue;
                        if (field.getType().isArray()) {
                            this.indentation(spaces + this.incrementValue);
                            this.str.append(field.getName() + " : [" + field.hashCode() + "]  ( " + field.getType().getSimpleName() + " )");
                            this.printArrayElements(field.get(obj), spaces + 2 * this.incrementValue);
                            continue;
                        }
                        this.indentation(spaces + this.incrementValue);
                        this.str.append(field.getName() + " : " + field.get(obj) + "  ( " + field.getType() + " )");
                    }
                }
            }
            this.str.append("\n");
        }
        catch (Exception e) {
            JavaAgent.logger.fatal("Exception while iterating the object");
        }
    }

    public void indentation(int spaces) {
        this.str.append("\n");
        for (int i = 0; i < spaces; ++i) {
            this.str.append(" ");
        }
    }

    public void printMapData(Object obj, int spaces) {
        Map rawMap = (Map)obj;
        Set entries = rawMap.entrySet();
        for (Map.Entry me : entries) {
            this.indentation(spaces);
            this.str.append("key : " + me.getKey() + " : " + me.getKey().getClass().getName());
            this.indentation(spaces);
            this.str.append("value : " + me.getValue() + " : " + me.getValue().getClass().getName());
        }
    }

    public void printArrayElements(Object obj, int spaces) {
        int length = Array.getLength(obj);
        for (int j = 0; j < length; ++j) {
            if (Array.get(obj, j) == null) continue;
            this.indentation(spaces);
            if (Array.get(obj, j).getClass().isPrimitive()) {
                this.str.append(Array.get(obj, j).getClass().getName() + " : " + Array.get(obj, j));
                continue;
            }
            this.str.append("Object : [" + Array.get(obj, j).hashCode() + "]  ( " + Array.get(obj, j).getClass().getName() + "  )");
        }
    }

    public String getFileName() {
        return this.fileName;
    }
}

