/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.actions;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.org.json.simple.JSONArray;
import com.manageengine.org.json.simple.JSONObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class TraceDetails {
    private long initTime;
    private long objectUUID = -1L;
    private int captureTimeInMillis;
    private boolean finish = false;
    private Map<String, AtomicInteger> traceData = new ConcurrentHashMap<String, AtomicInteger>();
    private Map<String, AtomicInteger> transactionNameMapper = new ConcurrentHashMap<String, AtomicInteger>();

    public TraceDetails(long objectUUID, long startTime, int captureTimeInMillis) {
        this.objectUUID = objectUUID;
        this.initTime = startTime;
        this.captureTimeInMillis = captureTimeInMillis;
    }

    public JSONArray getTraceDataJson() {
        JSONArray traceArray = new JSONArray();
        for (String codepath : this.traceData.keySet()) {
            JSONObject traceObj = new JSONObject();
            traceObj.put("trace_data", codepath);
            traceObj.put("trace_count", this.traceData.get(codepath));
            traceArray.add(traceObj);
        }
        return traceArray;
    }

    public JSONArray getTransactionNameJson() {
        JSONArray nameArray = new JSONArray();
        for (String codepath : this.traceData.keySet()) {
            JSONObject traceObj = new JSONObject();
            traceObj.put("transaction_name", codepath);
            traceObj.put("transaction_name", this.traceData.get(codepath));
            nameArray.add(traceObj);
        }
        return nameArray;
    }

    public void traceDataAppender(String traceStr) {
        AtomicInteger tracePaths = this.traceData.get(traceStr);
        if (tracePaths != null) {
            tracePaths.getAndIncrement();
        } else if (16 > this.traceData.size()) {
            tracePaths = this.traceData.get(traceStr);
            if (tracePaths == null) {
                tracePaths = new AtomicInteger(0);
            }
            this.traceData.put(traceStr, tracePaths);
            tracePaths.getAndIncrement();
        }
        if (this.traceData.size() >= 16) {
            this.finish = true;
            JavaAgent.logger.info("Maximum traces collected for the same trace for object uuid : " + this.objectUUID);
        }
    }

    public void transactionNameAppender(String transactionName) {
        AtomicInteger nameCounter = this.transactionNameMapper.get(transactionName);
        if (nameCounter == null) {
            nameCounter = new AtomicInteger(0);
            this.transactionNameMapper.put(transactionName, nameCounter);
        }
        nameCounter.incrementAndGet();
    }

    public boolean isFinish() {
        return this.finish;
    }

    public Map<String, AtomicInteger> getTraceData() {
        return this.traceData;
    }

    public Map<String, AtomicInteger> getTransactionNameMapper() {
        return this.transactionNameMapper;
    }

    public int getCaptureTimeInMillis() {
        return this.captureTimeInMillis;
    }

    public long getInitTime() {
        return this.initTime;
    }
}

