/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.actions;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memoryleaks.actions.ObjectTraceHandler;
import com.manageengine.apminsight.agent.memoryleaks.actions.TraceDetails;
import com.manageengine.apminsight.agent.memoryleaks.config.ActionHandler;
import com.manageengine.apminsight.agent.memoryleaks.config.AutomaticLeakDetection;
import com.manageengine.apminsight.agent.memoryleaks.config.MemoryAnalyzer;
import com.manageengine.apminsight.agent.memoryleaks.config.MemoryLeaksEvents;
import com.manageengine.apminsight.agent.memoryleaks.monitor.Histogram;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectDetails;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectMonitor;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.SchedulerManager;
import com.manageengine.org.json.simple.JSONArray;
import com.manageengine.org.json.simple.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TraceObjectData {
    private static final String TAB_WITH_AT = "\t  at ";
    private static final String NEW_LINE_CHAR = "\n";
    private volatile boolean enabled = false;
    private Map<ActionHandler, TraceDetails> activeTransactionalTraces = new ConcurrentHashMap<ActionHandler, TraceDetails>();
    private Map<String, HashSet<Long>> instrumentedClassVsObjectId = new ConcurrentHashMap<String, HashSet<Long>>();
    private Map<Long, ActionHandler> activeTransactionalTraceMapper = new ConcurrentHashMap<Long, ActionHandler>();
    private Set<String> activeInstrumentedClasses = new HashSet<String>();
    private AtomicInteger collectedTraceCounter = new AtomicInteger(0);
    private MemoryLeaksEvents eventsSender;
    ScheduledFuture<?> traceFutureObj = null;
    private ObjectMonitor objMon = null;
    private MemoryAnalyzer memoryAnalyzer = null;
    private static TraceObjectData instance;

    private TraceObjectData() {
    }

    public void init() {
        this.finish();
        this.enabled = true;
        this.eventsSender = MemoryLeaksEvents.getInstance();
        this.traceFutureObj = SchedulerManager.getGlobalScheduler().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                TraceObjectData.this.checkTraceExpiry();
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    public static TraceObjectData getInstance() {
        if (instance == null) {
            instance = new TraceObjectData();
        }
        return instance;
    }

    public void registerTraceSession(Set<ActionHandler> userActionData) {
        if (this.activeTransactionalTraces.size() >= 6) {
            this.sendCancelledEvent(userActionData);
            return;
        }
        ArrayList<String> addClasses = new ArrayList<String>();
        for (ActionHandler actionHandler : userActionData) {
            if (this.objMon == null) {
                this.objMon = ObjectMonitor.getInstance();
            }
            if (this.activeTransactionalTraceMapper.containsKey(actionHandler.getObjectUUID())) {
                if (actionHandler.getUserActionId() > 0L) {
                    ArrayList<String> params = new ArrayList<String>();
                    params.add(actionHandler.getClassName());
                    this.eventsSender.addUiEvent(actionHandler.getObjectUUID(), "apminsight.memoryleaks.trace.active", params);
                }
                JavaAgent.logger.warn("Activity trace session is already active for trace target [" + actionHandler.getObjectUUID() + "]");
                continue;
            }
            if (this.objMon.getObjectDetailsForId(actionHandler.getObjectUUID()) != null && this.objMon.getObjectDetailsForId(actionHandler.getObjectUUID()).getObject() != null) {
                String className = actionHandler.getClassName();
                int captureTimeInMillis = (int)actionHandler.getCaptureDurationInMillis();
                TraceDetails details = new TraceDetails(actionHandler.getObjectUUID(), System.currentTimeMillis(), captureTimeInMillis);
                addClasses.add(className);
                this.activeTransactionalTraces.put(actionHandler, details);
                this.activeTransactionalTraceMapper.put(actionHandler.getObjectUUID(), actionHandler);
                this.activeInstrumentedClasses.add(actionHandler.getClassName());
                ObjectTraceHandler.runningTraceCount.incrementAndGet();
                HashSet<Long> objectIds = new HashSet<Long>();
                if (this.instrumentedClassVsObjectId.containsKey(className)) {
                    objectIds = this.instrumentedClassVsObjectId.get(className);
                }
                objectIds.add(actionHandler.getObjectUUID());
                this.instrumentedClassVsObjectId.put(className, objectIds);
                ArrayList<String> params = new ArrayList<String>();
                params.add(actionHandler.getClassName());
                this.eventsSender.addUiEvent(actionHandler.getObjectUUID(), "apminsight.memoryleaks.trace.start", params);
                JavaAgent.logger.info(actionHandler.getObjectUUID() + " is UUID with capture time in millis: " + Integer.toString((int)actionHandler.getCaptureDurationInMillis()));
                continue;
            }
            this.eventsSender.addUiEvent(actionHandler.getObjectUUID(), "apminsight.memoryleaks.not.available");
            JavaAgent.logger.info("Object with objId:" + actionHandler.getObjectUUID() + " is not Available.");
        }
    }

    private void sendCancelledEvent(Set<ActionHandler> userActionData) {
        for (ActionHandler actionHandler : userActionData) {
            if (actionHandler.getUserActionId() == -1L) continue;
            ArrayList<String> params = new ArrayList<String>();
            params.add(actionHandler.getClassName());
            this.eventsSender.addUiEvent(actionHandler.getObjectUUID(), "apminsight.memoryleaks.trace.max ", params);
        }
    }

    public void captureTransactionalTrace(long id) {
        TraceDetails traceDetails;
        if (this.activeTransactionalTraces.size() == 0) {
            return;
        }
        ActionHandler actionHandler = this.activeTransactionalTraceMapper.get(id);
        if (actionHandler != null && (traceDetails = this.activeTransactionalTraces.get(actionHandler)) != null && this.collectedTraceCounter.get() < 50) {
            this.collectedTraceCounter.incrementAndGet();
            String transactionalTrace = TraceObjectData.captureTrace(ObjectTraceHandler.max_stack_trace_depth);
            if (!transactionalTrace.isEmpty()) {
                traceDetails.traceDataAppender(transactionalTrace);
            }
            this.captureTransactionName(traceDetails);
        }
    }

    public void captureTransactionName(TraceDetails details) {
        String bizTransaction = "getTransaction from agent.";
        if (bizTransaction != null) {
            details.transactionNameAppender(String.valueOf(bizTransaction));
        }
    }

    public static String captureTrace(int depth) {
        StackTraceElement[] stackData;
        int counter = 0;
        boolean flag = false;
        StringBuilder stringBld = new StringBuilder();
        for (StackTraceElement methodCall : stackData = Thread.currentThread().getStackTrace()) {
            String element = methodCall.toString();
            if (element.contains("manageengine.apminsight.agent")) continue;
            if (counter > 0) {
                if (flag) {
                    stringBld.append(TAB_WITH_AT);
                } else {
                    flag = true;
                }
                stringBld.append(element).append(NEW_LINE_CHAR);
            }
            if (++counter > depth) break;
        }
        return stringBld.toString();
    }

    public void checkTraceExpiry() {
        if (!this.enabled) {
            return;
        }
        long currTime = System.currentTimeMillis();
        ArrayList<String> removedClasses = new ArrayList<String>();
        for (ActionHandler actionHandler : this.activeTransactionalTraces.keySet()) {
            TraceDetails details = this.activeTransactionalTraces.get(actionHandler);
            if (!details.isFinish() && currTime <= details.getInitTime() + (long)details.getCaptureTimeInMillis()) continue;
            ObjectTraceHandler.runningTraceCount.decrementAndGet();
            this.activeTransactionalTraces.remove(actionHandler);
            this.activeTransactionalTraceMapper.remove(actionHandler.getObjectUUID());
            this.activeInstrumentedClasses.remove(actionHandler.getClassName());
            HashSet<Object> objectIds = new HashSet();
            if (this.instrumentedClassVsObjectId.containsKey(actionHandler.getClassName())) {
                objectIds = this.instrumentedClassVsObjectId.get(actionHandler.getClassName());
                objectIds.remove(actionHandler.getObjectUUID());
                if (objectIds.isEmpty() || objectIds.size() == 0) {
                    removedClasses.add(actionHandler.getClassName());
                    this.instrumentedClassVsObjectId.remove(actionHandler.getClassName());
                } else {
                    this.instrumentedClassVsObjectId.put(actionHandler.getClassName(), objectIds);
                }
            }
            this.sendTransactionTraceData(actionHandler, details);
            if (actionHandler.getUserActionId() <= 0L) continue;
            ArrayList<String> params = new ArrayList<String>();
            params.add(actionHandler.getClassName());
            this.eventsSender.addUiEvent(actionHandler.getObjectUUID(), "apminsight.memoryleaks.trace.success", params);
        }
        this.collectedTraceCounter.set(0);
    }

    private void sendTransactionTraceData(ActionHandler actionHandler, TraceDetails details) {
        boolean hasCodePaths;
        JSONArray traceJsonObj = new JSONArray();
        traceJsonObj = details.getTraceDataJson();
        if (this.memoryAnalyzer == null) {
            this.memoryAnalyzer = AutomaticLeakDetection.getInstance().getMemoryAnalyzer();
        }
        if (this.objMon == null) {
            this.objMon = ObjectMonitor.getInstance();
        }
        for (int i = 0; i < traceJsonObj.size(); ++i) {
            JSONObject traceDetails = new JSONObject();
            traceDetails.put("id", actionHandler.getObjectUUID());
            traceDetails.put("type", MemoryLeaksEvents.MetricType.TRANSACTION_TRACE.getType());
            ObjectDetails objDetails = this.objMon.getObjectDetailsForId(actionHandler.getObjectUUID());
            traceDetails.put("update_time", System.currentTimeMillis());
            traceDetails.put("elements_count", objDetails.getSize());
            if (this.memoryAnalyzer != null) {
                traceDetails.put("potential_leak", this.memoryAnalyzer.isPotentialLeak(actionHandler.getObjectUUID()));
            } else {
                traceDetails.put("potential_leak", Boolean.FALSE);
            }
            Histogram histogram = objDetails.getHistogram();
            if (histogram != null) {
                JSONObject histogramObject = new JSONObject();
                histogramObject = histogram.getHistogramAsJson();
                traceDetails.put("error_info", histogramObject.get("error_info"));
                traceDetails.put("error_params", histogramObject.get("error_params"));
                traceDetails.put("size_in_bytes", histogramObject.get("size_in_bytes"));
            } else {
                traceDetails.put("error_info", "");
                traceDetails.put("error_params", null);
                traceDetails.put("size_in_bytes", "");
            }
            traceDetails.putAll((JSONObject)traceJsonObj.get(i));
            this.eventsSender.addDataEvent(traceDetails);
        }
        boolean bl = hasCodePaths = details.getTraceDataJson().size() != 0;
        if (!hasCodePaths) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(actionHandler.getClassName());
            this.eventsSender.addUiEvent(actionHandler.getObjectUUID(), "apminsight.memoryleaks.trace.notrace", params);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Set<String> getActiveClasses() {
        return this.activeInstrumentedClasses;
    }

    public void finish() {
        this.enabled = false;
        if (this.traceFutureObj != null && !this.traceFutureObj.isCancelled()) {
            this.traceFutureObj.cancel(true);
        }
        this.traceFutureObj = null;
        ArrayList<String> removedClasses = new ArrayList<String>();
        for (ActionHandler actionHandler : this.activeTransactionalTraces.keySet()) {
            removedClasses.add(actionHandler.getClassName());
            ArrayList<String> params = new ArrayList<String>();
            params.add(actionHandler.getClassName());
            this.eventsSender.addUiEvent(actionHandler.getObjectUUID(), "apminsight.memoryleaks.trace.cancel", params);
        }
        if (!removedClasses.isEmpty()) {
            String[] clazzes = removedClasses.toArray(new String[removedClasses.size()]);
            JavaAgent.getInstance().getClassRetransformEngine().retransformIfEscapedFromInstrumentation(clazzes);
            JavaAgent.getInstance().getClassRetransformEngine().retransformEscaped();
        }
        this.eventsSender = null;
        this.activeTransactionalTraces.clear();
        this.activeTransactionalTraceMapper.clear();
        this.activeInstrumentedClasses.clear();
    }
}

