/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memory.calc.CalculatorUtil;
import com.manageengine.apminsight.agent.memoryleaks.config.LeakDetectionConfig;
import com.manageengine.apminsight.agent.memoryleaks.config.MemoryLeaksEvents;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.CollectionObjectRouter;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.LeakObservation;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.SchedulerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CollectionCounter {
    private volatile int objectCounter = 0;
    private final CollectionObjectRouter router;
    private final LeakObservation leakObservation;
    private ScheduledFuture<?> futureMetricDispatcher;
    private volatile boolean enabled = true;
    private volatile boolean inProcess = true;

    public CollectionCounter(LeakObservation leakObservation) {
        this.leakObservation = leakObservation;
        this.router = leakObservation.getRouter();
    }

    public void init() {
        JavaAgent.getInstance().getClassRetransformEngine().addClassesForMemoryLeakDetection();
        this.enabled = true;
        this.inProcess = true;
        this.futureMetricDispatcher = SchedulerManager.getGlobalScheduler().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                CollectionCounter.this.metricDispatcher();
            }
        }, 30L, 60L, TimeUnit.SECONDS);
        SchedulerManager.getGlobalScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                CollectionCounter.this.finish();
            }
        }, (long)(this.leakObservation.getCaptureTimeInMins() * 60), TimeUnit.SECONDS);
    }

    public void metricDispatcher() {
        if (this.enabled && this.inProcess) {
            ArrayList<Integer> params = new ArrayList<Integer>();
            params.add(this.objectCounter);
            MemoryLeaksEvents.getInstance().addUiEvent(0L, "apminsight.memoryleaks.collected.objects.size", params);
        }
    }

    public void addObjectToTrack(Object obj) {
        int collectionSize;
        int mapSize;
        if (!this.enabled) {
            return;
        }
        if (obj instanceof Map ? (mapSize = CalculatorUtil.getMapSize((Map)obj)) < LeakDetectionConfig.minimum_elements_to_deep_size_collection : obj instanceof Collection && (collectionSize = CalculatorUtil.getCollectionSize((Collection)obj)) < LeakDetectionConfig.minimum_elements_to_deep_size_collection) {
            return;
        }
        if (this.enabled && this.leakObservation.isActive() && this.inProcess) {
            this.router.addObject(obj);
            ++this.objectCounter;
        }
    }

    public void finish() {
        if (!this.enabled && !this.inProcess) {
            return;
        }
        this.enabled = false;
        this.inProcess = false;
        JavaAgent.getInstance().getClassRetransformEngine().removeClassesForMemoryLeakDetection();
        if (this.futureMetricDispatcher != null) {
            this.futureMetricDispatcher.cancel(false);
        }
        JavaAgent.logger.info("CollectionCounter has stopped");
        MemoryLeaksEvents.getInstance().addUiEvent(0L, "apminsight.memoryleaks.collection.stop");
    }
}

