/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.MemoryLeakCapturingTask;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.memory.calc.CalculatorUtil;
import com.manageengine.apminsight.agent.memory.calc.MemoryCalculator;
import com.manageengine.apminsight.agent.memoryleaks.actions.ObjectSummaryHandler;
import com.manageengine.apminsight.agent.memoryleaks.config.ActionHandler;
import com.manageengine.apminsight.agent.memoryleaks.config.AutomaticLeakDetection;
import com.manageengine.apminsight.agent.memoryleaks.config.LeakDetectionConfig;
import com.manageengine.apminsight.agent.memoryleaks.config.MemoryLeaksEvents;
import com.manageengine.apminsight.agent.memoryleaks.config.UserActionHandler;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectDetails;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectMonitor;
import com.manageengine.apminsight.agent.memoryleaks.monitor.RegressionModel;
import com.manageengine.org.json.simple.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class MemoryAnalyzer
implements Runnable {
    public ObjectMonitor objectMonitor;
    public ObjectSummaryHandler objectSummary;

    public MemoryAnalyzer(ObjectMonitor objectMonitor, ObjectSummaryHandler objectSummary) {
        this.objectMonitor = objectMonitor;
        this.objectSummary = objectSummary;
    }

    @Override
    public void run() {
        ArrayList<Long> removedIdsList;
        block18: {
            block17: {
                if (!ContextInfoManager.getInstance().getDefaultContextInfo().isActive()) {
                    AutomaticLeakDetection.getInstance();
                    if (AutomaticLeakDetection.isActive()) {
                        if (MemoryLeakCapturingTask.isOnDemandTaskAlreadyScheduled) {
                            MemoryLeakCapturingTask.isOnDemandTaskAlreadyScheduled = false;
                        }
                        AutomaticLeakDetection.getInstance().deActivate();
                    }
                    return;
                }
                removedIdsList = new ArrayList<Long>();
                if (!this.objectMonitor.isEnabled()) break block17;
                AutomaticLeakDetection.getInstance();
                if (AutomaticLeakDetection.isActive()) break block18;
            }
            return;
        }
        Map<Long, ObjectDetails> objectDetailsToSize = this.objectMonitor.getTrackedIdToObjectType();
        for (Map.Entry<Long, ObjectDetails> entry : objectDetailsToSize.entrySet()) {
            Long l = entry.getKey();
            if (l == null || l == -1L) continue;
            ObjectDetails details = (ObjectDetails)entry.getValue();
            if (details == null || details.getObject() == null) {
                removedIdsList.add(l);
                if (this.objectSummary.summaryMap.get(l) != null) {
                    this.objectSummary.summaryMap.remove(l);
                }
                if (this.objectSummary.dumpMap.get(l) != null) {
                    this.objectSummary.dumpMap.remove(l);
                }
                this.objectMonitor.removeLeakObject(l);
                JavaAgent.logger.info("object details is not available for id " + l + ", Object details " + details);
                MemoryLeaksEvents.getInstance().addUiEvent(l, "apminsight.memoryleaks.not.available");
                continue;
            }
            Object sizedObj = details.getObject();
            int currentSize = -1;
            if (details.isCollectionObject()) {
                currentSize = ((Collection)sizedObj).size();
            } else if (details.isMapObject()) {
                currentSize = ((Map)sizedObj).size();
            }
            if (currentSize <= -1) continue;
            MemoryCalculator memoryCalc = this.objectMonitor.getMemoryCalculator();
            memoryCalc.setObjectUUID(l);
            boolean summaryFlag = this.objectSummary.enableObjectContent(memoryCalc, currentSize, l);
            boolean dumpFlag = this.objectSummary.enableObjectDump(memoryCalc, l);
            if (summaryFlag || dumpFlag) {
                long objSize = memoryCalc.objectDeepSize(sizedObj);
                String formatSize = CalculatorUtil.formatInput(objSize);
                this.objectSummaryEvent(memoryCalc, currentSize, this.isPotentialLeak(l));
                this.objectPersistanceEvent(l, currentSize, memoryCalc);
            }
            this.objectSummary.closeObjectSummary(memoryCalc, l);
            this.objectSummary.closeObjectDump(memoryCalc, l);
            memoryCalc.setObjectUUID(-1L);
            this.monitorGrowthSimpleRegression(l, currentSize, memoryCalc);
            this.captureLeakObjectData();
        }
        Map<Long, ActionHandler> summaryMap = this.objectSummary.summaryMap;
        for (Long l : this.objectSummary.summaryMap.keySet()) {
            if (this.objectMonitor.isObjectIdExists(l)) continue;
            this.objectSummary.closeObjectSummary(this.objectMonitor.getMemoryCalculator(), l);
            this.objectSummary.closeObjectDump(this.objectMonitor.getMemoryCalculator(), l);
        }
        Map<Long, ActionHandler> dumpMap = this.objectSummary.dumpMap;
        for (Long id : this.objectSummary.summaryMap.keySet()) {
            if (this.objectMonitor.isObjectIdExists(id)) continue;
            this.objectSummary.closeObjectDump(this.objectMonitor.getMemoryCalculator(), id);
        }
        if (removedIdsList.size() > 0) {
            this.objectMonitor.removeObjectUUIDFromTrackedIds(removedIdsList);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("removed_ids", removedIdsList);
            jSONObject.put("type", MemoryLeaksEvents.MetricType.REMOVED_IDS.getType());
            MemoryLeaksEvents.getInstance().addDataEvent(jSONObject);
        }
    }

    public void objectPersistanceEvent(long objectUUID, int currentSize, MemoryCalculator memoryCalc) {
        if (!memoryCalc.isDumpEnabled()) {
            return;
        }
        long sizeInBytes = memoryCalc.getTotalSize();
        String fileName = memoryCalc.getPrevObjectPersistanceFileName();
        JSONObject fileNameJson = new JSONObject();
        fileNameJson.put("id", objectUUID);
        fileNameJson.put("elements_count", currentSize);
        fileNameJson.put("dump_file_name", fileName);
        fileNameJson.put("update_time", System.currentTimeMillis());
        fileNameJson.put("type", MemoryLeaksEvents.MetricType.OBJECT_PERSISTANCE.getType());
        MemoryLeaksEvents.getInstance().addDataEvent(fileNameJson);
    }

    public void objectSummaryEvent(MemoryCalculator memoryCalc, int currentSize, Boolean isPotentialLeak) {
        MemoryLeaksEvents.getInstance().addDataEvent(memoryCalc.objectSummaryData(), currentSize, isPotentialLeak);
    }

    public boolean isPotentialLeak(Long objectUUID) {
        long growthFactor;
        Boolean potentialLeak = Boolean.FALSE;
        RegressionModel model = this.objectMonitor.getRegressionModelForId(objectUUID);
        if (model != null && (growthFactor = model.getGrowthFactor()) > 0L) {
            potentialLeak = Boolean.TRUE;
        }
        return potentialLeak;
    }

    void monitorGrowthSimpleRegression(Long objectUUID, long currentSize, MemoryCalculator memoryCalc) {
        RegressionModel model = this.objectMonitor.getRegressionModelForId(objectUUID);
        if (model != null) {
            model.addData(System.currentTimeMillis(), currentSize);
            long growthFactor = model.getGrowthFactor();
            Boolean potentialLeak = Boolean.FALSE;
            if (growthFactor > 0L) {
                potentialLeak = Boolean.TRUE;
                if (this.objectMonitor.monitorLeakObject(objectUUID)) {
                    JavaAgent.logger.info("Leak Object monitoring started  with hashcode " + objectUUID + " & object name " + model.getObjectName());
                }
            } else if (this.objectMonitor.removeLeakObject(objectUUID)) {
                JavaAgent.logger.info("Leak Object Removed from monitoring with id  " + objectUUID + " & object name " + model.getObjectName());
            }
            JSONObject growthJsonMetric = new JSONObject();
            growthJsonMetric.put("id", objectUUID);
            growthJsonMetric.put("potential_leak", potentialLeak);
            growthJsonMetric.put("update_time", System.currentTimeMillis());
            growthJsonMetric.put("type", MemoryLeaksEvents.MetricType.GROWTH_REPORT.getType());
            growthJsonMetric.put("elements_count", currentSize);
            MemoryLeaksEvents.getInstance().addDataEvent(growthJsonMetric);
        }
    }

    public void captureLeakObjectData() {
        if (this.objectMonitor.getLeakObject().size() > 0) {
            LinkedHashMap<Long, Boolean> leakObjectDup = new LinkedHashMap<Long, Boolean>(this.objectMonitor.getLeakObject());
            int transactionTraceMillis = LeakDetectionConfig.default_transaction_trace_session_in_millis;
            int summaryMillis = LeakDetectionConfig.default_summary_session_in_millis;
            for (Long objectUUID : leakObjectDup.keySet()) {
                UserActionHandler action = new UserActionHandler(-1L, objectUUID, 2, summaryMillis);
                this.objectSummary.addUserAction(action.getHandler());
                action = new UserActionHandler(-1L, objectUUID, 3, transactionTraceMillis);
                AutomaticLeakDetection.getInstance().getObjectTraceHandler().addUserAction(action.getHandler());
            }
        }
    }
}

