/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.monitor.collections;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.CollectedObjectShifter;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.CollectionObjectCollector;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.CollectionValidator;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.LeakObservation;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.MemoryLeaksHolder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class CollectionObjectRouter {
    protected static final int COLLECTOR_PERIOD_IN_SECONDS = 30;
    private static final int VALIDATOR_PERIOD_IN_SECONDS = 60;
    private List<CollectionObjectCollector> completedList = new ArrayList<CollectionObjectCollector>();
    private List<MemoryLeaksHolder> memoryLeakCollectionList = new LinkedList<MemoryLeaksHolder>();
    private AtomicReference<CollectionObjectCollector> currentCollector = new AtomicReference<CollectionObjectCollector>(new CollectionObjectCollector(this));
    private CollectionValidator validator = new CollectionValidator(this);
    public static CollectionObjectRouter objName;
    private CollectedObjectShifter objectShifter = new CollectedObjectShifter(this);
    protected final ScheduledFuture<?> shifterSchedule;
    protected final ScheduledFuture<?> collectionValidatorScheduler;
    protected volatile int collectorCounter = 0;
    protected volatile int objectLimitExceedCount = 0;
    protected long endTimeInMillis = 0L;
    private volatile boolean isFinalValidator = false;
    private volatile boolean isFinalValidationHappend = false;
    private volatile boolean isFinalShifter = false;
    private volatile boolean isFinalShiftHappend = false;
    private int collectionCapturePeriodMins;
    private int collectionMinAgeMins;

    public CollectionObjectRouter(ScheduledExecutorService scheduler, LeakObservation leaks) {
        this.shifterSchedule = scheduler.scheduleAtFixedRate(this.objectShifter, 30L, 30L, TimeUnit.SECONDS);
        this.collectionValidatorScheduler = scheduler.scheduleAtFixedRate(this.validator, 40L, 60L, TimeUnit.SECONDS);
        this.endPeriodScheduler(scheduler, leaks.getCaptureTimeInMins(), leaks.getObjectDurationInMins());
    }

    protected void endPeriodScheduler(ScheduledExecutorService scheduler, int collectionCapturePeriodMins, int collectionMinAgeMins) {
        this.collectionCapturePeriodMins = collectionCapturePeriodMins;
        this.collectionMinAgeMins = collectionMinAgeMins;
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                CollectionObjectRouter.this.isFinalShifter = true;
            }
        }, (long)(this.collectionCapturePeriodMins * 60), TimeUnit.SECONDS);
        scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                CollectionObjectRouter.this.isFinalValidator = true;
            }
        }, (long)((this.collectionCapturePeriodMins + this.collectionMinAgeMins) * 60), TimeUnit.SECONDS);
    }

    public void addObject(Object obj) {
        if (!this.isFinalShiftHappend) {
            this.currentCollector.get().addObject(obj);
        }
    }

    private static void setInstance(CollectionObjectRouter obj) {
        objName = obj;
    }

    private static CollectionObjectRouter getInstance() {
        return objName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryLeaksHolder[] getMemoryLeakCollectionArr() {
        MemoryLeaksHolder[] data = null;
        List<MemoryLeaksHolder> list = this.memoryLeakCollectionList;
        synchronized (list) {
            JavaAgent.logger.info(" MemoryLeaksHolder list is evacuating with size " + this.memoryLeakCollectionList.size());
            data = this.memoryLeakCollectionList.toArray(new MemoryLeaksHolder[this.memoryLeakCollectionList.size()]);
            this.memoryLeakCollectionList.clear();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isObjectsCollectionsFinished() {
        List<MemoryLeaksHolder> list = this.memoryLeakCollectionList;
        synchronized (list) {
            return this.memoryLeakCollectionList.isEmpty() && this.isFinalValidationHappend;
        }
    }

    public void endAllSchedulingObjects() {
        this.currentCollector.set(null);
        this.clearCompletedList();
        this.shifterSchedule.cancel(true);
        this.collectionValidatorScheduler.cancel(true);
        this.clearCollectionList();
        this.isFinalShiftHappend = true;
        this.isFinalValidationHappend = true;
    }

    protected void cancelShifterSchedule() {
        if (!this.shifterSchedule.isCancelled()) {
            this.shifterSchedule.cancel(true);
        }
    }

    protected void cancelValidatorSchedule() {
        if (!this.collectionValidatorScheduler.isCancelled()) {
            this.collectionValidatorScheduler.cancel(false);
        }
    }

    public CollectionObjectCollector setAndGetOldCollector(CollectionObjectCollector newCollector) {
        CollectionObjectCollector oldCollector = this.currentCollector.getAndSet(newCollector);
        oldCollector.done();
        return oldCollector;
    }

    public List<CollectionObjectCollector> getCompletedList() {
        return this.completedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCompletedList() {
        List<CollectionObjectCollector> list = this.completedList;
        synchronized (list) {
            this.completedList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCollectionList() {
        List<MemoryLeaksHolder> list = this.memoryLeakCollectionList;
        synchronized (list) {
            this.memoryLeakCollectionList.clear();
        }
    }

    public List<MemoryLeaksHolder> getMemoryLeakCollectionList() {
        return this.memoryLeakCollectionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToMemoryLeakCollectionList(List<MemoryLeaksHolder> list) {
        List<MemoryLeaksHolder> list2 = this.memoryLeakCollectionList;
        synchronized (list2) {
            this.memoryLeakCollectionList.addAll(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCompletedList(CollectionObjectCollector oldCollectorObj) {
        List<CollectionObjectCollector> list = this.completedList;
        synchronized (list) {
            this.completedList.add(oldCollectorObj);
        }
    }

    public int getCollectionCapturePeriodMins() {
        return this.collectionCapturePeriodMins;
    }

    public int getCollectionMinAgeMins() {
        return this.collectionMinAgeMins;
    }

    public boolean isFinalValidator() {
        return this.isFinalValidator;
    }

    public void setFinalValidator(boolean isFinalValidator) {
        this.isFinalValidator = isFinalValidator;
    }

    public boolean isFinalValidationHappend() {
        return this.isFinalValidationHappend;
    }

    public void setFinalValidationHappend(boolean isFinalValidationHappend) {
        this.isFinalValidationHappend = isFinalValidationHappend;
    }

    public boolean isFinalShifter() {
        return this.isFinalShifter;
    }

    public void setFinalShifter(boolean isFinalShifter) {
        this.isFinalShifter = isFinalShifter;
    }

    public boolean isFinalShiftHappend() {
        return this.isFinalShiftHappend;
    }

    public void setFinalShiftHappend(boolean isFinalShiftHappend) {
        this.isFinalShiftHappend = isFinalShiftHappend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishAll() {
        this.currentCollector.set(null);
        List<Object> list = this.completedList;
        synchronized (list) {
            this.completedList.clear();
        }
        this.shifterSchedule.cancel(true);
        this.collectionValidatorScheduler.cancel(true);
        list = this.memoryLeakCollectionList;
        synchronized (list) {
            this.memoryLeakCollectionList.clear();
        }
        this.setFinalShiftHappend(Boolean.TRUE);
        this.setFinalValidationHappend(Boolean.TRUE);
    }
}

